/**
 * 支部制度
 */

import * as asyncHandler from 'express-async-handler';
import * as branchSystemBiz from '../biz/branchSystem';
import { checkToken } from '../middleware/user';
import { eccReqParamater } from '../tools/eccParam';

export function setRouter(httpServer) {
    httpServer.post('/yfs/admin/branchsystem/list', checkToken, asyncHandler(branchSystemList));
    httpServer.post('/yfs/admin/branchsystem/add', checkToken, asyncHandler(addBranchSystem));
    httpServer.post('/yfs/admin/branchsystem/del', checkToken, asyncHandler(delBranchSystem));
    httpServer.post('/yfs/admin/branchsystem/open', checkToken, asyncHandler(openBranchSystem));
    httpServer.post('/yfs/admin/branchsystem/close', checkToken, asyncHandler(closeBranchSystem));
    httpServer.post('/yfs/admin/branchsystem/info', checkToken, asyncHandler(branchSystemInfo));
    httpServer.post('/yfs/admin/branchsystem/update', checkToken, asyncHandler(updateBranchSystem));
}


/**
 * 支部制度列表
 * @param req 
 * @param res 
 */
async function branchSystemList(req, res) {
    let userInfo = req.userInfo;

    let reqConf = {title:'String', pageNumber:'Number'};
    let { title, pageNumber } = eccReqParamater(reqConf, req.body, ["title"]);
    
    let result = await branchSystemBiz.getBranchSystemList(userInfo, title, pageNumber);

    res.success(result);
}


/**
 * 添加支部制度
 * @param req 
 * @param res 
 */
async function addBranchSystem(req, res) {
    let userInfo = req.userInfo;

    let reqConf = {title:'String', branch:'[Number]', filesNameList:'[String]' };
    let { title, branch, filesNameList } = eccReqParamater(reqConf, req.body, ["filesNameList"]);
    
    let result = await branchSystemBiz.addBranchSystemInfo(userInfo, title, branch, filesNameList);

    res.success(result);
}


/**
 * 修改支部制度
 * @param req 
 * @param res 
 */
async function updateBranchSystem(req, res) {
    let userInfo = req.userInfo;

    let reqConf = {title:'String', branch:'[Number]', filesNameList:'[String]', bsId:'Number' };
    let { title, branch, filesNameList, bsId } = eccReqParamater(reqConf, req.body, ["filesNameList"]);
    
    let result = await branchSystemBiz.updateBranchSystemInfo(userInfo, bsId, title, branch, filesNameList);

    res.success(result);
}


/**
 * 回显支部制度
 * @param req 
 * @param res 
 */
async function branchSystemInfo(req, res) {
    let userInfo = req.userInfo;

    let reqConf = { bsId:'Number' };
    let { bsId } = eccReqParamater(reqConf, req.body, []);
    
    let result = await branchSystemBiz.getBranchSystemInfo(userInfo, bsId);

    res.success(result);
}


/**
 * 打开状态
 * @param req 
 * @param res 
 */
async function openBranchSystem(req, res) {
    let userInfo = req.userInfo;

    let reqConf = { bsId:'Number' };
    let { bsId } = eccReqParamater(reqConf, req.body, []);
    
    let result = await branchSystemBiz.changeBranchSystemState(userInfo, bsId, true);

    res.success(result);
}


/**
 * 关闭状态
 * @param req 
 * @param res 
 */
async function closeBranchSystem(req, res) {
    let userInfo = req.userInfo;

    let reqConf = { bsId:'Number' };
    let { bsId } = eccReqParamater(reqConf, req.body, []);
    
    let result = await branchSystemBiz.changeBranchSystemState(userInfo, bsId, false);

    res.success(result);
}


/**
 * 删除
 * @param req 
 * @param res 
 */
async function delBranchSystem(req, res) {
    let userInfo = req.userInfo;

    let reqConf = { bsId:'Number' };
    let { bsId } = eccReqParamater(reqConf, req.body, []);
    
    let result = await branchSystemBiz.delBranchSystemData(userInfo, bsId);

    res.success(result);
}
