import { OPERATIONALDATATYPE, TABLENAME } from "../config/enum/enum";
import { ERRORENUM } from "../config/enum/errorEnum";
import { selectData } from "../data/operationalData";
import { BizError } from "../util/bizError";

/**
 * 中间件 校验孵化器token
 * @param req 
 * @param res 
 * @param next 
 * @returns 
 */
export async function checkToken(req, res, next) {
    if (!req.headers) req.headers = {};
    let userId = req.headers.userid;
    let token = req.headers.token;

    if (!userId || !token) return next(new BizError(ERRORENUM.非法登录));

    if (userId == "admin") {
        let userInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.后台用户表, {uId:userId}, null);
        if (!userInfo || !userInfo.uId) return next(new BizError(ERRORENUM.身份验证失败));
        if (!userInfo.token || userInfo.token != token) return next(new BizError(ERRORENUM.身份验证过期));
        req.userInfo = {
            branch:0,
            isSuperAdmin:true,
            userId,
        };
    }
    else {
        let userInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.党员基础信息表, {pmId:userId}, null);
        if (!userInfo || !userInfo.pmId) return next(new BizError(ERRORENUM.身份验证失败));
        if (!userInfo.adminToken || userInfo.adminToken != token) return next(new BizError(ERRORENUM.身份验证过期));

        req.userInfo = {
            branch:userInfo.bId,
            isSuperAdmin:false,
            userId,
        };
    }

    next();
}
