const path = require('path');
import * as fs from "fs";
import { BizError } from "../util/bizError";
import { analysisXml } from "../util/myXML";
import { ServerConfig } from "../config/systemClass";

export let systemConfig =  new ServerConfig;

const ConfigName = "serverConfig.xml";
export async function initConfig() {
    try {
        let buff = fs.readFileSync(path.join(__dirname.substring(0,__dirname.indexOf("out")), ConfigName));
        let configStr = buff.toString();
        let configInfo:any = await analysisXml(configStr);
		if (!configInfo || !configInfo.config) throw new BizError('xml中无配置');
		else {
            
            let {port, dbHost, dbPort, sign } = configInfo.config;
            systemConfig.port = parseInt(port[0]);
            systemConfig.dbPath = analysisDBPathStr(dbHost[0], dbPort[0]);
            
            systemConfig.sign = sign[0];
		}
        
        console.log("config init success");

    } catch(err) {
        console.log('ERROR => 服务器配置解析错误 请检查根目录下 serverConfig.xml 文件是否正确');
        console.log(err);
        throw new BizError("服务器配置解析错误 请检查根目录下 serverConfig.xml 文件是否正确");
    }
}

function analysisDBPathStr(host, port) {
    let str = `http://${host}:${port}`;
    console.log("请确认，数据中心地址:", str);
    return str;
}
