/**
 * 用户相关主要逻辑
 */

import { OPERATIONALDATATYPE, TABLENAME } from "../config/enum/enum";
import { ERRORENUM } from "../config/enum/errorEnum";
import { operationalData, selectData } from "../data/operationalData";
import { getMySqlMs, getUserToken } from "../tools/systemTools";
import { BizError } from "../util/bizError";

export async function loginAdminSys(loginId:string, pwd:string) {
    let resultInfo = {branch:-1, token:'', userId:'', isAdmin:false};
    if (loginId == "admin") { /**超级管理员 */
        let userInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.后台用户表, {loginId}, null);
        if (!userInfo || !userInfo.uId) throw new BizError(ERRORENUM.用户不存在, `不存在loginId=${loginId}的用户`);
        if (userInfo.pwd != pwd) throw new BizError(ERRORENUM.密码错误);
        let token = getUserToken(loginId);
        let tokenMs = getMySqlMs();

        await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.后台用户表, {token, tokenMs}, {loginId});

        resultInfo.branch = 0;
        resultInfo.isAdmin = true;
        resultInfo.token = token;
        resultInfo.userId = userInfo.uId;

    } else {
        let userInfo = await selectData(OPERATIONALDATATYPE.查询单个, TABLENAME.党员基础信息表, {loginId}, null);
        if (!userInfo || !userInfo.pmId) throw new BizError(ERRORENUM.用户不存在, `不存在loginId=${loginId}的用户`);
        if (!userInfo.isAdmin) throw new BizError(ERRORENUM.该用户不是管理员);
        if (userInfo.pwd != pwd) throw new BizError(ERRORENUM.密码错误);

        let token = getUserToken(loginId);
        let tokenMs = getMySqlMs();

        await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.党员基础信息表, {adminToken:token, adminTokenMs:tokenMs}, {loginId});

        resultInfo.branch = userInfo.bId;
        resultInfo.token = token;
        resultInfo.userId = userInfo.pmId;
    }

    return resultInfo;
}


export async function logout(userId:string, isAdmin:boolean) {
    if (isAdmin) {
        await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.后台用户表, {token:''}, {uId:userId});
    } else {
        await operationalData(OPERATIONALDATATYPE.修改, TABLENAME.党员基础信息表, {adminToken:''}, {pmId:userId});
    }
    return {isSuccess:true};
}