/**
 * 组织架构
 */

import { BRANCHNAME, OPERATIONALDATATYPE, PARTYPOSITIONS, TABLENAME } from "../config/enum/enum";
import { selectData } from "../data/operationalData";
import { changeEnumValue } from "../tools/eccEnum";


/**
 * 获取组织架构
 * @returns 
 */
export async function getOrganization() {
    /**树形结构
     * {title:"", manager:[{title:"", name:"" }], subList:[{title:"", manager:[title:"", name:""], ordinary:[] }] }
     */
    let organizationInfo = {title:"党总支", manager:[], subList:[] };
    let column = ["name", "bId", "partyPositionsName"];
    let memberList = await selectData(OPERATIONALDATATYPE.查询多个, TABLENAME.党员基础信息表, {}, column);

    let branchMap = {};// 支部名称:{ ordinary:[], manager:[{title:"", name:"" }] } 
    memberList.forEach(info => {
        let {name, bId, partyPositionsName} = info;
        let bName = changeEnumValue(BRANCHNAME, bId);
        if ( !branchMap[bName] ) branchMap[bName] = {ordinary:[], manager:[]};
        let partyPositionsList = JSON.parse(partyPositionsName);

        let inOrdinary = true;
        partyPositionsList.forEach(pId => {
            inOrdinary = false;
            let managerInfo = {
                title:changeEnumValue(PARTYPOSITIONS, pId),
                name
            };
            if (pId < PARTYPOSITIONS.支部书记) { /**总支干部 */
                organizationInfo.manager.push(managerInfo);
            } else {/**支部干部 */
                branchMap[bName].manager.push(managerInfo);
            }
        });

        if (inOrdinary) {
            branchMap[bName].ordinary.push(name);
        }
    });
    
    for (let title in branchMap) {
        let {ordinary, manager} = branchMap[title];
        organizationInfo.subList.push({
            title,
            ordinary,
            manager
        });
    }

    return {organizationInfo};
}