/**
 * 官网
 */

import moment = require("moment");
import { ARTICLEPOSITION, BANNERPOSITION, BRANCHPOSITION, CODPARTICIPANT, DANGJIANVIDEO, DONGTAIZIXUNSUBTYPE, IMGEDITFUNENUM, INDIVIDUALMEMBERTYPE, MEMBERLEVEL, MEMBERTYPE, PARTYBUILDSUBTYPEENUM, PARTYBUILDTYPEENUM, PAYMENTSTATUS, STATE, TONGZHIGONGGAO, UNITMEMBERTYPE, USERREGISTERSTATE, XUEHUILINGDAOZHIWEI } from "../config/enum";
import { TABLEENUM } from "../data/models/model";
import { find, findCount, findOnce, findToPage, findToSort, findToSortToPage } from "../data/select";
import { extractData } from "../util/piecemeal";
import { changeEnumValue, eccEnumValue } from "../util/verificationEnum";
import { BizError } from "../util/bizError";
import { ERRORENUM } from "../config/errorEnum";
import { getCityNameByCode } from "../config/cityConfig";
import { getEdition } from "../tools/system";

export async function banner() {
    let result = {
        bannerList:[],//banner
    };
    /**banner */
    let localBanners = [BANNERPOSITION.首页_hghbanner01, BANNERPOSITION.首页_hghbanner02, BANNERPOSITION.首页_hghbanner03];
    // let bannerData = await find(TABLEENUM.banner管理, {location:{"$in":localBanners}, display:STATE.是} );
    let bannerData = await findToSort(TABLEENUM.banner管理, {location:{"$in":localBanners}, display:STATE.是},{location:1});
    for (let i= 0; i < bannerData.length; i++) {
        let {imgUrl, articleTitle, desc, articleUrl} = bannerData[i];

        let articleTitleStr = '';
        if (articleTitle) {
            let articleInfo = await findOnce(TABLEENUM.文章管理, {id:articleTitle}, ["id", "title"]);
            articleTitleStr = articleInfo && articleInfo.id ? articleInfo.title : '';
        }

        result.bannerList.push({imgUrl, title:articleTitleStr, desc, articleUrl:articleUrl|| null, id:articleTitle});
    }
    return result;
}


/**
 * 首页除了banner
 * @returns 
 */
export async function homePage() {
    let result = {
        zhuanTi:[],//专题系列
        xueHuiDongTai:[],//学会动态
        huoDongTongZhi:[],//活动通知
        reDianShiPin:[]//热点视频
    };

   
    /**专题系列 */
    let zhuanTiData = await find(TABLEENUM.专题系列, {});
    zhuanTiData.sort((a, b) => {return a.rank - b.rank});
    zhuanTiData.forEach(info => {
        let {rank, title, articleUrl, imgUrl, articleTitle} = info;
        result.zhuanTi.push({rank, title, articleUrl, imgUrl, id:articleTitle});
    });
    /**学会动态 每个动态资讯取最新的可见的两个*/
    /**动态资讯 2025年1月13日 改为【取网站文章管理最新发布的10条内容，除了通知公告，其他所有板块都要取】 */
    let wenZhangTypeList = [ARTICLEPOSITION.通知公告_hgh会议通知, ARTICLEPOSITION.通知公告_hgh活动通知, ARTICLEPOSITION.通知公告_hgh项目公告];
    // let wenZhangTypeList = [ARTICLEPOSITION.动态资讯_hgh学会动态, ARTICLEPOSITION.动态资讯_hgh政策动向, ARTICLEPOSITION.动态资讯_hgh行业风采, 
        // ARTICLEPOSITION.品牌项目_hgh学术研究, ARTICLEPOSITION.品牌项目_hgh展演竞赛, ARTICLEPOSITION.品牌项目_hgh社会服务, ARTICLEPOSITION.学习园地_文字资料, 
        // ARTICLEPOSITION.学会概况_hgh学会规章];
    // let dongTaiZiXunData = await findToSort(TABLEENUM.文章管理, {articleType:{"$in":wenZhangTypeList }, display:STATE.是}, {articleTime:-1});
    let dongTaiZiXunData = await findToSort(TABLEENUM.文章管理, {articleType:{"$nin":wenZhangTypeList}, display:STATE.是}, {articleTime:-1});

    dongTaiZiXunData.sort((a, b) => {return b.articleTime - a.articleTime});
    let dongTaiZiXunDistinctMap = {1:[]};
    let top18dongTaiZiXun = dongTaiZiXunData.slice(0, 18);
    top18dongTaiZiXun.forEach(info => {
        let { articleType, id, title, imgUrl, articleTime, desc } = info;
        dongTaiZiXunDistinctMap["1"].push({id, title, imgUrl, articleTime:moment(articleTime).format("YYYY-MM-DD"), desc});
        articleType.forEach( articles => {
            // if (!dongTaiZiXunDistinctMap[articles]) dongTaiZiXunDistinctMap[articles] = [];
            // dongTaiZiXunDistinctMap[articles].push({
            
            // });
            // if (dongTaiZiXunDistinctMap[articles].length < 10) {}
        })
    });

    for (let key in dongTaiZiXunDistinctMap) {
        result.xueHuiDongTai.push({
            key,
            value:dongTaiZiXunDistinctMap[key]
        });
    }

    /**活动通知 */
    // let huoDongTongZhiData = await find(TABLEENUM.活动通知, { push:STATE.是 } );//todo 二期优化点 在获取数据时取最新6条
    // huoDongTongZhiData.sort((a, b) => {return a.st - b.st});
    // huoDongTongZhiData.forEach(info => {
    //     let {id, name, st} = info;
    //     result.huoDongTongZhi.push({
    //         id, name, time:moment(st).format("YYYY-MM-DD")
    //     });
    // });
    let huoDongTongZhiSelectList = [ARTICLEPOSITION.通知公告_hgh活动通知, ARTICLEPOSITION.通知公告_hgh会议通知, ARTICLEPOSITION.通知公告_hgh项目公告];
    let huoDongTongZhiDataFindParam = {articleType:{"$in":huoDongTongZhiSelectList}, display:STATE.是};
    // let huoDongTongZhiDataList = await findToSortToPage(TABLEENUM.文章管理, huoDongTongZhiDataFindParam, ["articleTime", "id", "title", "articleType"], {articleTime:-1}, 1);
    let huoDongTongZhiDataList = await findToSort(TABLEENUM.文章管理, huoDongTongZhiDataFindParam, {articleTime:-1}, ["articleTime", "id", "title", "articleType"]);
    huoDongTongZhiDataList.forEach(info => {
        let { id, title, articleTime, articleType } = info;
        let value = 9;
        for (let i= 0; i < articleType.length; i++) {
            if (huoDongTongZhiSelectList.indexOf(articleType[i]) > -1) {
                value = articleType[i];
                break;
            }
        }
        result.huoDongTongZhi.push({
            id, title, articleTime:moment(articleTime).format("YYYY-MM-DD"), value
        });
    });


    /**热点视频*/
    let reDianShiPinData = await find(TABLEENUM.视频管理, { display:STATE.是 } );
    reDianShiPinData.sort((a, b) => {return a.videoTime - b.videoTime});
    for (let i= 0; i < reDianShiPinData.length; i++) {
        let {title, desc, videoUrl, coverUrl} = reDianShiPinData[i];
        result.reDianShiPin.push({title, desc, videoUrl:videoUrl, coverUrl});
        if (i >= 4) break;
    }

    return result;
}


/**
 * 学会概况banner
 * @returns 
 */
export async function xueHuiGaiKuangBanner() {
    let result = {
        bannerList:[],//banner
    };
    /**banner */
    let localBanners = [BANNERPOSITION.学会概况_hghbanner01, BANNERPOSITION.学会概况_hghbanner02, BANNERPOSITION.学会概况_hghbanner03];
    let bannerData = await find(TABLEENUM.banner管理, {location:{"$in":localBanners}, display:STATE.是} );
    for (let i= 0; i < bannerData.length; i++) {
        let {imgUrl, articleTitle, desc, articleUrl} = bannerData[i];

        let articleTitleStr = '';
        if (articleTitle) {
            let articleInfo = await findOnce(TABLEENUM.文章管理, {id:articleTitle}, ["id", "title"]);
            articleTitleStr = articleInfo && articleInfo.id ? articleInfo.title : '';
        }

        // let articleInfo = await findOnce(TABLEENUM.文章管理, {id:articleTitle}, ["id", "title"]);
        // let articleTitleStr = articleInfo && articleInfo.id ? articleInfo.title : '';

        result.bannerList.push({imgUrl, title:articleTitleStr, desc, articleUrl:articleUrl || null, id:articleTitle});
    }
    return result;
}

/**
 * 学会概况
 * @returns 
 */
export async function xueHuiGaiKuang() {
    let result = {
        xueHuiGaiKuang:{},//学会概况
        xueHuiLingDao:[],//学会领导
        zuZhiJiaGou:[],//组织架构
        xueHuiGuiZhang:[],//学会规章
    };

    /**学会概况 */
    let xueHuiGaiKuangData = await findOnce(TABLEENUM.学会概括, {} );
    result.xueHuiGaiKuang = extractData(xueHuiGaiKuangData, ["title", "desc", "imgList"]);

    /**学会领导 */
    let xueHuiLingDaoData = await find(TABLEENUM.学会领导, {} );
    xueHuiLingDaoData.sort((a, b) => {return a.rank - b.rank});
    xueHuiLingDaoData.forEach(info => {
        let item:any = extractData(info, ["name", "position", "imgUrl", "desc"]);
        item.position = changeEnumValue(XUEHUILINGDAOZHIWEI, item.position);
        result.xueHuiLingDao.push(item);
    });

    /**组织架构 */
    let zuZhiJiaGouData = await find(TABLEENUM.学会架构, {display:1} );
    zuZhiJiaGouData.forEach(info => {
        result.zuZhiJiaGou.push(extractData(info, ["departmentName", "desc"]));
    });

    /**学会规章 */
    let xueHuiGuiZhangData = await findToSort(TABLEENUM.文章管理, {articleType:{"$in":[ARTICLEPOSITION.学会概况_hgh学会规章]}, display:STATE.是},{articleTime:-1} );
    for (let i = 0; i < xueHuiGuiZhangData.length; i++) {
        let {id, title, imgUrl, articleTime, desc} = xueHuiGuiZhangData[i];
        let articleDate = moment(articleTime);
        result.xueHuiGuiZhang.push({
            id, title, yearAndMonth:articleDate.format("YYYY-MM"), day:articleDate.format("DD"),desc
        });
    }

    return result;
}


/**
 * 学会概况详细信息
 * @returns 
 */
export async function xueHuiGaiKuangXiangQing() {
    let xueHuiGaiKuangData = await findOnce(TABLEENUM.学会概括, {} );
    if (!xueHuiGaiKuangData || !xueHuiGaiKuangData.id) return {dataInfo:{}};
    let dataInfo:any = extractData(xueHuiGaiKuangData, ["title", "desc", "imgList"]);
    dataInfo.articleTime = moment(xueHuiGaiKuangData.ut).format("YYYY-MM-DD");

    return {dataInfo};
}


/**
 * 规章列表分页
 * @param param0 
 * @returns 
 */
export async function guiZhangLieBiaoFenYe({pageNumber}) {
    let findParam = {articleType:{"$in":[ARTICLEPOSITION.学会概况_hgh学会规章]}, display:STATE.是};
    let wenZhangGuanLi = await findToSortToPage(TABLEENUM.文章管理, findParam, [], {articleTime:-1}, pageNumber);
    let dataCount = await findCount(TABLEENUM.文章管理, findParam);

    let dataList = [];
    wenZhangGuanLi.forEach(info => {
        let itemData:any = extractData(info, ["id", "articleTime", "title", "desc"]);
        itemData.articleTime = moment(itemData.articleTime).format("YYYY-MM-DD");
        dataList.push(itemData);
    });

    return { dataList, dataCount };
}


/**
 * 学会规则详情
 * @param param0 
 * @returns 
 */
export async function guiZhangZhiDuXiangQing({id}) {
    let dataBaseInfo = await findOnce(TABLEENUM.文章管理, {id, display:STATE.是});
    if (!dataBaseInfo || !dataBaseInfo.id) {
        throw new BizError(ERRORENUM.目标数据不存在);
    }
    let dataInfo:any = extractData(dataBaseInfo, [ "articleTime", "title", "desc", "files"]);
    dataInfo.articleTime = moment(dataInfo.articleTime).format("YYYY-MM-DD");
    dataInfo.source = "中国艺术职业教育学会";

    return {dataInfo};
}


/**
 * 动态资讯
 * @param param0 
 * @returns 
 */
export async function dongTaiZiXun({searchValue, type, pageNumber}) {
    eccEnumValue("官网", "行业动态类型", type, DONGTAIZIXUNSUBTYPE);
    let findParam = {
        articleType:{"$in":[type]}, 
        display:STATE.是, 
        "$or":[ 
            {
                title:{"$regex":searchValue, "$options": "i"}
            }, 
            {
                desc:{"$regex":searchValue, "$options": "i"}
            }
        ]
    };
    let dataBaseList = await findToSortToPage(TABLEENUM.文章管理, findParam, [], {articleTime:-1}, pageNumber);
    let dataCount = await findCount(TABLEENUM.文章管理, findParam);

    let dataList = [];
    dataBaseList.forEach(info => {
        let { id, title, desc, imgUrl, articleTime } = info;
        let descStr = desc.replace(/<[^>]*>/g, '');
        dataList.push({
            id, title, desc, descStr, imgUrl, articleTime:moment(articleTime).format("YYYY-MM-DD")
        });
    });

    return {dataList, dataCount};
}


/**
 * 文章详情
 * @param param0 
 * @returns 
 */
export async function wenZhangXiangQing({id}) {
    let dataBaseInfo = await findOnce(TABLEENUM.文章管理, {id, display:STATE.是});
    if (!dataBaseInfo || !dataBaseInfo.id) {
        throw new BizError(ERRORENUM.目标数据不存在);
    }
    let dataInfo:any = extractData(dataBaseInfo, [ "articleTime", "imgUrl", "title", "desc", "files"]);
    dataInfo.articleTime = moment(dataInfo.articleTime).format("YYYY-MM-DD");
    dataInfo.source = "中国艺术职业教育学会";

    return {dataInfo};
}


/**
 * 品牌项目banner
 * @returns 
 */
export async function pinPaiXiangMuBanner() {
    let result = {
        bannerList:[],//banner
    };
    /**banner */
    let localBanners = [BANNERPOSITION.品牌项目_hghbanner01, BANNERPOSITION.品牌项目_hghbanner02, BANNERPOSITION.品牌项目_hghbanner03];
    let bannerData = await find(TABLEENUM.banner管理, {location:{"$in":localBanners}, display:STATE.是} );
    
    for (let i=  0; i <bannerData.length; i++ ) {
        let {imgUrl, articleTitle, desc, articleUrl} = bannerData[i];
       
        let articleTitleStr = '';
        if (articleTitle) {
            let articleInfo = await findOnce(TABLEENUM.文章管理, {id:articleTitle}, ["id", "title"]);
            articleTitleStr = articleInfo && articleInfo.id ? articleInfo.title : '';
        }

        // let articleInfo = await findOnce(TABLEENUM.文章管理, {id:articleTitle}, ["id", "title"]);
        // let articleTitleStr = articleInfo && articleInfo.id ? articleInfo.title : '';
        result.bannerList.push({imgUrl, title:articleTitleStr, desc, articleUrl:articleUrl||null, id:articleTitle});
    }
    return result;
}


/**
 * 品牌项目信息
 * @returns 
 */
export async function pinPaiXiangMu() {
    let result = {
        xiangCunZhenXing:[],//乡村振兴
        fangHuaBei:[],//芳华杯
        xueShuYanJiu:[],//学术研究
        xueShuYanJiuImgList:[]//学术研究图片
    };
    /**乡村振兴 */
    let locationParam = [ARTICLEPOSITION.品牌项目_hgh社会服务];
    let xiangCunZhenXingData = await findToSort(TABLEENUM.文章管理, {articleType:{"$in":locationParam}, display:STATE.是}, {articleTime:-1} );
    xiangCunZhenXingData.forEach(info => {
        let {id, title, imgUrl, articleTime, desc} = info;
        result.xiangCunZhenXing.push({
            id, title, imgUrl, articleTime:moment(articleTime).format("YYYY-MM-DD"), desc
        });
    });
    /**芳华杯 */
    locationParam = [ARTICLEPOSITION.品牌项目_hgh展演竞赛];
    let fangHuaBeiData = await findToSortToPage(TABLEENUM.文章管理, {articleType:{"$in":locationParam}, display:STATE.是},["id", "title", "imgUrl", "articleTime", "desc"], {articleTime:-1}, 1, 10 );
    fangHuaBeiData.forEach(info => {
        let {id, title, imgUrl, articleTime, desc} = info;
        result.fangHuaBei.push({
            id, title, imgUrl, articleTime:moment(articleTime).format("YYYY-MM-DD"), desc
        });
    });
    /**学术研究 */
    locationParam = [ARTICLEPOSITION.品牌项目_hgh学术研究];
    let xueShuYanJiuData = await findToSort(TABLEENUM.文章管理, {articleType:{"$in":locationParam}, display:STATE.是}, {articleTime:-1} );
    xueShuYanJiuData.forEach(info => {
        let {id, title, imgUrl, articleTime, desc} = info;
        result.xueShuYanJiu.push({
            id, title, imgUrl, articleTime:moment(articleTime).format("YYYY-MM-DD"), desc
        });
    });
    /**学术研究图片 */
    let xueShuYanJiuImgData = await find(TABLEENUM.图片编辑, {type:IMGEDITFUNENUM.学术研究});
    xueShuYanJiuImgData.forEach((info) => {
        let {index, imgUrl} = info;
        result.xueShuYanJiuImgList.push({index, imgUrl});
    });
    result.xueShuYanJiuImgList.sort((a, b) => {return a.index - b.index});

    return result;
}


/**
 * 芳华杯 更多
 */
export async function fangHuaBei({pageNumber}) {
    let findParam = {articleType:{"$in":[ARTICLEPOSITION.品牌项目_hgh展演竞赛]}, display:STATE.是};
    let dataBaseList = await findToSortToPage(TABLEENUM.文章管理, findParam, [], {articleTime:-1}, pageNumber);
    let dataCount = await findCount(TABLEENUM.文章管理, findParam);

    let dataList = [];
    dataBaseList.forEach(info => {
        let { id, title, desc, imgUrl, articleTime } = info;
        dataList.push({
            id, title, desc, imgUrl, articleTime:moment(articleTime).format("YYYY-MM-DD")
        });
    });

    return {dataList, dataCount};
}


/**
 * 学术研究列表
 * @param param0 
 * @returns 
 */
export async function xueshuyanjiu({pageNumber}) {
    let findParam = {articleType:{"$in":[ARTICLEPOSITION.品牌项目_hgh学术研究]}, display:STATE.是};
    let dataBaseList = await findToSortToPage(TABLEENUM.文章管理, findParam, [], {articleTime:-1}, pageNumber);
    let dataCount = await findCount(TABLEENUM.文章管理, findParam);

    let dataList = [];
    dataBaseList.forEach(info => {
        let { id, title, desc, imgUrl, articleTime } = info;
        dataList.push({
            id, title, desc, imgUrl, articleTime:moment(articleTime).format("YYYY-MM-DD")
        });
    });

    return {dataList, dataCount};
}


/**
 * 乡村振兴列表
 * @param param0 
 * @returns 
 */
export async function xiangCunZhenXing({pageNumber}) {
    let findParam = {articleType:{"$in":[ARTICLEPOSITION.品牌项目_hgh社会服务]}, display:STATE.是};
    let dataBaseList = await findToSortToPage(TABLEENUM.文章管理, findParam, ["id", "title", "desc", "imgUrl", "articleTime" ], {articleTime:-1}, pageNumber);
    let dataCount = await findCount(TABLEENUM.文章管理, findParam);

    let dataList = [];
    dataBaseList.forEach(info => {
        let { id, title, desc, imgUrl, articleTime } = info;
        dataList.push({
            id, title, desc, imgUrl, articleTime:moment(articleTime).format("YYYY-MM-DD")
        });
    });

    return {dataList, dataCount};
}


/**
 * 党建工作主题教育
 * @returns 
 */
export async function zhuTiJiaoYu() {
    let dataInfo = {};

    /**主题教育 */
    let dbList = await find(TABLEENUM.党建, {type:PARTYBUILDTYPEENUM.主题教育});
    for (let i = 0; i < dbList.length; i++) {
        let info = dbList[i];
        let itemId = info.id;
        dataInfo[info.name] = [];
        let findParam = {articleType:{"$in":[itemId]}, display:STATE.是};
        let dataBaseList = await findToSort(TABLEENUM.文章管理, findParam, {articleTime:-1}, ["id", "title", "desc", "articleTime", "imgUrl"]);
        dataBaseList.forEach(item => {
            let {id, title, desc, articleTime, imgUrl} = item;
            let timeStr = moment(articleTime).format("YYYY-MM-DD")
            dataInfo[info.name].push({id, title, desc, articleTime:timeStr, imgUrl});
        });
    }
   
    return {dataInfo};
}


/**
 * 学习园地视频图片
 * @param param0 
 * @returns 
 */
export async function xueXiYuanDiShiPin({}) {
    let dataList = [];
    let wzDBList = await find(TABLEENUM.文字资料, {});
    wzDBList.forEach(info => {
        let addInfo:any = extractData(info, ["id", "title", "rank", "type", "imgUrl", "coverUrl"]); 
        addInfo.updateTime = moment(addInfo.updateTime).format("YYYY-MM-DD");
        dataList.push(addInfo);
    });

    return {dataList};
}

/**
 * 学习园地文字资料
 * @param param0 
 * @returns 
 */
export async function xueXiYuanDiWenZi({}) {
    let dataList = [];
    let findParam = {articleType:{"$in":[ARTICLEPOSITION.学习园地_文字资料]}, display:STATE.是};
    let wzDBList = await findToSortToPage(TABLEENUM.文章管理, findParam, ["id", "title", "articleTime", "imgUrl"], {articleTime:-1}, 1);
    wzDBList.forEach(info => {
        let addInfo:any = extractData(info, ["id", "title", "articleTime"]); 
        addInfo.articleTime = moment(addInfo.articleTime).format("YYYY-MM-DD");
        if (info.imgUrl && info.imgUrl[0]) addInfo.imgUrl = info.imgUrl[0];
        else addInfo.imgUrl = ""
        dataList.push(addInfo);
    });

    return {dataList};
}


/**
 * 党建资源列表
 * @param param0 
 * @returns 
 */
export async function dangJianZiYuan({first, secondary, three, pageNumber}) {
    let dataList = [];
    let dataCount = 0;
    if (first == PARTYBUILDTYPEENUM.主题教育) {
        let findParam = {articleType:{"$in":[secondary]}, display:STATE.是};
        let dataBaseList = await findToSortToPage(TABLEENUM.文章管理, findParam, ["id", "title", "desc", "articleTime", "imgUrl"], {articleTime:-1}, pageNumber);
        dataCount = await findCount(TABLEENUM.文章管理, findParam);
        dataBaseList.forEach(item => {
            let {title, desc, articleTime, imgUrl, id} = item;
            dataList.push({id, title, desc, articleTime:moment(articleTime).format("YYYY-MM-DD"), imgUrl});
        });
    } else {//学习园地
        let findParam = {articleType:{"$in":[secondary]}, display:STATE.是};
        let dataBaseList = await findToSortToPage(TABLEENUM.文章管理, findParam, ["id", "title", "desc", "articleTime", "imgUrl"], {articleTime:-1}, pageNumber);
        dataCount = await findCount(TABLEENUM.文章管理, findParam);
        dataBaseList.forEach(item => {
            let {title, desc, articleTime, imgUrl, id} = item;
            dataList.push({id, title, desc, articleTime:moment(articleTime).format("YYYY-MM-DD"), imgUrl});
        });
        
    }

    return {dataList, dataCount};
}


/**
 * 党建资源列表目录
 */
export async function dangJianZiYuanMuLu({}) {
    let dataList = [
        {
            name:"主题教育",
            value:PARTYBUILDTYPEENUM.主题教育,
            subList:[]
        },
        {
            name:"学习园地",
            value:PARTYBUILDTYPEENUM.学习园地,
            subList:[
                {
                    name:"文字资料",
                    value:ARTICLEPOSITION.学习园地_文字资料,
                    subList:[]
                }
            ]
        }
    ];
    let dbList = await find(TABLEENUM.党建, {type:PARTYBUILDTYPEENUM.主题教育});
    for (let i = 0; i < dbList.length; i++) {
        let info = dbList[i];
        dataList[0].subList.push({
            name:info.name,
            value:info.id,
            subList:[]
        });
    }
   

    return {dataList};
}


/**
 * 通知公告
 * @param param0 
 * @returns 
 */
export async function tongZhiGongGao({searchValue, type, pageNumber}) {
    eccEnumValue("通知公告", "类型", TONGZHIGONGGAO, type);
    // let tableName;
    // switch (type) {
    //     case TONGZHIGONGGAO.会议通知: tableName = TABLEENUM.会议通知; break;
    //     case TONGZHIGONGGAO.活动通知: tableName = TABLEENUM.活动通知; break;
    //     case TONGZHIGONGGAO.项目公告: tableName = TABLEENUM.项目公告; break;
    // }
    // let dbList = await findToPage(tableName, {push:STATE.是}, ["id", "name", "st", "addrest", "members", "desc"], pageNumber);
    // let dataCount = await findCount(tableName, {push:STATE.是});
    // let dataList = [];
    // dbList.forEach(info => {
    //     let item:any = extractData(info, ["id", "name", "addrest"]);
    //     item.time = moment(info.st).format("YYYY-MM-DD");
    //     item.desc = info.desc || "";
    //     item.members = changeEnumValue(CODPARTICIPANT, info.members);
    //     dataList.push(item);
    // });
    let findParam = {
        articleType:{"$in":[type]}, 
        display:STATE.是, 
        "$or":[ 
            {
                title:{"$regex":searchValue, "$options": "i"}
            }, 
            {
                desc:{"$regex":searchValue, "$options": "i"}
            }
        ]
    };
    let dataBaseList = await findToSortToPage(TABLEENUM.文章管理, findParam, ["id", "title", "desc", "imgUrl", "articleTime" ], {articleTime:-1}, pageNumber);
    let dataCount = await findCount(TABLEENUM.文章管理, findParam);

    let dataList = [];
    dataBaseList.forEach(info => {
        let { id, title, desc, imgUrl, articleTime } = info;
        let descStr = desc.replace(/<[^>]*>/g, '');
        dataList.push({
            id, title, desc, descStr, imgUrl, articleTime:moment(articleTime).format("YYYY-MM-DD")
        });
    });

    return { dataList, dataCount};
}


/**
 * 通知公告
 * @param param0 
 * @returns 
 */
export async function getWenZhang({type, pageNumber}) {
    eccEnumValue("通知公告", "类型", TONGZHIGONGGAO, type);
    // let tableName;
    // switch (type) {
    //     case TONGZHIGONGGAO.会议通知: tableName = TABLEENUM.会议通知; break;
    //     case TONGZHIGONGGAO.活动通知: tableName = TABLEENUM.活动通知; break;
    //     case TONGZHIGONGGAO.项目公告: tableName = TABLEENUM.项目公告; break;
    // }
    // let dbList = await findToPage(tableName, {push:STATE.是}, ["id", "name", "st", "addrest", "members", "desc"], pageNumber);
    // let dataCount = await findCount(tableName, {push:STATE.是});
    // let dataList = [];
    // dbList.forEach(info => {
    //     let item:any = extractData(info, ["id", "name", "addrest"]);
    //     item.time = moment(info.st).format("YYYY-MM-DD");
    //     item.desc = info.desc || "";
    //     item.members = changeEnumValue(CODPARTICIPANT, info.members);
    //     dataList.push(item);
    // });
    let findParam = {articleType:{"$in":[type]}, display:STATE.是};
    let dataBaseList = await findToSortToPage(TABLEENUM.文章管理, findParam, ["id", "title", "desc", "imgUrl", "articleTime" ], {articleTime:-1}, pageNumber);
    let dataCount = await findCount(TABLEENUM.文章管理, findParam);

    let dataList = [];
    dataBaseList.forEach(info => {
        let { id, title, desc, imgUrl, articleTime } = info;
        dataList.push({
            id, title, desc, imgUrl, articleTime:moment(articleTime).format("YYYY-MM-DD")
        });
    });

    return { dataList, dataCount};
}






export async function tongZhiGongGaoInfo({id, type}) {
    eccEnumValue("通知公告", "类型", TONGZHIGONGGAO, type);
    // let tableName;
    // switch (type) {
    //     case TONGZHIGONGGAO.会议通知: tableName = TABLEENUM.会议通知; break;
    //     case TONGZHIGONGGAO.活动通知: tableName = TABLEENUM.活动通知; break;
    //     case TONGZHIGONGGAO.项目公告: tableName = TABLEENUM.项目公告; break;
    // }
    // let dbData = await findOnce(tableName, {id, push:STATE.是}, ["id", "name", "st", "addrest", "members", "desc"]);
    // if (!dbData || !dbData.id) throw new BizError(ERRORENUM.目标数据不存在);
    // let dataInfo:any = extractData(dbData, ["name", "addrest"]);
    // dataInfo.time = moment(dbData.st).format("YYYY-MM-DD");
    // dataInfo.desc = dbData.desc || "";
    // dataInfo.members = changeEnumValue(CODPARTICIPANT, dbData.members);
    
    let findParam = {id, articleType:{"$in":[type]}, display:STATE.是};
    let dataBaseInfo = await findOnce(TABLEENUM.文章管理, findParam, ["id", "title", "desc", "imgUrl", "articleTime" , "files"]);
    if (!dataBaseInfo || !dataBaseInfo.id ) throw new BizError(ERRORENUM.源文章已被删除);
    let dataInfo:any = extractData(dataBaseInfo, ["id", "title", "desc", "imgUrl", "articleTime" , "files"]);
    dataInfo.articleTime = moment(dataBaseInfo.articleTime).format("YYYY-MM-DD");
    

    return {dataInfo};
}



/**
 * 热门排行
 */
export async function reMenPaiHang({type}) {
    /**学会动态 每个动态资讯取最新的可见的三个*/
    let wenZhangTypeList = [type];
    let dongTaiZiXunData = await findToSort(TABLEENUM.文章管理, {articleType:{"$in":wenZhangTypeList }, display:STATE.是}, {articleTime:-1});
    let dataList = [];
    dongTaiZiXunData.forEach(info => {
        let {id, title, articleTime, desc } = info;
        dataList.push({
            id, title, articleTime:moment(articleTime).format("YYYY-MM-DD"), desc
        });
    });
    return {dataList}
}


export async function fenZhiJiGou() {
    let jiGouList = await find(TABLEENUM.机构管理, {}, ["logoUrl", "id", "name"]);

    let dataList = [];

    jiGouList.forEach(info => {
        let {id, logoUrl, name } = info;
        dataList.push({
            id, logoUrl, name, count:28
        });
    });

    return {dataList};
}


export async function fenHuiDongTai({agencyId, pageNumber}) {
    let nameMap = {};
    if (agencyId) {
        let jigoiuInfo = await findOnce(TABLEENUM.机构管理, {id:agencyId});
        if (!jigoiuInfo || !jigoiuInfo.id) throw new BizError(ERRORENUM.找不到该机构);
        nameMap[agencyId] = jigoiuInfo.name;
    } else {
        let jigoiuList = await find(TABLEENUM.机构管理, {}, ["id", "name"]);
        jigoiuList.forEach(info => {
            nameMap[info.id] = info.name;
        });
    }
    
    let selectParam:any = {isUse:STATE.是};
    if (agencyId) selectParam.agencyId = agencyId;
    let jiGouList = await findToPage(TABLEENUM.工作动态, selectParam, ["id", "title", "activityTime", "imgUrl", "agencyId"], pageNumber);
    let dataCount = await findCount(TABLEENUM.工作动态, selectParam);

    let dataList = [];
    jiGouList.forEach(info => {
        let {id, title, activityTime, imgUrl } = info;
        dataList.push({id, title, activityTime:moment(activityTime).format("YYYY-MM-DD"), imgUrl, name:nameMap[info.agencyId]});
    });

    return { dataList, dataCount }
}

export async function fenHuiInfo({id}) {
    let result = {
        jiGouXinXi:{},
    };
    let dataInfo = await findOnce(TABLEENUM.机构管理, {id});

    result.jiGouXinXi = extractData(dataInfo, ["name", "createTime", "desc"]);
    result.jiGouXinXi["createTime"] = moment(dataInfo.createTime).format("YYYY-MM-DD");
   
    return result;
}

export async function fenHuiDongTaiInfo({id}) {
    let dongTaiInfo = await findOnce(TABLEENUM.工作动态, {id, isUse:STATE.是}, ["id", "title", "activityTime", "imgUrl", "desc"]);
    if (!dongTaiInfo || !dongTaiInfo.id) throw new BizError(ERRORENUM.该动态未开放);
    let dataInfo:any = extractData(dongTaiInfo, ["title", "activityTime", "imgUrl", "desc"]);
    dataInfo.activityTime= moment(dataInfo.activityTime).format("YYYY-MM-DD");
    return {dataInfo}
}

/**
 * 委员名单
 */
export async function weiYuanMingDanList({name, agencyId, pageNumber, pageSize}) {
    let selectParam:any = {agencyId};
    if (name) selectParam.name = {"$regex":name};
    let dataList = [];
    let dbList = await findToSortToPage(TABLEENUM.委员名单, selectParam, ["name", "branchDuties", "unit", "unitDuties"], {branchDuties:1, ut:-1}, pageNumber, pageSize);
    let dataCount = await findCount(TABLEENUM.委员名单, selectParam);
    dbList.forEach(info => {
        let addInfo:any = extractData(info, ["name", "unit", "unitDuties"]);
        info.branchDuties.sort();
        addInfo.branchDuties = changeEnumValue(BRANCHPOSITION, info.branchDuties);
        dataList.push(addInfo);
    });

    return {dataList, dataCount}
}


export async function xueXiYuanDiWenZiType() {
    let typeList = await find(TABLEENUM.党建, {type:PARTYBUILDTYPEENUM.学习园地, subType:PARTYBUILDSUBTYPEENUM.文字资料, display:STATE.是});

    let dataList = []
    typeList.forEach(info => {
        let {id, name } = info;
        dataList.push({
            key:name,
            value:id
        });
    });

    return {dataList};
}

export async function xueXiYuanDiShiPinType() {
    
    let dataList = [];
    for (let key in DANGJIANVIDEO) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            let value = DANGJIANVIDEO[key];
            dataList.push({key:keyStr, value});
        }
    }
    return {dataList};
}


/**原证书查询，跳出弹窗显示到期时间 */
// export async function zhengShuChaXun({memberType, name, carId }) {
//     eccEnumValue("证书查询", "会员类型", MEMBERTYPE, memberType);
//     let selectParam = {};
//     if (memberType == MEMBERTYPE.个人会员) selectParam = {name, documentId:carId};
//     else selectParam = {unitName:name, uscc:carId}
//     let userInfo = await findOnce(TABLEENUM.用户表, selectParam, ["userId", "lifespanEndTime", "lifespanStartTime", "unitMemberType"]);
//     if (!userInfo || !userInfo.userId) return {success:false, msg:"无法查询到该信息，请联系学会工作人员"};
    
//     if (userInfo.unitMemberType == UNITMEMBERTYPE.院校) {
//         let diffYearNum = moment().diff(moment(userInfo.lifespanStartTime), 'years');
//         let startTimeStr = moment(userInfo.lifespanStartTime).add(diffYearNum, 'years').format("YYYY年MM月DD日");
//         let endTimeStr = moment(userInfo.lifespanStartTime).add(diffYearNum+1, 'years').format("YYYY年MM月DD日");
//         return {success:true, msg:`证书有效期至${endTimeStr}`};
//     }
//     if ( new Date().valueOf() > userInfo.lifespanEndTime ){
//         return {success:true, msg:`会员到期，请续会员`};
//     }
//     return {success:true, msg:`证书有效期至${moment(userInfo.lifespanEndTime).format("YYYY年MM月DD日")}`};
// }


/**
 * 证书查询
 * @param param0 
 * @returns 
 */
export async function zhengShuChaXun({memberType, name, carId}) {
    eccEnumValue("证书查询", "会员类型", MEMBERTYPE, memberType);
    let selectParam = {};
    if (memberType == MEMBERTYPE.个人会员) selectParam = {name, documentId:carId};
    else selectParam = {unitName:name, uscc:carId}
    let userInfo = await findOnce(TABLEENUM.用户表, selectParam, ["userId", "lifespanEndTime", "lifespanStartTime", "unitMemberType", "userRegisterState", 
    "paymentStatus", "memberLevel", "changeApplyType", "applyApplicationTime", "unitName", "name", "beforeChange", "memberType",
    "individualMemberType", "sheng", "documentId", "memberNum", "shi","qu","addres", "session"]);
    if (!userInfo || !userInfo.userId) return {success:false, msg:"无法查询到该信息，请联系学会工作人员"};

    let certificate = false;//是否可以下载
    let cefaInfo:any = {};
    let msg = '会员注册尚未审核通过，无法下载证书';
    //判断是否审批通过
    if (userInfo.userRegisterState == USERREGISTERSTATE.通过) {
        let addresStr = ``;
        if (getCityNameByCode(userInfo.sheng)) {
            addresStr += `${getCityNameByCode(userInfo.sheng)}`;
            if (getCityNameByCode(userInfo.shi)) {
                if (getCityNameByCode(userInfo.sheng) != getCityNameByCode(userInfo.shi)) {
                    addresStr += `${getCityNameByCode(userInfo.shi)}`;
                }
                if (getCityNameByCode(userInfo.qu)) {
                    addresStr += `${getCityNameByCode(userInfo.qu)}`;
                }
            }
        }
        // if (getCityNameByCode(userInfo.sheng) == getCityNameByCode(userInfo.shi) || !getCityNameByCode(userInfo.qu)) {
        //     addresStr = `${getCityNameByCode(userInfo.shi)}${getCityNameByCode(userInfo.qu)}`;
        // } else {
        //     addresStr = `${getCityNameByCode(userInfo.sheng)}${getCityNameByCode(userInfo.shi)}${getCityNameByCode(userInfo.qu)}`;
        // }

        if(userInfo.memberType == MEMBERTYPE.个人会员) {
            //个人会员已支付可下载
            if (userInfo.individualMemberType == INDIVIDUALMEMBERTYPE.普通会员 && userInfo.paymentStatus != PAYMENTSTATUS.未支付) certificate = true;
            //个人会员专家无需支付可下载
            if (userInfo.individualMemberType == INDIVIDUALMEMBERTYPE.专家会员) certificate = true;
            if (certificate) {
                
                cefaInfo = {
                    name:userInfo.name,
                    area:addresStr,
                    documentId:userInfo.documentId,
                    memberNum:userInfo.memberNum,
                    session:getEdition(Math.floor(userInfo.session/100), userInfo.session%100 ),
                    lifespanTime:`${moment(userInfo.lifespanStartTime).format("YYYY年MM月DD日")}至${moment(userInfo.lifespanEndTime).format("YYYY年MM月DD日")}`,
                    memberLevel:userInfo.memberLevel,
                    memberLevelStr:changeEnumValue(MEMBERLEVEL, userInfo.memberLevel),
                }
                msg = ``;
            } else {
                msg = `会员注册尚未缴费，无法下载证书`;
            }
        } else if(userInfo.memberType == MEMBERTYPE.单位会员) {
            //院校无需支付可下载
            if (userInfo.unitMemberType == UNITMEMBERTYPE.院校) certificate = true;
            //机构和其他已支付可下载
            else if (userInfo.paymentStatus != PAYMENTSTATUS.未支付) {
                certificate = true;
            }
            if (certificate) {
                // if (getCityNameByCode(userInfo.sheng) == getCityNameByCode(userInfo.shi)) {
                //     addresStr = `${getCityNameByCode(userInfo.shi)}${getCityNameByCode(userInfo.qu)}${userInfo.addres}`;
                // } else {
                //     addresStr = `${getCityNameByCode(userInfo.sheng)}${getCityNameByCode(userInfo.shi)}${getCityNameByCode(userInfo.qu)}${userInfo.addres}`;
                // }
                cefaInfo = {
                    unitName:userInfo.unitName,
                    addres:addresStr,
                    memberNum:userInfo.memberNum,
                    session:getEdition(Math.floor(userInfo.session/100), userInfo.session%100 ),
                    lifespanTime:`${moment(userInfo.lifespanStartTime).format("YYYY年MM月DD日")}至${moment(userInfo.lifespanEndTime).format("YYYY年MM月DD日")}`,
                    memberLevel:userInfo.memberLevel,
                    memberLevelStr:changeEnumValue(MEMBERLEVEL, userInfo.memberLevel),
                }
                if (userInfo.unitMemberType == UNITMEMBERTYPE.院校) {
                    let diffYearNum = moment().diff(moment(userInfo.lifespanStartTime), 'years');
                    let startTimeStr = moment(userInfo.lifespanStartTime).add(diffYearNum, 'years').format("YYYY年MM月DD日");
                    let endTimeStr = moment(userInfo.lifespanStartTime).add(diffYearNum+1, 'years').format("YYYY年MM月DD日");
                    cefaInfo.lifespanTime = `${startTimeStr}至${endTimeStr}`;
                }
                msg = ``;
            } else {
                msg = `会员注册尚未缴费，无法下载证书`;
            }
        }
    }
    
    return {certificate, cefaInfo, msg};
}




