/**
 * 手动发送短信
 */

import { CODETYPE, MEMBERTYPE, MSGTYPE } from "../../config/enum";
import { ERRORENUM } from "../../config/errorEnum";
import { TABLEENUM } from "../../data/models/model";
import { findOnce } from "../../data/select";
import { BizError } from "../../util/bizError";
import { sendMessage } from "../sms";

export async function taskOneSMS({sendType, userId}) {
    let selectParam = {
        userId:userId
    };
    let userInfo = await findOnce(TABLEENUM.用户表, selectParam, ["userId", "phone", "memberType", "name", "unitName"]);
    if (!userInfo || !userInfo.userId ) throw new BizError(ERRORENUM.用户不存在);
    if (!userInfo.phone) throw new BizError(ERRORENUM.手机号不存在);

    let nameStr = userInfo.memberType == MEMBERTYPE.个人会员 ? userInfo.name : userInfo.unitName;
    await sendMessage(userInfo.phone, {name:nameStr}, sendType);

    return {isSuccess:true};
}


export async function taskManySMS({sendType, userIdList}) {
    for (let i = 0; i < userIdList.length; i++) {
        let userId = userIdList[i];
        let selectParam = {
            userId:userId
        };
        let userInfo = await findOnce(TABLEENUM.用户表, selectParam, ["userId", "phone", "memberType", "name", "unitName"]);
        if (!userInfo || !userInfo.userId ) throw new BizError(ERRORENUM.用户不存在);
        if (!userInfo.phone) throw new BizError(ERRORENUM.手机号不存在);

        let nameStr = userInfo.memberType == MEMBERTYPE.个人会员 ? userInfo.name : userInfo.unitName;
        sendMessage(userInfo.phone, {name:nameStr}, sendType);
    }
    
    return {isSuccess:true};
}
 