/**
 * 会员管理 【权限管理】success
 */

import { INDIVIDUALMEMBERTYPE, MEMBERLEVEL, MEMBERSTATE, MEMBERTYPE, STATE, UNITMEMBERTYPE, USERREGISTERSTATE } from "../../config/enum";
import { ERRORENUM } from "../../config/errorEnum";
import { TABLEENUM } from "../../data/models/model";
import { findCount, findOnce, findToPage } from "../../data/select";
import { updateOneData } from "../../data/update";
import { successResult } from "../../tools/system";
import { BizError } from "../../util/bizError";
import { extractData } from "../../util/piecemeal";
import { changeEnumValue, eccEnumValue } from "../../util/verificationEnum";



/**
 * 会员权限列表 success
 * @param unitName 单位名称//改成了名称关键词
 * @param memberLevel 会员等级、职务 MEMBERLEVEL
 * @param memberCategory 会员类别、会员级别  UNITMEMBERTYPE、INDIVIDUALMEMBERTYPE 前端用MEMBERTYPEECCENUM
 * @param pageNumber 当前页
 */
export async function getAuthority({unitName, memberLevel, memberCategory, pageNumber}) {    
    /**查询条件 */
    let selectParam:any = {
        isAdmin:STATE.否,
        userRegisterState : USERREGISTERSTATE.通过,
        isBlackUser:STATE.否
    };
    if (unitName) {
        selectParam["$or"] =[{unitName:{"$regex":`${unitName}`}}, {name:{"$regex":`${unitName}`}}];
    }
    if (memberLevel) selectParam.memberLevel = memberLevel;
    if (memberCategory) {
        if ( memberCategory >= 9) selectParam.unitMemberType = memberCategory;
        else selectParam.individualMemberType = memberCategory;
    }
    const SelectFiles = ["userId", "memberState", "unitName", "name", "memberLevel", "memberType", "individualMemberType", "unitMemberType", 
    "memberCategory", "name", "phone", "mail"];
    let dbList = await findToPage(TABLEENUM.用户表, selectParam, SelectFiles, pageNumber);
    let dataCount = await findCount(TABLEENUM.用户表, selectParam);

    const ResultFiles = ["userId", "memberState", "memberLevel", "memberType", "unitName", "name", "phone", "mail"];
    let dataList = [];
    dbList.forEach(info => {
        let item:any = extractData(info, ResultFiles);
        if (info.memberType == MEMBERTYPE.个人会员) {
            //会员类别/级别 2024年11月29甘明说的，个人会员这里显示个人会员不显示类别
            // item.memberCategory = changeEnumValue(INDIVIDUALMEMBERTYPE, info.individualMemberType);
            if (info.individualMemberType == INDIVIDUALMEMBERTYPE.普通会员) item.memberCategory = changeEnumValue(MEMBERTYPE, info.memberType);
            else item.memberCategory = changeEnumValue(INDIVIDUALMEMBERTYPE, info.individualMemberType);
        }
        else{
            item.memberCategory = changeEnumValue(UNITMEMBERTYPE, info.unitMemberType);//会员类别/级别
        }
        item.memberState = changeEnumValue(MEMBERSTATE, item.memberState);
        // if(!item.beforeChange && item.changeApplyType != CHANGEAPPLYTYPE.通过) topInfo.memberLevel = oldInfo.beforeChange;
        item.memberLevel = changeEnumValue(MEMBERLEVEL, item.memberLevel);//会员等级、职务

        dataList.push(item);
    });

    return {dataList, dataCount};
}


/**
 * 变更权限  success
 * @param id 列表返回的userId 
 */
export async function updateAuthority({form, id}) {
    let {memberLevel, memberCategory} = form;
    let userInfo = await findOnce(TABLEENUM.用户表, {userId:id});
    if (!userInfo || !userInfo.userId) throw new BizError(ERRORENUM.目标数据不存在);

    let updateInfo:any = {};
    eccEnumValue("变更权限", "职务、级别", MEMBERLEVEL, memberLevel);
    updateInfo.memberLevel = memberLevel;
    if (userInfo.memberType == MEMBERTYPE.个人会员) {
        eccEnumValue("变更权限", "单位、个人会员类别、级别", INDIVIDUALMEMBERTYPE, memberCategory);
        updateInfo.individualMemberType = memberCategory;
        updateInfo.certificateType = memberLevel; //CERTIFICATETYPE  会员等级（职务）变更 会员证书类型也要变更

    } else {
        eccEnumValue("变更权限", "单位、个人会员类别、级别", UNITMEMBERTYPE, memberCategory);
        updateInfo.unitMemberType = memberCategory;
    }

    await updateOneData(TABLEENUM.用户表, {userId:id}, updateInfo);

    return successResult();
}


/**
 * 冻结 success
 * @param id 列表返回的userId 
 */
export async function freeze({id}) {
    let userInfo = await findOnce(TABLEENUM.用户表, {userId:id});
    if (!userInfo || !userInfo.userId) throw new BizError(ERRORENUM.目标数据不存在);
 
    if(userInfo.memberState == MEMBERSTATE.冻结) {
        await updateOneData(TABLEENUM.用户表, {userId:id}, {memberState:MEMBERSTATE.运行});
    } else {
        await updateOneData(TABLEENUM.用户表, {userId:id}, {memberState:MEMBERSTATE.冻结});
    }
    
    return successResult();
}


/**
 * 变更权限回显
 * @param id 列表返回的userId
 * @returns 
 */
export async function authorityEcho({id}) {
    const SelectFiles = ["userId", "unitName", "name", "memberLevel", "memberType", "individualMemberType", "unitMemberType"];
    let dbInfo = await findOnce(TABLEENUM.用户表, {userId:id}, SelectFiles);
    if (!dbInfo || !dbInfo.userId) throw new BizError(ERRORENUM.目标数据不存在);

    const ResultFiles = ["unitName", "name", "memberLevel", "memberType"];

    let dataInfo:any = extractData(dbInfo, ResultFiles);
    if (dataInfo.memberType == MEMBERTYPE.个人会员) {
        dataInfo.memberCategory = changeEnumValue(INDIVIDUALMEMBERTYPE, dbInfo.individualMemberType);//会员类别/级别
    }
    else{
        dataInfo.memberCategory = changeEnumValue(UNITMEMBERTYPE, dbInfo.unitMemberType);//会员类别/级别
    }
    dataInfo.memberLevel = changeEnumValue(MEMBERLEVEL, dbInfo.memberLevel);//会员等级、职务

    return {dataInfo};
}






