/**
 * 官网
 */

import moment = require("moment");
import { ARTICLEPOSITION, BANNERPOSITION, BRANCHPOSITION, CODPARTICIPANT, DANGJIANVIDEO, DONGTAIZIXUNSUBTYPE, IMGEDITFUNENUM, PARTYBUILDSUBTYPEENUM, PARTYBUILDTYPEENUM, STATE, TONGZHIGONGGAO } from "../config/enum";
import { TABLEENUM } from "../data/models/model";
import { find, findCount, findOnce, findToPage, findToSortToPage } from "../data/select";
import { extractData } from "../util/piecemeal";
import { changeEnumValue, eccEnumValue } from "../util/verificationEnum";
import { BizError } from "../util/bizError";
import { ERRORENUM } from "../config/errorEnum";

export async function banner() {
    let result = {
        bannerList:[],//banner
    };
    /**banner */
    let localBanners = [BANNERPOSITION.首页_hghbanner01, BANNERPOSITION.首页_hghbanner02, BANNERPOSITION.首页_hghbanner03];
    let bannerData = await find(TABLEENUM.banner管理, {location:{"$in":localBanners}, display:STATE.是} );
    bannerData.forEach(info => {
        let {imgUrl, articleTitle, desc, articleUrl} = info;
        result.bannerList.push({imgUrl, title:articleTitle, desc, articleUrl});
    });
    return result;
}


/**
 * 首页除了banner
 * @returns 
 */
export async function homePage() {
    let result = {
        zhuanTi:[],//专题系列
        xueHuiDongTai:[],//学会动态
        huoDongTongZhi:[],//活动通知
        reDianShiPin:[]//热点视频
    };

   
    /**专题系列 */
    let zhuanTiData = await find(TABLEENUM.专题系列, {});
    zhuanTiData.sort((a, b) => {return a.rank - b.rank});
    zhuanTiData.forEach(info => {
        let {rank, title, articleUrl, imgUrl} = info;
        result.zhuanTi.push({rank, title, articleUrl, imgUrl});
    });
    /**学会动态 每个动态资讯取最新的可见的两个*/
    let wenZhangTypeList = [ARTICLEPOSITION.动态资讯_hgh学会动态, ARTICLEPOSITION.动态资讯_hgh政策动向, ARTICLEPOSITION.动态资讯_hgh行业风采];
    let dongTaiZiXunData = await find(TABLEENUM.文章管理, {articleType:{"$in":wenZhangTypeList }, display:STATE.是});
    dongTaiZiXunData.sort((a, b) => {return a.articleTime - b.articleTime});
    let dongTaiZiXunDistinctMap = {};
    dongTaiZiXunData.forEach(info => {
        let { articleType, id, title, imgUrl, articleTime, desc } = info;
        if (!dongTaiZiXunDistinctMap[articleType]) dongTaiZiXunDistinctMap[articleType] = [];
        if (dongTaiZiXunDistinctMap[articleType].length < 2) {
            dongTaiZiXunDistinctMap[articleType].push({
                id, title, imgUrl, articleTime:moment(articleTime).format("YYYY-MM-DD"), desc
            });
        }
    });
    for (let key in dongTaiZiXunDistinctMap) {
        result.xueHuiDongTai = result.xueHuiDongTai.concat(dongTaiZiXunDistinctMap[key]);
    }

    /**活动通知 */
    let huoDongTongZhiData = await find(TABLEENUM.活动通知, { push:STATE.是 } );//todo 二期优化点 在获取数据时取最新6条
    huoDongTongZhiData.sort((a, b) => {return a.st - b.st});
    huoDongTongZhiData.forEach(info => {
        let {id, name, st} = info;
        result.huoDongTongZhi.push({
            id, name, time:moment(st).format("YYYY-MM-DD")
        });
    });

    /**热点视频*/
    let reDianShiPinData = await find(TABLEENUM.视频管理, { display:STATE.是 } );
    reDianShiPinData.sort((a, b) => {return a.videoTime - b.videoTime});
    for (let i= 0; i < reDianShiPinData.length; i++) {
        let {title, desc, videoUrl} = reDianShiPinData[i];
        result.reDianShiPin.push({title, desc, videoUrl:videoUrl[0]});
        if (i >= 4) break;
    }

    return result;
}


/**
 * 学会概况
 * @returns 
 */
export async function xueHuiGaiKuang() {
    let result = {
        xueHuiGaiKuang:{},//学会概况
        xueHuiLingDao:[],//学会领导
        zuZhiJiaGou:[],//组织架构
        xueHuiGuiZhang:[],//学会规章
    };

    /**学会概况 */
    let xueHuiGaiKuangData = await findOnce(TABLEENUM.学会概括, {} );
    result.xueHuiGaiKuang = extractData(xueHuiGaiKuangData, ["title", "desc", "imgList"]);

    /**学会领导 */
    let xueHuiLingDaoData = await find(TABLEENUM.学会领导, {} );
    xueHuiLingDaoData.sort((a, b) => {return a.rank - b.rank});
    xueHuiLingDaoData.forEach(info => {
       result.xueHuiLingDao.push(extractData(info, ["name", "position", "imgUrl", "miniImgUrl", "desc"]));
    });

    /**组织架构 */
    let zuZhiJiaGouData = await find(TABLEENUM.学会架构, {display:1} );
    zuZhiJiaGouData.forEach(info => {
        result.zuZhiJiaGou.push(extractData(info, ["departmentName", "desc"]));
    });

    /**学会规章 */
    let xueHuiGuiZhangData = await find(TABLEENUM.文章管理, {articleType:{"$in":[ARTICLEPOSITION.学会概况_hgh学会规章]}, display:STATE.是} );
    for (let i = 0; i < xueHuiGuiZhangData.length; i++) {
        let {id, title, imgUrl, articleTime, desc} = xueHuiGuiZhangData[i];
        let articleDate = moment(articleTime);
        result.xueHuiGuiZhang.push({
            id, title, yearAndMonth:articleDate.format("YYYY-MM"), day:articleDate.format("DD"),desc
        });
    }

    return result;
}


/**
 * 学会概况详细信息
 * @returns 
 */
export async function xueHuiGaiKuangXiangQing() {
    let xueHuiGaiKuangData = await findOnce(TABLEENUM.学会概括, {} );
    let dataInfo = extractData(xueHuiGaiKuangData, ["title", "desc", "imgList"]);

    return {dataInfo};
}


/**
 * 规章列表分页
 * @param param0 
 * @returns 
 */
export async function guiZhangLieBiaoFenYe({pageNumber}) {
    let findParam = {articleType:{"$in":[ARTICLEPOSITION.学会概况_hgh学会规章]}, display:STATE.是};
    let wenZhangGuanLi = await findToPage(TABLEENUM.文章管理, findParam, [], pageNumber);
    let dataCount = await findCount(TABLEENUM.文章管理, findParam);

    let dataList = [];
    wenZhangGuanLi.forEach(info => {
        let itemData:any = extractData(info, ["id", "articleTime", "title", "desc"]);
        itemData.articleTime = moment(itemData.articleTime).format("YYYY-MM-DD");
        dataList.push(itemData);
    });

    return { dataList, dataCount };
}


/**
 * 学会规则详情
 * @param param0 
 * @returns 
 */
export async function guiZhangZhiDuXiangQing({id}) {
    let dataBaseInfo = await findOnce(TABLEENUM.文章管理, {id, display:STATE.是});
    if (!dataBaseInfo || !dataBaseInfo.id) {
        throw new BizError(ERRORENUM.目标数据不存在);
    }
    let dataInfo:any = extractData(dataBaseInfo, [ "articleTime", "title", "desc"]);
    dataInfo.articleTime = moment(dataInfo.articleTime).format("YYYY-MM-DD");
    dataInfo.source = "中国艺术职业教育学会";

    return {dataInfo};
}


/**
 * 动态资讯
 * @param param0 
 * @returns 
 */
export async function dongTaiZiXun({type, pageNumber}) {
    eccEnumValue("官网", "行业动态类型", type, DONGTAIZIXUNSUBTYPE);
    let findParam = {articleType:{"$in":[type]}, display:STATE.是};
    let dataBaseList = await findToPage(TABLEENUM.文章管理, findParam, [], pageNumber);
    let dataCount = await findCount(TABLEENUM.文章管理, findParam);

    let dataList = [];
    dataBaseList.forEach(info => {
        let { id, title, desc, imgUrl, articleTime } = info;
        dataList.push({
            id, title, desc, imgUrl, articleTime:moment(articleTime).format("YYYY-MM-DD")
        });
    });

    return {dataList, dataCount};
}


/**
 * 文章详情
 * @param param0 
 * @returns 
 */
export async function wenZhangXiangQing({id}) {
    let dataBaseInfo = await findOnce(TABLEENUM.文章管理, {id, display:STATE.是});

    let dataInfo:any = extractData(dataBaseInfo, [ "articleTime", "imgUrl", "title", "desc"]);
    dataInfo.articleTime = moment(dataInfo.articleTime).format("YYYY-MM-DD");
    dataInfo.source = "中国艺术职业教育学会";

    return {dataInfo};
}


/**
 * 品牌项目banner
 * @returns 
 */
export async function pinPaiXiangMuBanner() {
    let result = {
        bannerList:[],//banner
    };
    /**banner */
    let localBanners = [BANNERPOSITION.品牌项目_hghbanner01, BANNERPOSITION.品牌项目_hghbanner02, BANNERPOSITION.品牌项目_hghbanner03];
    let bannerData = await find(TABLEENUM.banner管理, {location:{"$in":localBanners}, display:STATE.是} );
    bannerData.forEach(info => {
        let {imgUrl, articleTitle, desc, articleUrl} = info;
        result.bannerList.push({imgUrl, title:articleTitle, desc, articleUrl});
    });
    return result;
}


/**
 * 品牌项目信息
 * @returns 
 */
export async function pinPaiXiangMu() {
    let result = {
        xiangCunZhenXing:[],//乡村振兴
        fangHuaBei:[],//芳华杯
        xueShuYanJiu:[],//学术研究
        xueShuYanJiuImgList:[]//学术研究图片
    };
    /**乡村振兴 */
    let locationParam = [ARTICLEPOSITION.品牌项目_hgh乡村振兴];
    let xiangCunZhenXingData = await find(TABLEENUM.文章管理, {articleType:{"$in":locationParam}, display:STATE.是} );
    xiangCunZhenXingData.forEach(info => {
        let {id, title, imgUrl, articleTime, desc} = info;
        result.xiangCunZhenXing.push({
            id, title, imgUrl, articleTime:moment(articleTime).format("YYYY-MM-DD"), desc
        });
    });
    /**芳华杯 */
    locationParam = [ARTICLEPOSITION.品牌项目_hgh芳华杯];
    let fangHuaBeiData = await find(TABLEENUM.文章管理, {articleType:{"$in":locationParam}, display:STATE.是} );
    fangHuaBeiData.forEach(info => {
        let {id, title, imgUrl, articleTime, desc} = info;
        result.fangHuaBei.push({
            id, title, imgUrl, articleTime:moment(articleTime).format("YYYY-MM-DD"), desc
        });
    });
    /**学术研究 */
    locationParam = [ARTICLEPOSITION.品牌项目_hgh学术研究];
    let xueShuYanJiuData = await find(TABLEENUM.文章管理, {articleType:{"$in":locationParam}, display:STATE.是} );
    xueShuYanJiuData.forEach(info => {
        let {id, title, imgUrl, articleTime, desc} = info;
        result.xueShuYanJiu.push({
            id, title, imgUrl, articleTime:moment(articleTime).format("YYYY-MM-DD"), desc
        });
    });
    /**学术研究图片 */
    let xueShuYanJiuImgData = await find(TABLEENUM.图片编辑, {type:IMGEDITFUNENUM.学术研究});
    xueShuYanJiuImgData.forEach((info) => {
        let {index, imgUrl} = info;
        result.xueShuYanJiuImgList.push({index, imgUrl});
    });
    result.xueShuYanJiuImgList.sort((a, b) => {return a.index - b.index});

    return result;
}


/**
 * 学术研究列表
 * @param param0 
 * @returns 
 */
export async function xueshuyanjiu({pageNumber}) {
    let findParam = {articleType:{"$in":[ARTICLEPOSITION.品牌项目_hgh学术研究]}, display:STATE.是};
    let dataBaseList = await findToPage(TABLEENUM.文章管理, findParam, [], pageNumber);
    let dataCount = await findCount(TABLEENUM.文章管理, findParam);

    let dataList = [];
    dataBaseList.forEach(info => {
        let { id, title, desc, imgUrl, articleTime } = info;
        dataList.push({
            id, title, desc, imgUrl, articleTime:moment(articleTime).format("YYYY-MM-DD")
        });
    });

    return {dataList, dataCount};
}


/**
 * 乡村振兴列表
 * @param param0 
 * @returns 
 */
export async function xiangCunZhenXing({pageNumber}) {
    let findParam = {articleType:{"$in":[ARTICLEPOSITION.品牌项目_hgh乡村振兴]}, display:STATE.是};
    let dataBaseList = await findToPage(TABLEENUM.文章管理, findParam, ["id", "title", "desc", "imgUrl", "articleTime" ], pageNumber);
    let dataCount = await findCount(TABLEENUM.文章管理, findParam);

    let dataList = [];
    dataBaseList.forEach(info => {
        let { id, title, desc, imgUrl, articleTime } = info;
        dataList.push({
            id, title, desc, imgUrl, articleTime:moment(articleTime).format("YYYY-MM-DD")
        });
    });

    return {dataList, dataCount};
}


/**
 * 党建工作主题教育
 * @returns 
 */
export async function zhuTiJiaoYu() {
    let dataInfo = {};

    /**主题教育 */
    let dbList = await find(TABLEENUM.党建, {type:PARTYBUILDTYPEENUM.主题教育});
    for (let i = 0; i < dbList.length; i++) {
        let info = dbList[i];
        let itemId = info.id;
        dataInfo[info.name] = [];
        let findParam = {articleType:{"$in":[itemId]}, display:STATE.是};
        let dataBaseList = await find(TABLEENUM.文章管理, findParam, ["title", "desc", "articleTime", "imgUrl"]);
        dataBaseList.forEach(item => {
            let {title, desc, articleTime, imgUrl} = item;
            dataInfo[info.name].push({title, desc, articleTime, imgUrl});
        });
    }
   
    return {dataInfo};
}


/**
 * 学习园地视频资料
 * @param param0 
 * @returns 
 */
export async function xueXiYuanDiShiPin({type}) {
    let dataList = [];

    let spDBList = await find(TABLEENUM.视频管理, {videoType:type, display:STATE.是});
    spDBList.forEach(info => {
        let addInfo:any = extractData(info, ["title", "videoUrl", "videoTime"]);
        addInfo.videoTime = moment(addInfo.videoTime).format("YYYY-MM-DD");
        dataList.push(addInfo);
    });

    return {dataList};
}

/**
 * 学习园地文字资料
 * @param param0 
 * @returns 
 */
export async function xueXiYuanDiWenZi({type}) {
    let dataList = [];
    let wzDBList = await find(TABLEENUM.文字资料, {type});
    wzDBList.forEach(info => {
        let addInfo:any = extractData(info, ["title", "rank", "imgUrl", "articleUrl", "updateTime"]);
        addInfo.updateTime = moment(addInfo.updateTime).format("YYYY-MM-DD");
        dataList.push(addInfo);
    });

    return {dataList};
}


/**
 * 党建资源列表
 * @param param0 
 * @returns 
 */
export async function dangJianZiYuan({first, secondary, three, pageNumber}) {
    let dataList = [];
    let dataCount = 0;
    if (first == PARTYBUILDTYPEENUM.主题教育) {
        let findParam = {articleType:{"$in":[secondary]}, display:STATE.是};
        let dataBaseList = await findToPage(TABLEENUM.文章管理, findParam, ["title", "desc", "articleTime", "imgUrl"], pageNumber);
        dataCount = await findCount(TABLEENUM.文章管理, findParam);
        dataBaseList.forEach(item => {
            let {title, desc, articleTime, imgUrl} = item;
            dataList.push({title, desc, articleTime, imgUrl});
        });
    } else {//学习园地
        if (secondary == PARTYBUILDSUBTYPEENUM.文字资料) {
            let wzDBList = await findToPage(TABLEENUM.文字资料, {type:three}, ["title", "rank", "imgUrl", "articleUrl", "updateTime"], pageNumber);
            dataCount = await findCount(TABLEENUM.文字资料, {type:three});
            wzDBList.forEach(info => {
                let addInfo:any = extractData(info, ["title", "rank", "imgUrl", "articleUrl", "updateTime"]);
                addInfo.updateTime = moment(addInfo.updateTime).format("YYYY-MM-DD");
                dataList.push(addInfo);
            });
            
        } else {
            let spDBList = await findToPage(TABLEENUM.视频管理, {videoType:three, display:STATE.是}, ["title", "videoUrl", "videoTime"], pageNumber);
            dataCount = await findCount(TABLEENUM.视频管理, {videoType:three, display:STATE.是});
            spDBList.forEach(info => {
                let addInfo:any = extractData(info, ["title", "videoUrl", "videoTime"]);
                addInfo.videoTime = moment(addInfo.videoTime).format("YYYY-MM-DD");
                dataList.push(addInfo);
            });
        }
    }

    return {dataList, dataCount};
}


/**
 * 党建资源列表目录
 */
export async function dangJianZiYuanMuLu({}) {
    let dataList = [
        {
            name:"主题教育",
            value:PARTYBUILDTYPEENUM.主题教育,
            subList:[]
        },
        {
            name:"学习园地",
            value:PARTYBUILDTYPEENUM.学习园地,
            subList:[
                {
                    name:"视频资料",
                    value:PARTYBUILDSUBTYPEENUM.视频资料,
                    subList:[]
                },
                {
                    name:"文字资料",
                    value:PARTYBUILDSUBTYPEENUM.文字资料,
                    subList:[]
                }
            ]
        }
    ];
    let dbList = await find(TABLEENUM.党建, {type:PARTYBUILDTYPEENUM.主题教育});
    for (let i = 0; i < dbList.length; i++) {
        let info = dbList[i];
        dataList[0].subList.push({
            name:info.name,
            value:info.id,
            subList:[]
        });
    }
    for (let key in DANGJIANVIDEO) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            let value = DANGJIANVIDEO[key];
            dataList[1].subList[0].subList.push({name:keyStr, value});
        }
    }
    let wenZiDBList = await find(TABLEENUM.党建, {type:PARTYBUILDTYPEENUM.学习园地, subType:PARTYBUILDSUBTYPEENUM.文字资料});
    wenZiDBList.forEach(info => {
        let {id, name} = info;
        dataList[1].subList[1].subList.push({name, value:id});
    });

    return {dataList};
}

/**
 * 通知公告
 * @param param0 
 * @returns 
 */
export async function tongZhiGongGao({type, pageNumber}) {
    eccEnumValue("通知公告", "类型", TONGZHIGONGGAO, type);
    let tableName;
    switch (type) {
        case TONGZHIGONGGAO.会议通知: tableName = TABLEENUM.会议通知; break;
        case TONGZHIGONGGAO.活动通知: tableName = TABLEENUM.活动通知; break;
        case TONGZHIGONGGAO.项目公告: tableName = TABLEENUM.项目公告; break;
    }

    let dbList = await findToPage(tableName, {push:STATE.是}, ["id", "name", "st", "addrest", "members", "desc"], pageNumber);
    let dataCount = await findCount(tableName, {push:STATE.是});
    let dataList = [];
    dbList.forEach(info => {
        let item:any = extractData(info, ["id", "name", "addrest"]);
        item.time = moment(info.st).format("YYYY-MM-DD");
        item.desc = info.desc || "";
        item.members = changeEnumValue(CODPARTICIPANT, info.members);
        dataList.push(item);
    });

    return { dataList, dataCount};
}


export async function tongZhiGongGaoInfo({id, type}) {
    eccEnumValue("通知公告", "类型", TONGZHIGONGGAO, type);
    let tableName;
    switch (type) {
        case TONGZHIGONGGAO.会议通知: tableName = TABLEENUM.会议通知; break;
        case TONGZHIGONGGAO.活动通知: tableName = TABLEENUM.活动通知; break;
        case TONGZHIGONGGAO.项目公告: tableName = TABLEENUM.项目公告; break;
    }
    let dbData = await findOnce(tableName, {id, push:STATE.是}, ["id", "name", "st", "addrest", "members", "desc"]);
    if (!dbData || !dbData.id) throw new BizError(ERRORENUM.目标数据不存在);
    let dataInfo:any = extractData(dbData, ["name", "addrest"]);
    dataInfo.time = moment(dbData.st).format("YYYY-MM-DD");
    dataInfo.desc = dbData.desc || "";
    dataInfo.members = changeEnumValue(CODPARTICIPANT, dbData.members);
    
    return {dataInfo};
}



/**
 * 热门排行
 */
export async function reMenPaiHang({type}) {
    /**学会动态 每个动态资讯取最新的可见的三个*/
    let wenZhangTypeList = [type];
    let dongTaiZiXunData = await find(TABLEENUM.文章管理, {articleType:{"$in":wenZhangTypeList }, display:STATE.是});
    let dataList = [];
    dongTaiZiXunData.forEach(info => {
        let {id, title, articleTime, desc } = info;
        dataList.push({
            id, title, articleTime:moment(articleTime).format("YYYY-MM-DD"), desc
        });
    });
    return {dataList}
}


export async function fenZhiJiGou() {
    let jiGouList = await find(TABLEENUM.机构管理, {}, ["logoUrl", "id", "name"]);

    let dataList = [];

    jiGouList.forEach(info => {
        let {id, logoUrl, name } = info;
        dataList.push({
            id, logoUrl, name, count:28
        });
    });

    return {dataList};
}


export async function fenHuiDongTai({agencyId, pageNumber}) {
    let selectParam:any = {};
    if (agencyId) selectParam.agencyId = agencyId;
    let jiGouList = await findToPage(TABLEENUM.工作动态, selectParam, ["id", "title", "activityTime", "imgUrl"], pageNumber);
    let dataCount = await findCount(TABLEENUM.工作动态, selectParam);

    let dataList = [];
    jiGouList.forEach(info => {
        let {id, title, activityTime, imgUrl} = info;
        dataList.push({id, title, activityTime:moment(activityTime).format("YYYY-MM-DD"), imgUrl});
    });

    return { dataList, dataCount }
}

export async function fenHuiInfo({id}) {
    let result = {
        jiGouXinXi:{},
    };
    let dataInfo = await findOnce(TABLEENUM.机构管理, {id});

    result.jiGouXinXi = extractData(dataInfo, ["name", "createTime", "desc"]);
    result.jiGouXinXi["createTime"] = moment(dataInfo.createTime).format("YYYY-MM-DD");
   
    return result;
}

export async function fenHuiDongTaiInfo({id}) {
    let dongTaiInfo = await findOnce(TABLEENUM.工作动态, {id, isUse:true}, ["id", "title", "activityTime", "imgUrl", "desc"]);
    if (!dongTaiInfo || !dongTaiInfo.id) throw new BizError(ERRORENUM.目标数据不存在);
    let dataInfo = extractData(dongTaiInfo, ["title", "activityTime", "imgUrl", "desc"]);
    return {dataInfo}
}

/**
 * 委员名单
 */
export async function weiYuanMingDanList({name, agencyId, pageNumber, pageSize}) {
    let selectParam:any = {agencyId};
    if (name) selectParam.name = name;
    let dataList = [];
    let dbList = await findToSortToPage(TABLEENUM.委员名单, selectParam, ["name", "branchDuties", "unit", "unitDuties"], {branchDuties:1}, pageNumber, pageSize);
    let dataCount = await findCount(TABLEENUM.委员名单, selectParam);
    dbList.forEach(info => {
        let addInfo:any = extractData(info, ["name", "unit", "unitDuties"]);
        addInfo.branchDuties = changeEnumValue(BRANCHPOSITION, info.branchDuties);
        dataList.push(addInfo);
    });

    return {dataList, dataCount}
}


export async function xueXiYuanDiWenZiType() {
    let typeList = await find(TABLEENUM.党建, {type:PARTYBUILDTYPEENUM.学习园地, subType:PARTYBUILDSUBTYPEENUM.文字资料, display:STATE.是});

    let dataList = []
    typeList.forEach(info => {
        let {id, name } = info;
        dataList.push({
            key:name,
            value:id
        });
    });

    return {dataList};
}

export async function xueXiYuanDiShiPinType() {
    
    let dataList = [];
    for (let key in DANGJIANVIDEO) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            let value = DANGJIANVIDEO[key];
            dataList.push({key:keyStr, value});
        }
    }
    return {dataList};
}

