/**
 * 系统中使用的工具
 * 包括 草稿箱id生成规则
 * 包括 密码加密规则
 */

import moment = require("moment");
const md5 = require("md5");

/**
 * 返回编辑正确的结果
 * @returns 
 */
export function successResult() {
    return {success:true}
}

/**
 * 生成系统id
 * @param tableName 
 * @param userId 
 * @returns 
 */
export function generateSystemId(tableName:string, userId:string) {
    return md5(`${tableName}${Math.floor(Math.random() * 10000)}${userId}${new Date().valueOf()}${Math.floor(Math.random() * 100)}`);
}

/**
 * 生成token
 * @param userId 
 * @returns 
 */
export function generateToken(userId:string) {
    return md5(`${userId}${Math.floor(Math.random() * 10000)}${new Date().valueOf()}${Math.floor(Math.random() * 100)}`);
}

/**
 * 生成userid
 */
export function generateUserId() {
    return md5(`${Math.random() * 100}${new Date().valueOf()}${Math.floor(Math.random() * 10000)}`);
}

/**
 * 获取code的id
 * @param loginId 用户Id
 * @param todaySendCount 今日发送次数
 * @returns ''
 */
 export function getSMSCodeId(loginId:string, todaySendCount:number) {
    return md5(`${loginId}${todaySendCount}${new Date().valueOf()}`);
}


/**
 * 获取一个随机6位数的验证码
 * @returns 
 */
export function generateSMSCode() {
    let code = ``;
    for (let i =0; i < 6; i++) {
        code += Math.floor(Math.random() * 10);
    }
    return code;
}


/**
 * 生成唯一订单id
 */
export function generateOrderId(userId:string) {
    return md5(`${userId}${Math.random() * 100}${new Date().valueOf()}${Math.floor(Math.random() * 1000)}`);
}


/*
 * 获取今天开始时刻的时间戳  0时0分
 * @returns 
 */
export function getTodayMs() {
    return new Date(`${ moment().format("YYYY-MM-DD")} 00:00:00`).valueOf();
}



export function generateWXOrderId(memberType, userId) {
    let thisDate = new Date();
    return `${md5(`${memberType}${userId}${Math.random() * 100}${thisDate.valueOf()}${Math.floor(Math.random() * 1000)}`)}`
}

