/**
 * 总路由入口
 *
 * 
 * */

import { ERRORENUM } from "../config/errorEnum";
import { getDoc, initDoc } from "../tools/reqResult";
import { BizError } from "../util/bizError";
import { eccFormParam, eccReqParamater } from "../util/verificationParam";
import * as portalRouter from "./portal/router";
import * as publicRouter from "./public/router";
import * as memberRouter from "./member/router";
import * as costRouter from "./cost/router";
import * as officalWebsiteRouter from "./officalWebsite/router";
import * as orderRouter from "./order/router";
import * as asyncHandler from 'express-async-handler';
import { payCallback } from "../biz/member/cost";
import { checkUser, notCheck } from "../middleware/user";

const Look = false;//true更新文档

export async function setRouter(httpServer){
    if (Look) {
        await getDoc();
        await initDoc(portalRouter.FirstName, portalRouter.Config, portalRouter.FirstRouter);//网站编辑
        await initDoc(publicRouter.FirstName, publicRouter.Config, publicRouter.FirstRouter);//公用组件
        await initDoc(memberRouter.FirstName, memberRouter.Config, memberRouter.FirstRouter);//用户路由
        await initDoc(officalWebsiteRouter.FirstName, officalWebsiteRouter.Config, officalWebsiteRouter.FirstRouter);//官网路由
        await initDoc(orderRouter.FirstName, orderRouter.Config, orderRouter.FirstRouter);//会费相关
        await initDoc(costRouter.FirstName, costRouter.Config, costRouter.FirstRouter);//支付
    }
    await analysisRouter(httpServer, portalRouter.Config, portalRouter.FirstRouter, false);//网站编辑
    await analysisRouter(httpServer, publicRouter.Config, publicRouter.FirstRouter, false);//公用组件
    await analysisRouter(httpServer, memberRouter.Config, memberRouter.FirstRouter, true);//用户路由
    await analysisRouter(httpServer, officalWebsiteRouter.Config, officalWebsiteRouter.FirstRouter, false);//官网路由
    await analysisRouter(httpServer, orderRouter.Config, orderRouter.FirstRouter, true);//会费相关
    await analysisRouter(httpServer, costRouter.Config, costRouter.FirstRouter, true);//支付
}


async function analysisRouter(httpServer, config, firstRouter, haveMiddleware) {
    for (let modelKey in config) {
        config[modelKey].forEach(info => {
            let {apiName, defaultParam, subUrl, param, bindBiz, notMiddleware} = info;
            httpServer.post(firstRouter+subUrl, haveMiddleware? checkUser : notCheck, asyncHandler(async function (req, res) {
                let chackObjectList = [];
                let checkStringMap = {};
                let stringNotMustHaveKeys = [];
                
                let funcParam:any = {};
                funcParam.userId = req.headers.userId;
        
                for (let i = 0; i < param.length; i++) {
                    let info:any = param[i];
                    let {key, type} = param[i];
                    if (info.isNull) stringNotMustHaveKeys.push(key);
                    if (type == 'Object') {
                        chackObjectList.push(param[i]);
                        checkStringMap[key] = type;
                    }
                    else checkStringMap[key] = type; 
                }
                /**校验参数 */
                if (chackObjectList.length) {
                    chackObjectList.forEach(item => {
                        if (!req.body[item.key]) throw new BizError(ERRORENUM.参数错误, `${apiName}`, `缺少参数${item.key}`);
                        eccFormParam(apiName, item.sub, req.body[item.key]);
                        funcParam[item.key] = req.body[item.key];
                    });
                 }
                if (Object.keys(checkStringMap).length) {
                    let eccResult = eccReqParamater(apiName, checkStringMap, req.body, stringNotMustHaveKeys);
                    for (let key in eccResult) {
                        funcParam[key] = eccResult[key];
                    }
                }
                if (defaultParam) funcParam["defaultParam"] = defaultParam;
                let result = await bindBiz(funcParam);
        
                res.success(result);
            }));
        });   
    }
    
}




export async function setAdditionalRouter(httpServer) {
    httpServer.post('/pay/wechart/callback', asyncHandler(async (req, res) => {
        await payCallback(req.body);
        res.success({});
    }));
}
