
export enum ERRORENUM {
    身份验证失败,
    非法登录,
    身份验证过期,
    code无效,
    频繁操作请稍后再试,
    高风险等级用户,
    系统繁忙,
    请完善信息,
    参数错误,
    地址数据不完整,
    文件上传失败,
    只能上传png或jpg图片,
    系统错误,
    目标数据不存在,
    账号或密码错误,
    用户名重复,
    联系人手机号重复,
    邮箱重复,
    两次密码不一致,
    密码只能由6至18位字符和数字组成,
    发送验证码次数超限制,
    发送验证码频率过快,
    验证码错误,
    验证码失效,
    验证码过期,
    重复提交,
    无法获取未来届次,
    微信支付无法被退回,
    订单状态无法开具发票,
    微信支付无法退回发票请求,
    流程3不支持会员身份非单位会员,
    数据状态错误,
    用户已注册成功,
    不具备审批条件,
    该用户已在宽限期内,
    该订单已支付,
    调起微信支付失败,
    查看微信支付状态失败,
    订单不存在,
    发票已开具不可重复提交,
    请求已被退回请重新申请,
    不满足重新请求条件,
    该订单正在支付,
}

export enum ERRORCODEENUM {
    身份验证失败 = 401,
    非法登录 = 402,
    身份验证过期 = 403,
    code无效 = 40029,
    频繁操作请稍后再试 = 45011,
    高风险等级用户 = 40226,
    系统繁忙 = 40227
}

let bizErrorMsgMap = {};
for (let key in ERRORENUM) {
    bizErrorMsgMap[ERRORENUM[key]] = key;
}

export function getBizMsg(param) {
    return bizErrorMsgMap[param];
}