/**
 * 用户逻辑
 */

import { DOCUMENTTYPE, MEMBERLEVEL, MEMBERTYPE, NATION, PROFCATEGORY, SEX, STATE } from "../../config/enum";
import { ERRORCODEENUM, ERRORENUM } from "../../config/errorEnum";
import { addOneData } from "../../data/add";
import { TABLEENUM } from "../../data/models/model";
import { findOnce } from "../../data/select";
import { updateOneData } from "../../data/update";
import { generateToken, generateUserId, successResult } from "../../tools/system";
import { BizError } from "../../util/bizError";
import { eccEnumValue } from "../../util/verificationEnum";



/**
 * 登陆
 * @param param0 
 * @returns 
 */
export async function login({loginId, pwd}) {
    let selectParam = { "$or":[{loginId:loginId}, {phone:loginId}] };
    let userInfo = await findOnce(TABLEENUM.用户表, selectParam);
    
    if (!userInfo || !userInfo.userId) throw new BizError(ERRORENUM.账号或密码错误);
    if (userInfo.pwd != pwd ) throw new BizError(ERRORENUM.账号或密码错误);

    let token = generateToken(userInfo.userId);
    await updateOneData(TABLEENUM.用户表, {userId:userInfo.userId}, {token, tokenMs:new Date().valueOf()});

    let dataInfo = {
        isAdmin:userInfo.isAdmin == STATE.是,
        name:userInfo.name,
        userId:userInfo.userId,
        token:token,
        adminLv:userInfo.adminLv
    };

    return {dataInfo}
}


/**
 * 退出登陆
 * @param userId 
 * @returns 
 */
export async function logout({userId}) {
    let token = generateToken(userId);
    await updateOneData(TABLEENUM.用户表, {userId:userId}, {token});

    return successResult();
}



