import { MAILTYPE, MEMBERTYPE } from "../config/enum";
import { ERRORENUM } from "../config/errorEnum";
import { CLIENTMAILTYPE } from "../config/outPutConfig";
import { TABLEENUM } from "../data/models/model";
import { findOnce } from "../data/select";
import { successErrorResult, successResult } from "../tools/system";
import { BizError } from "../util/bizError";
import { eccEnumValue } from "../util/verificationEnum";

const nodemailer = require('nodemailer');

// 创建发送邮件的传输对象
let transporter = nodemailer.createTransport({
    host: 'smtp.163.com', // SMTP 服务器地址
    port: 465, // SMTP 服务器端口（通常是 465 或 587）
    secure: true, // 使用 SSL
    auth: {
        user: 'cefa_office@163.com', // 你的邮箱地址
        pass: 'EJRazhkkXK65gnLe' // 你的邮箱密码或应用专用密码
    }
});

// 测试用邮箱地址
// let transporter = nodemailer.createTransport({
//     host: 'smtp.qq.com', // SMTP 服务器地址
//     port: 465, // SMTP 服务器端口（通常是 465 或 587）
//     secure: true, // 使用 SSL
//     auth: {
//         user: '3102438911@qq.com', // 你的邮箱地址
//         pass: 'erdfcv425860.' // 你的邮箱密码或应用专用密码
//     }
// });



async function send(toMail, name, type) {
    let {title, mailStr} = getModel(name, type);
    // 设置邮件选项
    let mailOptions = {
        from: '学会办公室 <cefa_office@163.com>', // 发送者地址
        to: toMail,
        subject: `关于CEFA会员系统的${title}通知`, // 邮件主题
        // text: 'Hello world?', // 邮件正文（纯文本）
        html: mailStr // 邮件正文（HTML 格式）
    };

    // new promises
    return new Promise((resolve, reject) => {
        transporter.sendMail(mailOptions, (error, info) => {
            if (error) {
                throw new BizError(ERRORENUM.短信发送失败);
            }
            resolve(info);
        });
    });
}

/**
 * 

 //发送邮件
await systemSendMail(userInfo.userId, MAILTYPE.审核期间驳回通知 );


 */
function getModel(name, type) {
    let str = "";
    let title = "";
    switch (type) {
        case MAILTYPE.审核期间驳回通知:
            str = "您提交的会员注册信息已驳回，为避免您错过会议审核时间，请尽快登陆会员网站查看详情重新确认提交。";
            title = "审核驳回";
        break;
        case MAILTYPE.审核通过以及缴费通知:
            str = "您的入会申请已审核通过，请登陆会员网站进行缴费处理。"; 
            title = "审核通过";
        break;
        case MAILTYPE.会员缴费财务驳回无需退款:
            str = "您提交的会费单据未通过审核，请登陆会员网站查看详情重新确认提交。";
            title = "缴费驳回";
        break;
        case MAILTYPE.会员缴费财务驳回需退款:
            str = "您提交的会费单据未通过审核，需提供退款账户，请登陆会员网站查看详情重新确认提交。";
            title = "缴费驳回";
        break;
        case MAILTYPE.会员缴费成功后针对线下汇款财务审核通过的时候发送:
            str = "您的年度会费已支付成功，恭喜您成为我会会员！请登陆会员网站查看相关服务详情。";
            title = "缴费成功";
        break;
        case MAILTYPE.会员会费到期缴费通知://这里还没做
            str = "您的会员服务已过期限，为避免您的服务受到影响，请及时登录会员网站进行缴费处理。";
            title = "会费到期";   
        break;
        case MAILTYPE.会员催缴通知提前开发票:
            str = "您的发票已开具，为避免您的服务受到影响，请您在14个工作日内登录会员网站完成缴费流程。";
            title = "发票开具成功";   
        break;
        case MAILTYPE.会员进入宽限期:
            str = "您的会员服务已进入宽限期，为避免您的服务受到影响，请于30日内登录会员网站进行缴费处理。";
            title = "会员进入宽限期";   
        break;
        case MAILTYPE.会员宽限期最后一天: //这里还没做
            str = "您的会员服务已到期，为避免您的服务受到影响，请及时登录会员网站进行缴费处理。";
            title = "服务到期"; 
        break;
        case MAILTYPE.变更驳回:
            str = "您提交的变更申请未通过审核，请登陆会员网站查看详情重新确认提交。"; 
            title = "变更驳回"; 
        break;
        case MAILTYPE.变更已通过:
            str = "您提交的变更申请已审核通过，请登陆会员网站查看相关服务详情。 ";
            title = "变更通过"; 
        break;
        case MAILTYPE.会员活动or会议通知:
            str = "学会邀请您关注《关于xxxxxx的通知》，请登陆会员网站查看活动须知以及参与报名。"; 
            title = "活动"; 
        break;
        case MAILTYPE.财务退款通知:
            str = "您的会费退款已处理，请登陆会员网站重新缴纳会费。";
            title = "退款处理"; 
        break;
    }

    let mailStr = ""
    mailStr +=`<p>尊敬的${name}：</p>`;
    mailStr +=`<p>您好！</p>`;
    mailStr +=`<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;${str}</p>`;
    mailStr +=`<p>电话咨询: 010-86208681</p>`;
    mailStr +=`<p>登录地址: <a href="https://www.cefaweb.com/member">https://www.cefaweb.com/member</a></p>`;
    mailStr +=`<p>如有问题，欢迎您与秘书处进行联系。</p>`;
    mailStr +=`<p>感谢您对学会工作的支持。祝好！</p>`;
    mailStr +=`<p>--</p>`;
    mailStr += `<p>中国艺术职业教育学会 办公室<p>`;
    mailStr += `<p>地址:北京市南竹杆胡同2号<p>`;
    mailStr += `<p>电话:010-86208681<p>`;
    mailStr += `<p>电邮:cefa office@163.com<p>`;

    return {mailStr, title};
}


/**
 * 发送邮件 （管理后台触发）
 * @param param0 
 * @returns 
 */
export async function sendMail({id, type}) {
    eccEnumValue("发送邮件", "邮件类型", CLIENTMAILTYPE, type);
    let userInfo = await findOnce(TABLEENUM.用户表, {userId:id}, ["userId", "name", "unitName", "memberType", "mail"]);

    if (!userInfo || !userInfo.userId) throw new BizError(ERRORENUM.用户不存在);
    if (!userInfo.mail) {
        throw new BizError(ERRORENUM.该用户邮箱为空);
    }

    let nameStr = userInfo.memberType == MEMBERTYPE.个人会员 ? userInfo.name : userInfo.unitName;
    let result = await send(userInfo.mail, nameStr, type);

    return successResult();
}


/**
 * 系统发送邮件
 * @param userId 
 * @param type 
 */
export async function systemSendMail(userId, type) {
    let userInfo = await findOnce(TABLEENUM.用户表, {userId:userId}, ["userId", "name", "unitName", "memberType", "mail"]);

    if (!userInfo || !userInfo.userId) throw new BizError(ERRORENUM.用户不存在);
    if (!userInfo.mail) {
        new BizError(ERRORENUM.该用户邮箱为空, userId, userInfo.name || userId.unitName);
    } else {
        let nameStr = userInfo.memberType == MEMBERTYPE.个人会员 ? userInfo.name : userInfo.unitName;
        let result = await send(userInfo.mail, nameStr, type);
    }

    return successResult();
}