/**
 * 异常类
 * 需要和log4js共同使用
 */

import { getBizMsg } from "../config/errorEnum";
import { logConsole, logError } from "./log";

export class BizError extends Error {
    constructor(...msgs) {
        let reqErrorMsg = '';
        let logErrorMsg = '';
        for (let i = 0; i <msgs.length; i++) {
            if (!i) {
                let msg = getBizMsg(msgs[i]);
                reqErrorMsg = msg;
                logErrorMsg = msg;
            } else {
                logErrorMsg += ` | ${msgs[i]} `;
            }
        }

        logError(logErrorMsg);
        super(reqErrorMsg);
    }
}



// export class ConsoleError extends Error {
//     constructor(...msgs) {
//         let reqErrorMsg = '';
//         let logErrorMsg = '';
//         for (let i = 0; i <msgs.length; i++) {
//             if (!i) {
//                 let msg = getBizMsg(msgs[i]);
//                 reqErrorMsg = msg;
//                 logErrorMsg = msg;
//             } else {
//                 logErrorMsg += ` | ${msgs[i]} `;
//             }
//         }

//         logConsole(logErrorMsg);
//         super(reqErrorMsg);
//     }
// }



