/**
 * 黑名单
 */
import * as blacklistBiz from "../../biz/member/blacklist";
import { ADMINLV } from "../../config/enum";


export const FirstName = '黑名单';
export const FirstRouter = '/manage/blacklist';
export const Config = {
    "黑名单管理":[
        {
            apiName:"黑名单列表",
            subUrl:'/blacklistdb/blacklist',
            param:[
                {key:"name", type:"String", desc:"单位/个人名称", isNull:true},
                {key:"joinStartTime", type:"Number", desc:"入会开始时间", isNull:true},
                {key:"joinEndTime", type:"Number", desc:"入会结束时间", isNull:true},
                {key:"memberType", type:"[Number]", desc:"单位会员类型", isNull:true},
                {key:"memberLevel", type:"[Number]", desc:"会员等级职务", isNull:true},
                {key:"session", type:"Number", desc:"届次", isNull:true},
                {key:"sheng", type:"String", desc:"省", isNull:true},
                {key:"shi", type:"String", desc:"市", isNull:true},
                {key:"qu", type:"String", desc:"区", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:blacklistBiz.blackList
        },
        {
            apiName:"移入黑名单【操作在单位会员页、个人会员页】",
            subUrl:'/blacklistdb/moveinblackuser',
            param:[
                {key:"id", type:"String", desc:"用户id"},
            ],
            bindBiz:blacklistBiz.moveInBlackUser
        },
        {
            apiName:"移除黑名单",
            subUrl:'/blacklistdb/shiftoutblackuser',
            param:[
                {key:"id", type:"String", desc:"用户id"},
            ],
            bindBiz:blacklistBiz.shiftOutBlackUser
        },
        {
            apiName:"删除信息",
            subUrl:'/blacklistdb/delblackuser',
            param:[
                {key:"id", type:"String", desc:"用户id"},
            ],
            bindBiz:blacklistBiz.delBlackUser
        },
    ]
}
 
 
 
 
 
 
 
 