const path = require('path');
import * as fs from "fs";
import { BizError } from "../util/bizError";
import { analysisXml } from "../util/myXML";
import { ServerConfig } from "../config/systemClass";
const os = require('os');

export let systemConfig =  new ServerConfig;
export const SessionTimeMsConfig = {
  "5_1":{activTime:'2013-3-30 08:00:00', timeMs:new Date('2013-3-30 08:00:00').valueOf()},
    "5_2":{activTime:'2014-4-24 08:00:00', timeMs:new Date('2014-4-24 08:00:00').valueOf()},
    "5_3":{activTime:'2015-4-10 08:00:00', timeMs:new Date('2015-4-10 08:00:00').valueOf()},
    "5_4":{activTime:'2015-11-4 08:00:00', timeMs:new Date('2015-11-4 08:00:00').valueOf()},
    "5_5":{activTime:'2016-4-22 08:00:00', timeMs:new Date('2016-4-22 08:00:00').valueOf()},
    "5_6":{activTime:'2016-12-15 08:00:00', timeMs:new Date('2016-12-15 08:00:00').valueOf()},
    "5_7":{activTime:'2017-4-6 08:00:00', timeMs:new Date('2017-4-6 08:00:00').valueOf()},
    "6_1":{activTime:'2017-6-24 08:00:00', timeMs:new Date('2017-6-24 08:00:00').valueOf()},
    "6_2":{activTime:'2017-11-28 08:00:00', timeMs:new Date('2017-11-28 08:00:00').valueOf()},
    "6_3":{activTime:'2018-3-26 08:00:00', timeMs:new Date('2018-3-26 08:00:00').valueOf()},
    "6_4":{activTime:'2018-12-8 08:00:00', timeMs:new Date('2018-12-8 08:00:00').valueOf()},
    "6_5":{activTime:'2019-3-28 08:00:00', timeMs:new Date('2019-3-28 08:00:00').valueOf()},
    "6_6":{activTime:'2019-10-25 08:00:00', timeMs:new Date('2019-10-25 08:00:00').valueOf()},
    "6_7":{activTime:'2020-12-19 08:00:00', timeMs:new Date('2020-12-19 08:00:00').valueOf()},
    "6_8":{activTime:'2021-4-23 08:00:00', timeMs:new Date('2021-4-23 08:00:00').valueOf()},
    "6_9":{activTime:'2021-12-3 08:00:00', timeMs:new Date('2021-12-3 08:00:00').valueOf()},
    "6_10":{activTime:'2022-12-27 08:00:00', timeMs:new Date('2022-12-27 08:00:00').valueOf()},
    "7_1":{activTime:'2023-6-10 08:00:00', timeMs:new Date('2023-6-10 08:00:00').valueOf()},
    "7_2":{activTime:'2023-11-13 08:00:00', timeMs:new Date('2023-11-13 08:00:00').valueOf()},
    "7_3":{activTime:'2024-5-11 08:00:00', timeMs:new Date('2024-5-11 08:00:00').valueOf()}
}

const ConfigName = "serverConfig.xml";
export async function initConfig() {
    try {
        let buff = fs.readFileSync(path.join(__dirname.substring(0,__dirname.indexOf("out")), ConfigName));
        let configStr = buff.toString();
        let configInfo:any = await analysisXml(configStr);
		if (!configInfo || !configInfo.config) throw new BizError('xml中无配置');
		else {
            
            let {port, mongodb, mysqldb, specifyDB, weChart  } = configInfo.config;
            systemConfig.port = parseInt(port[0]);

            const MongoPath = mongodb[0].path[0];
            const MongoPort = mongodb[0].port[0];
            const MongoW = mongodb[0].w[0];
            const MongoDataBase = mongodb[0].dataBase[0];
            const MongoWtimeoutMS = mongodb[0].wtimeoutMS[0];
            systemConfig.mongodbStr = analysisMongoConnectStr( MongoPath, MongoPort, MongoDataBase, MongoW, MongoWtimeoutMS);

            if (mysqldb) {
                let dbConfigInfo = mysqldb[0];
                systemConfig.mysqldb = {host:'', port:0, user:'', pwd:'', dataBase:''};
                if (dbConfigInfo.mysqlHost && dbConfigInfo.mysqlPort && dbConfigInfo.mysqlUser && dbConfigInfo.dataBase) {
                    systemConfig.mysqldb.host=dbConfigInfo.mysqlHost[0];
                    systemConfig.mysqldb.port=parseInt(dbConfigInfo.mysqlPort[0]);
                    systemConfig.mysqldb.user=dbConfigInfo.mysqlUser[0];
                    systemConfig.mysqldb.pwd=dbConfigInfo.mysqlPwd[0] || "";
                    systemConfig.mysqldb.dataBase=dbConfigInfo.dataBase[0];
                }
            }

            systemConfig.weChartNotifyUrl = weChart[0].notifyUrl[0];

            if (specifyDB) {
                systemConfig.specifyDB = specifyDB[0];
            } else systemConfig.specifyDB = null;
		}
        
        console.log("config init success");

    } catch(err) {
        console.log('ERROR => 服务器配置解析错误 请检查根目录下 serverConfig.xml 文件是否正确');
        console.log(err);
        throw new BizError("服务器配置解析错误 请检查根目录下 serverConfig.xml 文件是否正确");
    }
}

function analysisMongoConnectStr(path, port, dataBase, w, timeOutMs) {
    return `mongodb://${path}:${port}/${dataBase}?w=${w}&wtimeoutMS=${timeOutMs}`
}
 
export function getEnum() {
    
}