
export enum ERRORENUM {
    身份验证失败,
    非法登录,
    身份验证过期,
    code无效,
    频繁操作请稍后再试,
    高风险等级用户,
    系统繁忙,
    请完善信息,
    参数错误,
    地址数据不完整,
    文件上传失败,
    只能上传png或jpg图片,
    系统错误,
    目标数据不存在,
    账号或密码错误,
    用户名重复,
    联系人手机号重复,
    邮箱重复,
    两次密码不一致,
    密码只能由6至18位字符和数字组成,
    发送验证码次数超限制,
    发送验证码频率过快,
    验证码错误,
    验证码失效,
    验证码过期,
    重复提交,
    无法获取未来届次,
    微信支付无法被退回,
    订单状态无法开具发票,
    微信支付无法退回发票请求,
    流程3不支持会员身份非单位会员,
    数据状态错误,
    用户已注册成功,
    不具备审批条件,
    该用户已在宽限期内,
    该订单已支付,
    调起微信支付失败,
    查看微信支付状态失败,
    订单不存在,
    发票已开具不可重复提交,
    请求已被退回请重新申请,
    不满足重新请求条件,
    该订单正在支付,
    微信支付回调错误,
    支付失败,
    地址数据错误,
    该账号已被冻结,
    手机号不正确,
    短信验证码发送失败,
    该手机号已被注册,
    不存在该手机号的账号,
    该动态未开放,
    找不到该机构,
    源文章已被删除,
    批量操作超过个数限制,
    标签重复,
    标签数据不存在,
    线下活动的活动时间必填,
    用户没有在此活动对象内,
    黑名单用户不允许登录,
    该订单未被退回,
    当前变更申请未发生变化,
    不可重复提交,
    订单非退回状态,
    该类型退款无需确认,
    注册信息待补充,
    超出可申请范围,
    权限错误,
    注册已暂时关闭,
}

export enum ERRORCODEENUM {
    身份验证失败 = 401,
    非法登录 = 402,
    身份验证过期 = 403,
    code无效 = 40029,
    频繁操作请稍后再试 = 45011,
    高风险等级用户 = 40226,
    系统繁忙 = 40227,
    黑名单用户不允许登录 = 40228
}

let bizErrorMsgMap = {};
for (let key in ERRORENUM) {
    bizErrorMsgMap[ERRORENUM[key]] = key;
}

export function getBizMsg(param) {
    return bizErrorMsgMap[param];
}