import * as orderBiz from "../../biz/member/order";

export const FirstName = '会费相关';
export const FirstRouter = '/manage/cost';
export const Config = {
    "审批管理":[
        // {
        //     apiName:"待支付列表",
        //     subUrl:'/order/fist/list', 
        //     param:[
        //         {key:"unitName", type:"String", desc:"单位名称", isNull:true},
        //         {key:"joinTime", type:"Number", desc:"入会时间 时间戳", isNull:true},
        //         {key:"memberType", type:"Number", desc:"会员类别 枚举参考公用组件", isNull:true},
        //         {key:"orderState", type:"Number", desc:"支付状态", isNull:true},
        //         {key:"pageNumber", type:"Number", desc:"分页-当前页面"}
        //     ],
        //     bindBiz:orderBiz.firstOrderList
        // },
        // {
        //     apiName:"确认待支付",
        //     subUrl:'/order/fist/pass', 
        //     param:[
        //         {key:"id", type:"String", desc:"订单标识"},
        //     ],
        //     bindBiz:orderBiz.checkOrder
        // },
        // {
        //     apiName:"待支付线下支付",
        //     subUrl:'/order/fist/offlinepayment',
        //     param:[
        //         {key:"orderId", type:"String", desc:"订单标识"},
        //         {key:"paymentNum", type:"String", desc:"转账单号"},
        //         {key:"offlinePaymentUrl", type:"String", desc:"转账截图"},
        //     ],
        //     bindBiz:orderBiz.offlinePayment
        // }
    ],
    "发票管理":[
        {
            apiName:"财务核对",
            subUrl:'/order/invoice/check/list', 
            param:[
                {key:"name", type:"String", desc:"名称", isNull:true},
                {key:"memberType", type:"[Number]", desc:"会员类别", isNull:true},
                {key:"documentId", type:"String", desc:"身份证", isNull:true},
                {key:"phone", type:"String", desc:"手机号", isNull:true},
                {key:"mail", type:"String", desc:"邮箱", isNull:true},
                {key:"joinStartTime", type:"Number", desc:"入会开始时间", isNull:true},
                {key:"joinEndTime", type:"Number", desc:"入会结束时间", isNull:true},
                {key:"memberLevel", type:"[Number]", desc:"个人级别职务", isNull:true},
                {key:"paymentType", type:"Number", desc:"支付方式", isNull:true},
                {key:"costType", type:"Number", desc:"会费类别", isNull:true},
                {key:"pageNumber", type:"Number", desc:"分页-当前页面"}
            ],
            bindBiz:orderBiz.paidList
        },
        {
            apiName:"待开发票",
            subUrl:'/order/invoice/list', 
            param:[
                {key:"name", type:"String", desc:"名称", isNull:true},
                {key:"memberType", type:"[Number]", desc:"会员类别", isNull:true},
                {key:"documentId", type:"String", desc:"身份证", isNull:true},
                {key:"phone", type:"String", desc:"手机号", isNull:true},
                {key:"mail", type:"String", desc:"邮箱", isNull:true},
                {key:"joinStartTime", type:"Number", desc:"入会开始时间", isNull:true},
                {key:"joinEndTime", type:"Number", desc:"入会结束时间", isNull:true},
                {key:"memberLevel", type:"[Number]", desc:"个人级别职务", isNull:true},
                {key:"paymentType", type:"Number", desc:"支付方式", isNull:true},
                {key:"isPay", type:"Number", desc:"是否支付", isNull:true},
                {key:"pageNumber", type:"Number", desc:"分页-当前页面"}
            ],
            bindBiz:orderBiz.billStateList
        },
        {
            apiName:"财务核对-收款确认",
            subUrl:'/order/invoice/examine/pass', 
            param:[
                {key:"id", type:"String", desc:"订单id"}
            ],
            bindBiz:orderBiz.confirmReceiptPass
        },
        {
            apiName:"财务核对-退回",
            subUrl:'/order/invoice/examine/out', 
            param:[
                {key:"id", type:"String", desc:"订单id"},
                {key:"isReceive", type:"Number", desc:"是否受到款项"},
                {key:"returnsReasons", type:"String", desc:"退回理由"}
            ],
            bindBiz:orderBiz.confirmReceiptOut
        },
        {
            apiName:"待开发票-上传发票 已开发票-修改发票",
            subUrl:'/order/invoice/examine/upinvoice', 
            param:[
                {key:"id", type:"String", desc:"订单id"},
                // {key:"invoiceUrl", type:"String", desc:"发票地址"},
            ],
            bindBiz:orderBiz.upInvoice
        },
        // {
        //     apiName:"待开发票-退回发票", 弃用
        //     subUrl:'/order/invoice/examine/backinvoice', 
        //     param:[
        //         {key:"id", type:"String", desc:"订单id"}
        //     ],
        //     bindBiz:orderBiz.backInvoice
        // },
        {
            apiName:"发票管理-已开发票",
            subUrl:'/order/invoice/examine/invoicedlist', 
            param:[
                {key:"name", type:"String", desc:"名称", isNull:true},
                {key:"memberType", type:"[Number]", desc:"会员类别", isNull:true},
                {key:"documentId", type:"String", desc:"身份证", isNull:true},
                {key:"phone", type:"String", desc:"手机号", isNull:true},
                {key:"mail", type:"String", desc:"邮箱", isNull:true},
                {key:"joinStartTime", type:"Number", desc:"入会开始时间", isNull:true},
                {key:"joinEndTime", type:"Number", desc:"入会结束时间", isNull:true},
                {key:"memberLevel", type:"[Number]", desc:"个人级别职务", isNull:true},
                {key:"paymentType", type:"Number", desc:"支付方式", isNull:true},
                {key:"isPay", type:"Number", desc:"是否支付", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"},
            ],
            bindBiz:orderBiz.invoicedList
        },
        {
            apiName:"转账单号弹窗",
            subUrl:'/order/transferscreenshot',
            param:[
                {key:"id", type:"String", desc:"订单id"},
            ],
            bindBiz:orderBiz.transferScreenshot
        },
        {
            apiName:"转账发票弹窗",
            subUrl:'/order/invoicepop',
            param:[
                {key:"id", type:"String", desc:"订单id"},
            ],
            bindBiz:orderBiz.invoicePop
        },
        {
            apiName:"退款列表",
            subUrl:'/order/refundlist',
            param:[
                {key:"pageNumber", type:"Number", desc:"当前页"},
            ],
            bindBiz:orderBiz.refundList
        },
        {
            apiName:"退款确认",
            subUrl:'/order/refundapprove',
            param:[
                {key:"id", type:"String", desc:"订单id"},
                {key:"refundImgUrl", type:"String", desc:"订单id"},
            ],
            bindBiz:orderBiz.refundApprove
        },
        // {
        //     apiName:"审批历史",
        //     subUrl:'/order/approve/log',
        //     param:[
        //         {key:"id", type:"String", desc:"订单id"},
        //     ],
        //     bindBiz:orderBiz.
        // },
    ],
    "会员个人页":[
        {
            apiName:"会员缴费列表",
            subUrl:'/order/memberpayment',
            param:[
                {key:"type", type:"Number", desc:"缴费状态", isNull:true}
            ],
            bindBiz:orderBiz.orderList
        },
        {
            apiName:"申请发票",
            subUrl:'/order/applicationinvoice',
            param:[
                {key:"id", type:"String", desc:"会员缴费列表返回id"},
                {key:"memberType", type:"Number", desc:"会员类型"},
                {key:"newUscc", type:"String", desc:"新的社会信用代码", isNull:true},
                {key:"newUnitName", type:"String", desc:"新的发票抬头", isNull:true}
            ],
            bindBiz:orderBiz.applicationInvoice
        },
        {
            apiName:"重新申请发票",
            subUrl:'/order/reapplyinvoice',
            param:[
                {key:"id", type:"String", desc:"会员缴费列表返回id"}
            ],
            bindBiz:orderBiz.reapplyInvoice
        },
        {
            apiName:"下载发票",
            subUrl:'/order/downinvoice',
            param:[
                {key:"id", type:"String", desc:"会员缴费列表返回id"}
            ],
            bindBiz:orderBiz.downInvoice
        },
        {
            apiName:"上传转账截图",
            subUrl:'/order/uptransferimg',
            param:[
                {key:"id", type:"String", desc:"会员缴费列表返回id"},
                {key:"weChartPR", type:"String", desc:"转账单号"},
                {key:"offlinePaymentUrl", type:"String", desc:"截图上传"},
                {key:"invoiceMail", type:"String", desc:"邮箱"},
                {key:"desc", type:"String", desc:"备注", isNull:true},
            ],
            bindBiz:orderBiz.upTransferImg
        },
        {
            apiName:"发票审核进度",
            subUrl:'/order/getinvoicestatus',
            param:[
                {key:"id", type:"String", desc:"会员缴费列表返回id"},
            ],
            bindBiz:orderBiz.getInvoiceStatus
        },
        {
            apiName:"退款原因回显",
            subUrl:'/order/refund/reasoninfo',
            param:[
                {key:"id", type:"String", desc:"会员缴费列表返回id"},
            ],
            bindBiz:orderBiz.reasonInfo
        },
        {
            apiName:"退款信息",
            subUrl:'/order/refund/accountinfo',
            param:[
                {key:"id", type:"String", desc:"会员缴费列表返回id"},
                {key:"form", type:"Object", sub:
                    {
                        refundName:{type:"String", desc:"姓名"},
                        refundBankCarId:{typs:"String", desc:"银行账号"},
                        refundBankName:{type:"String", desc:"银行开户行"},
                        refundDesc:{type:"String", desc:"备注"},
                    },
                    desc:"表单"
                }
            ],
            bindBiz:orderBiz.accountInfo
        },
    ],
    
}
