/**
 * 变更审批
 */
import * as applyBiz from "../../biz/member/apply";


export const FirstName = '变更审批';
export const FirstRouter = '/manage/apply';
export const Config = {
    "变更审批管理":[
        {
            apiName:"变更审批列表",
            subUrl:'/applydb/applylist',
            param:[ // name, joinStartTime, joinEndTime, beforeChange, memberLevel, pageNumber
                {key:"name", type:"String", desc:"单位/个人名称", isNull:true},
                {key:"joinStartTime", type:"Number", desc:"入会开始时间", isNull:true},
                {key:"joinEndTime", type:"Number", desc:"入会结束时间", isNull:true},
                {key:"beforeChange", type:"[Number]", desc:"变更前会员等级职务", isNull:true},
                {key:"memberLevel", type:"[Number]", desc:"变更后会员等级职务", isNull:true},
                {key:"memberCategory", type:"Number", desc:"会员类别", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:applyBiz.applyList
        },
        {
            apiName:"变更审批通过",
            subUrl:'/applydb/applyadopt',
            param:[
                {key:"id", type:"String", desc:"用户id"},
            ],
            bindBiz:applyBiz.applyAdopt
        },
        {
            apiName:"批量通过",
            subUrl:'/applydb/applybatchadopt',
            param:[
                {key:"idList", type:"[String]", desc:"批量通过的用户列表"},
            ],
            bindBiz:applyBiz.applyBatchAdopt
        },
        {
            apiName:"驳回",
            subUrl:'/applydb/applyreject',
            param:[
                {key:"id", type:"String", desc:"用户id"},
                {key:"remarks", type:"String", desc:"驳回理由"}
            ],
            bindBiz:applyBiz.applyReject
        },
        {
            apiName:"数据导出",
            subUrl:'/applydb/outputapply',
            param:[
            ],
            bindBiz:applyBiz.outPutApply
        },
        {
            apiName:"理事审批历史",
            subUrl:'/applydb/applyhistorylist', 
            param:[
                {key:"id", type:"String", desc:"用户id"},
            ],
            bindBiz:applyBiz.applyHistoryList
        },
    ]
}
 
 
 
 
 
 
 
 