import { ERRORCODEENUM } from "../config/errorEnum";

/**
 * 中间件 错误返回
 * @param err 
 * @param req 
 * @param res 
 * @param next 
 */
export function httpErrorHandler(err, req, res, next) {
    console.log("in httpErrorHandler");
    console.log(err);
    //todo 自定义错误编码
    if (err) {
        if ( ERRORCODEENUM[err.message] ) {
            res.success({success:false, msg:err.message, code:ERRORCODEENUM[err.message]});
            next();
        }
        else {
            let resultData = {success:false, msg:err.message, code:500};
            if ( resultData.msg == "黑名单用户不允许登录") {
                resultData.msg = "您的会员服务已过期，如需恢复请联系秘书处：010-86208681";
            }
                
            res.success(resultData);
            next();
        }
    }
} 