/**
 * 模型列表
 * tableName 字段 = 数据表名称【必有值】 使用TABLEENUM的枚举值
 * source 字段 = 数据源【必有值】 可选为mongo 或者 mysql  使用枚举值
 * schema字段说明
 *   allowNull    |   是否为空   |   true=可以为空
 *   type         |   类型       |   String, Number, [String], [Number]
 *   primaryKey   |   表示主键   |   true = 是主键
 *   autoIncrement|   自增       |   是否允许自增  true = 允许
 *   unique       |   值唯一     |   表示值是否唯一
 *   default      |   默认值     |   表示默认时间
 *   index        |   索引       |   true = 建立索引
 * 
 * type类型说明
 * Mongo可用 String,[String],Number,[Number],Boolean
 * sql可用   String,Number,Boolean,Date
 * 
 * association字段说明  多表关联  【数组型】【mysql用】
 * 例：A表有主键aId  B表有外键aId  如需要关联 应在 A的模型下加入association配置
 *  {type: "hasMany", check: "外键表名", foreignKey:"关联字段"},
 * 
 * 子文档字段说明    子文档     【数组型】【mongo用】
 * 例：A表下有sub字段，该字段是子文档B，如需要做关联
 * ·先在模型列表中定义B模型 
 * ·然后A模型中的sub字段定义为[B]或B    {name:"String", sub:'[B]'} 
 * 
 * 注意事项：
 * 1.不通数据源的表名不可重复，也就是说即使在mysql和mongo同时存在的情况下，表名都不可以重复
 * 
 * 
 * {
        tableName:TABLEENUM.表名1,//数据库名称
        source:TABLESOURCEENUM.mongo,
        schema:{
            bId:{
                type:'Number',
            },
            name:'String',
            subFile:'table2'
        }
    },
    {
        tableName:TABLEENUM.表名2,//数据库名称
        source:TABLESOURCEENUM.mysql,
        schema:{
            aId:{
                type:'Number',
            },
            sex:'String',
            count:{type:'Number', default:1}
        },
        association:[]
    },
 */

import { Schema } from "mongoose";
import { ACTIVITYSTATE, INVOICESTATUS, MEMBERLEVEL, MEMBERSTATE, REGISTERFLOW, STATE, USERREGISTERSTATE, WEICHARTPAYSTATE } from "../../config/enum";



enum TABLESOURCEENUM {
    mysql = 1,
    mongo = 2
}

enum TABLEENUM {
    学会概括 = 'xueHuiGaiKuo',
    学会领导 = 'xueHuiLingDao',
    学会架构 = 'xueHuiJiaGou',
    图片编辑 = 'tuPianBianJi',
    芳华杯 = 'fangHuaBei',
    党建 = 'dangJian',
    下载专区 = 'xiaZaiZhuanQu',
    会议通知 = 'huiYiTongZhi',
    文章管理 = 'wenZhangGuanLi',
    banner管理 = 'bannerGuanLi',
    视频管理 = 'shiPinGuanLi',
    专题系列 = 'zhuanTiXiLie',
    机构管理 = 'jiGouGuanLi',
    活动通知 = 'huoDongTongZhi',
    项目公告 = 'xiangMuGongGao',
    工作动态 = 'gongZuoDongTai',
    委员名单 = 'weiYuanMingDan',
    用户表 = 'users',
    文字资料 = 'wenZiZiLiao',
    订单表 = 'order',
    单位所获得科研成果表 = "scientificResearch",
    验证码表 = "code",
    审批历史表 = "approvalHistory",
    权限表 = "authority",
    订单审批历史表 = "orderApprovalHistory",
    标签表 = "lable",
    消息通知表 = "massageNotice",
    消息已读状态表 = "massageReads",
    活动通知表 = "activityNotice",
    活动报名表 = "activityEnroll",
    理事变更审批历史表 = "applyHistoryList"
}



const ModelArray = [
    {
        tableName:TABLEENUM.学会概括,
        source:TABLESOURCEENUM.mongo,
        schema:{
            id:{ type:'String', index:true },
            title:{ type:'String', default:'' },//标题
            desc:{ type:'String', default:'' },//简介
            imgList:{ type:'[String]', default:[] },//图片地址
            ut:{ type:'Number'}//最后一次修改时间
        }
    },
    {
        tableName:TABLEENUM.学会领导,
        source:TABLESOURCEENUM.mongo,
        schema:{
            id:{ type:'String', index:true },
            rank:{ type:'Number' },//排序
            name:{ type:'String', default:'' },//名称
            position:{ type:'Number', default:'' },//职位 XUEHUILINGDAOZHIWEI
            imgUrl:{ type:'String', default:''},//大图地址
            miniImgUrl:{ type:'String', default:'' },//小图片地址
            desc:{ type:'String', default:'' },//描述
            ct:{ type:'Number'}//创建 时间
        }
    },
    {
        tableName:TABLEENUM.学会架构,
        source:TABLESOURCEENUM.mongo,
        schema:{
            id:{ type:'String', index:true },
            departmentName:{ type:'String', default:'' },//部门名称
            desc:{ type:'String', default:'' },//部门介绍
            display:{ type:'Number', default:0},//是否显示
            ct:{ type:'Number'}//创建 时间
        }
    },
    {
        tableName:TABLEENUM.图片编辑,
        source:TABLESOURCEENUM.mongo,
        schema:{
            id:{ type:'String', index:true },
            type:'Number',//枚举 IMGEDITFUNENUM
            index:'Number',
            imgUrl:{type:'String', default:''},
            desc:{type:'String', default:''}
        }
    },
    {
        tableName:TABLEENUM.芳华杯,
        source:TABLESOURCEENUM.mongo,
        schema:{
            id:{ type:'String', index:true },
            name:'String',
            works:'String',
            worksType:'Number',//作品类型枚举
            awardTime:'Number',//获奖时间
            desc:{type:'String', default:''}
        }
    },
    {
        tableName:TABLEENUM.党建,//党建类型
        source:TABLESOURCEENUM.mongo,
        schema:{
            id:{ type:'Number', index:true },
            type:'Number',//选项中的二级名称 枚举 PARTYBUILDTYPEENUM
            subType:'Number',//区分学习园地的视频资源和文章资源
            display:'Number',//是否在官网显示
            name:'String'
        }
    },
    {
        tableName:TABLEENUM.文字资料,
        source:TABLESOURCEENUM.mongo,
        schema:{
            id:{ type:'String', index:true },
            title:'String',//展示标题
            rank:'Number',//排序
            coverUrl:'String',//封面地址 1.5新加
            imgUrl:'String',//视频图片地址
            position:'Number',//位置 1.5弃用
            articleTitle:'String',//文章标题 1.5弃用
            articleUrl:'String',//链接 前端生成 1.5弃用
            type:'Number',//分类 参考党建表>学习园地>文字资料  1.5改成枚举  VIDEOANDIMGTYPEENUM
            updateTime:'Number',//更新时间
        }
    },
    {
        tableName:TABLEENUM.文章管理,
        source:TABLESOURCEENUM.mongo,
        schema:{
            id:{ type:'String', index:true },
            title:'String',//文章大标题
            articleType:'[Number]',//文章类型
            imgUrl:'[String]',//图片地址
            articleTime:'Number',//文章时间
            desc:'String',//内容
            display:{type:'Number', default:0},//是否显示 使用是否的枚举
            files:{type:'[String]', default:[]},//附件
            ct:'Number'
        }
    },
    {
        tableName:TABLEENUM.banner管理,
        source:TABLESOURCEENUM.mongo,
        schema:{
            id:{ type:'String', index:true },
            location:'Number',//所属位置枚举 24.3.1改成单选
            position:'Number',//位置
            articleTitle:'String',//文章标题
            imgUrl:'String',//图片地址
            articleUrl:'String',//文章链接
            desc:'String',//副标题
            display:{type:'Number', default:0},//是否显示 使用是否的枚举
            ct:'Number'
        }
    },
    {
        tableName:TABLEENUM.视频管理,
        source:TABLESOURCEENUM.mongo,
        schema:{
            id:{ type:'String', index:true },
            title:'String',//大标题
            videoType:'Number',//分类 
            videoUrl:'String',//视频地址
            videoTime:'Number',//video时间
            desc:'String',//说明
            display:{type:'Number', default:0},//是否显示 使用是否的枚举
            ct:'Number',
            coverUrl:'String',//封面图片
        }
    },
    {
        tableName:TABLEENUM.专题系列,
        source:TABLESOURCEENUM.mongo,
        schema:{
            id:{ type:'String', index:true },
            rank:'Number',//排序 不可被修改
            title:'String',//标题
            position:'Number',//位置
            articleTitle:'String',//文章标题
            articleUrl:'String',//链接 前端生成
            imgUrl:'String',
            ct:'Number'
        }
    },
    {
        tableName:TABLEENUM.机构管理,
        source:TABLESOURCEENUM.mongo,
        schema:{
            id:{ type:'String', index:true },
            name:'String',//机构名称
            desc:'String',//内容
            createTime:'Number',//成立时间
            rank:'Number',
            logoUrl:'String',
            ct:'Number',
        }
    },
    {
        tableName:TABLEENUM.会议通知,
        source:TABLESOURCEENUM.mongo,
        schema:{
            id:{ type:'String', index:true },
            name:'String',//会议名称
            st:'Number',
            addrest:'String',
            members:{type:'[Number]', default:[]},//参会会员id，用中文逗号隔开
            push:'Number',//是否开启推送
            desc:'String',//参会说明
            ct:'Number'
        }
    },
    {
        tableName:TABLEENUM.活动通知,
        source:TABLESOURCEENUM.mongo,
        schema:{
            id:{ type:'String', index:true },
            name:'String',//活动名称
            st:'Number',//开始时间
            addrest:'String',
            members:{type:'[Number]', default:[]},//参会会员id，用中文逗号隔开
            push:'Number',//是否开启推送
            desc:'String',//参会说明
            ct:'Number'
        }
    },
    {
        tableName:TABLEENUM.项目公告,
        source:TABLESOURCEENUM.mongo,
        schema:{
            id:{ type:'String', index:true },
            name:'String',//项目名称
            st:'Number',
            addrest:'String',
            members:{type:'[Number]', default:[]},//参会会员id，用中文逗号隔开
            push:'Number',//是否开启推送
            desc:'String',//项目说明
            ct:'Number'
        }
    },
    {
        tableName:TABLEENUM.工作动态,
        source:TABLESOURCEENUM.mongo,
        schema:{
            id:{type:'String', index:true },
            agencyId:{type:'String', index:true},//机构id
            title:'String',//标题
            activityTime:'Number',//创建时间
            imgUrl:'String',//图片地址
            desc:'String',//内容
            isUse:{type:'Number', default:0},//是否上架0表示不上架1表示上架
            ct:'Number'
        }
    },
    {
        tableName:TABLEENUM.委员名单,
        source:TABLESOURCEENUM.mongo,
        schema:{
            id:{type:'String', index:true },
            agencyId:{type:'String', index:true},//机构id
            name:'String',//姓名
            branchDuties:'[Number]',//分会职务
            unit:'String',//单位
            unitDuties:'String',//单位职务
            ct:'Number',
            ut:'Number',//修改时间
        }
    },
    {
        tableName:TABLEENUM.下载专区,
        source:TABLESOURCEENUM.mongo,
        schema:{
            id:{ type:'String', index:true },
            agencyId:{type:'String', index:true},//机构id
            name:'String',
            type:'Number',
            fileUrl:'String',
            ct:'Number',//创建时间
        }
    },
    {
        tableName:TABLEENUM.用户表,
        source:TABLESOURCEENUM.mongo,
        schema:{
            userId:{ type:'String', index:true },//唯一标识
            askForTime:'Number',//申请时间 注册流程发起时间
            auditTime:'Number',//审核时间 会员审核列表审核时间
            joinTime:'Number',//入会时间 审核通过时间
            memberNum:{type:'String'},//会员编号
            memberType:{type:'Number'},//会员类型 枚举MEMBERTYPE
            lifespanStartTime:{type:'Number'},//会员有效期开始时间 时间戳 每次缴费成功更新
            lifespanEndTime:{type:'Number', index:true},//会员有效期结束时间 时间戳  每次缴费成功更新
            token:{type:'String', default:''},//token
            tokenMs:{type:'Number', default:0},//token过期时间
            lastLoginMs:'Number',//上次登陆时间
            session:'Number',//届次【规则：五年一届半年一次（10次一届）】 数据库保存格式：200801【年月（YYYYMM）】
            paymentStatus:'Number',//支付状态 PAYMENTSTATUS
            isInput:{type:'Boolean', default:false},//是否是导入用户
            inputUserChangePwd:{type:'Boolean', default:false},
            /**管理员字段 */
            adminType:{type:'Number'},//管理员类别 ADMINTYPE
            adminLv:"[Number]",//管理员等级 多选 ADMINLV
            /**状态枚举 */
            registerFlow:{type:'Number', default:REGISTERFLOW.未注册},//会员注册流程 枚举
            isAdmin:{ type:'Number', index:true, default:STATE.否},//是否是管理员
            userRegisterState:{type:'Number', default:USERREGISTERSTATE.待审核},//用户注册状态 枚举USERREGISTERSTATE
            memberState:{type:'Number', default:MEMBERSTATE.异常},//会员状态 枚举 MEMBERSTATE
            certificateType:'Number',//证书类型 枚举CERTIFICATETYPE
            individualMemberType:{type: 'Number'},//个人会员类型 枚举INDIVIDUALMEMBERTYPE
            memberLevel:{type:'Number', default:MEMBERLEVEL.普通会员},//会员等级、职务 枚举 MEMBERLEVEL 【会员管理用】
            isFirstPay:{type:'Boolean', default:false},//是否完成首次支付
            /**宽限期状态 */
            isGracePeriod:{type:'Number', default:0},//是否宽限期 0：否， 1：是
            gracePeriodEndTime:'Number',//宽限期到期时间 时间戳
            /**第一步流程表单 */
            loginId:{ type:'String', index:true},//用户名 可用作登陆
            pwd:{ type:'String'},//密码
            phone:{type:'String', index:true},//联系电话（登陆手机号）可用作登陆
            mail:{type:'String', index:true},//邮箱
            /**第二步流程表单（个人）【基础信息】 */
            name:{type:'String', index:true},//真实姓名
            sex:'Number',//性别 枚举
            documentId:{type:'String', index:true},//证件号码 身份证
            documentType:'Number',//证件类型 枚举DOCUMENTTYPE
            birth:'Number',//出生年月 时间戳
            nation:'Number',//民族 枚举
            sheng:'String',//省 共用
            shi:'String',//市 共用
            qu:'String',//区 共用
            addres:'String',//通信地址 共用
            education:'Number',//学历
            photoUrl:'String',//证件照图片地址 蓝底证件照
            /**第二步流程表单（个人）【专业信息】 */
            workUnit:'String',//工作单位  弃用
            duties:'String',//职务【注册用】
            workTitle:'String',//职称
            studyResume:'String',//学习简历
            workResume:'String',//工作简历
            profAchievement:'String',//专业成果 教研成果
            otherEMP:'String',//其他任职情况
            otherPROF:'String',//其他专业情况
            profCategory:{type:'[Number]', default:[]},//专业类别 枚举PROFCATEGORY
            /**第二步流程表单（个人）【其他附件】 */
            cardUrlJust:'String',//身份证正面图片地址
            cardUrlBack:'String',//身份证反面图片地址
            academicCERTUrl:'String',//学历证明图片地址
            professionalCERTUrl:'String',//工作证明图片地址
            auxiliaryMaterial:{type:'[String]', default:[]},//其他辅助材料
            /**第二步流程表单（单位）【基础信息】 */
            unitName:{type:'String', index:true},//单位名称
            uscc:{type:'String', index:true},//统一信用代码
            legalPerson:'String',//法人代表
            legalPersonPhone:'String',//法人代表联系电话
            legalPersonMail:'String',//法人邮箱
            unitMail:'String',//单位电子邮箱
            contactPerson:'String',//日常联系人
            contactPersonDuties:'String',//日常联系人职务
            contactPersonPhone:'String',//日常联系人手机号码
            uusinessLicenseUrl:'String',//营业执照 图片地址
            /**第二步流程表单（单位）【单位信息】 */
            unitMemberType:{type: 'Number'},//单位会员类型 枚举UNITMEMBERTYPE
            yuanXiaoBanXueLeiXing:'Number',//院校办学类型 枚举BANXUELEIXING
            yuanXiaoZhuGuanBuMen:'String',//院校主管部门
            yuanXiaoFuZeRen:'String',//院校主要负责人
            yuanXiaoFuZeRenZhiWu:'String',//院校主要负责人职务
            yuanXiaoFuZeRenDianHua:'String',//院校主要负责人电话
            yuanXiaoBanGongFuZeRen:'String',//院校办公负责人
            yuanXiaoBanGongFuZeRenDianHua:'String',//院校办公负责人电话
            ZhuYaoFuZeRenYouXiang:'String',//主要负责人邮箱
            yuanXiaoKeYanFuZeRen:'String',//院校科研负责人
            yuanXiaoKeYanFuZeRenDianHua:'String',//院校科研负责人电话
            jiaoXueFuZeRenXinMing:'String',//教学负责人姓名
            yuanXiaoXueShengZongRenShu:'Number',//院校学生总人数
            yuanXiaoJiaoZhiGongZongRenShu:'Number',//教职工总人数
            jiaoXueFuZeRenDianHua:'String',//教学负责人电话
            kaishezhuanYe:'String',//开设专业 2024.04.22修改
            danWeiJianJie:'String',//单位简介 2024.04.22修改
            /**第三步流程表单（单位）【申请表上传】 */
            applicationForm:'String',//入会申请表
            /**标签管理 */
            lableId:{type:'[String]', default:[]},//标签id 外键
            /**黑名单 */
            isBlackUser:{type:'Number', default:STATE.否},//是否黑名单用户 0：否， 1：是  STATE
            /**注册第二步保存未提交 */
            saveUnsubmitted:{type:'Number', default:STATE.否},//是否提交注册完成 0：否， 1：是  STATE
            firstStep:'Number',//第一步完成时间
            /**变更理事 */
            applyMemberLevel:'Number',//申请变更的职位
            beforeChange:'Number',//会员等级、职务 枚举 MEMBERLEVEL 【变更申请前的职位】
            applyStr:'String',//变更理事申请理由
            changeApplyType:'Number',//变更审批状态
            applyApplicationTime:'Number',//变更理事申请时间
            applyReviewTime:'Number',//变更理事审核时间
            rejectRemarks:'String',//变更理事驳回理由
            applyId:{ type:'String', index:true },
        }
    },
    {
        tableName:TABLEENUM.单位所获得科研成果表,
        source:TABLESOURCEENUM.mongo,
        schema:{
            id:{ type:'String', index:true },
            userId:{type:'String', index:true},//用户id
            startTime:'Number',//开始时间
            endTime:'Number',//结束时间
            describe:'String',//描述
        }
    },
    {
        tableName:TABLEENUM.订单表,
        source:TABLESOURCEENUM.mongo,
        schema:{
            id:{ type:'String', index:true },
            orderYear:'String',//订单年度
            unitName:'String',//单位名称
            orderCycleStart:'Number',//订单周期开始时间
            orderCycleEnd:'Number',//订单周期结束时间
            money:'Number',//金额
            userId:{type:'String', index:true},//会员id
            loginId:{type:'String', index:true},//登陆名
            phone:"String",//登陆手机号
            paymentNum:{type:'String', default:""},//支付单号（与订单号不一样） 线下付款时录入  如果微信付款使用 微信支付的订单号
            offlinePaymentUrl:{type:'String', default:""},//转账图片
            memberCategory:'Number',//会员类别 枚举  MEMBERTYPE
            weChartPR:{type:'String', default:""},//微信订单号 微信支付用
            weChartState:{type:'Number', default:WEICHARTPAYSTATE.未提交},//微信支付状态  WEICHARTPAYSTATE
            weChartCreatePayMs:{type:'Number'},//微信创建订单时间
            weChartPayUrl:'String',//微信创建订单时支付链接
            // membershipFeesType:'Number',//会费类别 枚举
            invoiceAdd:'String',//发票图片地址
            isFirst:{type:'Boolean', default:true},//首次订单 
            state:'Number',//状态 是否支付 枚举 ORDERSTATE
            paymentMethod:'Number',//付款方式 枚举  PAYMENTTYPE
            firstPayExamine:{type:'Boolean', default:false},//首次订单的审批开关【待支付页审批开关】  
            confirmReceipt:{type:'Number', default:0},//收款确认【财务核对页收款确认】  RECEIPTCONFIRMATION
            invoiceStatus:{type:'Number', default:INVOICESTATUS.不具备开票条件, index:true},//发票状态 枚举 INVOICESTATUS 【待开发票页上传发票之后更新状态】
            advanceInvoice:{type:'Boolean', default:false},//是否提交开票 【个人列表页提交开发票按钮】
            newUnitName:'String',//单位名称，新发票抬头【变更发票抬头使用】
            newUscc:'String',//新统一信用代码【变更发票信用代码使用】
            ct:'Number',//订单创建时间
            payTime:'Number',//支付时间
            //2.0新加
            invoiceMail:'String',//发票邮箱
            desc:'String',//描述
            isReceive:{type:"Number", default:0},//退回理由中的是否受到款项【财务核对页收款退回】 ISRECEIVE
            returnsReasons:'String',//退回理由中的退回理由描述【财务核对页收款退回】
            //退款信息
            refundName:"String",
            refundBankCarId:"String",
            refundBankName:"String",
            refundDesc:"String",
            isReplenishReturnInfo:{type:'Boolean', default:false},//是否补充退款信息

            refundSuccessful:{type:"Boolean", default:false},//退款确认
            refundImgUrl:"String"
            
        }
    },
    {
        tableName:TABLEENUM.验证码表,
        source:TABLESOURCEENUM.mongo,
        schema:{
            phone:{type:'String', index:true},//电话号码
            codeNum:'String',
            sendMs:{type:'Number', index:true},//下发时间 时间戳
            type:'Number',//验证码类型 枚举 CODETYPE
            isUse:{type:'Boolean', index:true, default:false},//是否已使用 默认false
        }
    },
    {
        tableName:TABLEENUM.审批历史表,//会员
        source:TABLESOURCEENUM.mongo,
        schema:{
            userId:{type:'String', index:true},//用户id 外键
            operationTime:{ type:'Number' },//操作时间
            operationBehavior:{ type:'Number'},//操作行为 枚举
            remarks:{ type:'String' },//备注
        }
    },
    {
        tableName:TABLEENUM.标签表,
        source:TABLESOURCEENUM.mongo,
        schema:{
            lableId:{type:'String', index:true},//标签id
            lableName:'String',//标签名称
            createTime:'Number',//创建时间
        }
    },
    {
        tableName:TABLEENUM.消息通知表,
        source:TABLESOURCEENUM.mongo,
        schema:{
            msgId:{type:'String', index:true},//消息id
            msgTitle:'String',//消息标题
            createTime:'Number',//创建时间
            effectiveTime:'Number',//有效时间
            msgContent:'String',//消息内容
            lableId:{type:'[String]', default:[]},//消息对象 标签id 外键
            isPop:{type:'Number', default:STATE.否}//是否弹窗
        }
    },
    {
        tableName:TABLEENUM.消息已读状态表,
        source:TABLESOURCEENUM.mongo,
        schema:{
            readId:{type:'String', index:true},//消息已读id
            msgId:'String',//消息id
            userId:'String',//用户id
            readTime:'Number',//阅读时间
            isRead:{type:'Number', default:STATE.否}//是否已读
        }
    },
    {
        tableName:TABLEENUM.活动通知表,
        source:TABLESOURCEENUM.mongo,
        schema:{
            activityId:{type:'String', index:true},//活动id
            activityType:'Number',//活动类型 ACTIVITYTYPE
            activityState:{type:'Number', default:ACTIVITYSTATE.已开始},//活动状态 ACTIVITYSTATE
            activityName:'String',//活动名称
            enrollForm:'String',//报名表模板地址
            activityAdd:'String',//活动地点
            activityStartTime:'Number',//活动开始时间
            activityEndTime:'Number',//活动结束时间
            lableId:'[String]',//活动对象 标签id 外键
            enrollStartTime:'Number',//报名开始时间
            enrollEndTime:'Number',//报名结束时间
            activityContent:'String',//详细内容
            createTime:'Number',//创建时间
            isTopUp:{type:'Number', default:STATE.否},//是否置顶
        }
    },
    {
        tableName:TABLEENUM.活动报名表,
        source:TABLESOURCEENUM.mongo,
        schema:{
            enrollId:{type:'String', index:true},//活动报名id
            activityId:{type:'String'},//活动报名id
            userId:{type:'String'},//活动报名用户id
            enrollUrl:{type:'String'}//报名表位置
        }
    },
    {
        tableName:TABLEENUM.订单审批历史表,//会员
        source:TABLESOURCEENUM.mongo,
        schema:{
            orderId:{type:'String', index:true},//订单表 外键
            operationTime:{ type:'Number' },//操作时间
            operationBehavior:{ type:'Number'},//操作行为 枚举  ORDEREXAMINE
            isReceiveMoney:{type:'Boolean', default:false},//是否收到款项
            remarks:{ type:'String' },//备注
            refundImgUrl:"String"//退款确认发票地址
        }
    },
    {
        tableName:TABLEENUM.理事变更审批历史表,
        source:TABLESOURCEENUM.mongo,
        schema:{
            applyId:{type:'String', index:true},
            userId:{type:'String', index:true},//用户id 外键
            applyMemberLevel:'Number',//申请变更的职位
            beforeChange:'Number',//会员等级、职务 枚举 MEMBERLEVEL 【变更申请前的职位】
            applyStr:'String',//变更理事申请理由
            changeApplyType:'Number',//变更审批状态
            applyApplicationTime:'Number',//变更理事申请时间
            applyReviewTime:'Number',//变更理事审核时间
            rejectRemarks:'String',//变更理事驳回理由
        }
    },
];



export {ModelArray, TABLEENUM, TABLESOURCEENUM};


