import { MEMBERTYPE } from "../config/enum";
import { TABLEENUM } from "../data/models/model";
import { find } from "../data/select";

const path = require('path');
const fs = require('fs');
const xlsx = require('node-xlsx');

export async function t() {
    let {sheetMap} = getExcel(path.join(__dirname.substring(0,__dirname.indexOf("out")), "res", '个人会员删除.xlsx' ));
    let dataList = sheetMap["简化版"];
    let allUserList = await find(TABLEENUM.用户表, {isAdmin:0, isInput:1});
    let allMap = {};
    let allUnitMap = {};
    let phoneList = [];
    allUserList.forEach(item => {
        if (item.memberType == MEMBERTYPE.个人会员) {
            if (!allMap[item.documentId]) allMap[item.documentId] = 0;
            allMap[item.documentId] += 1;
            if (!item.documentId) {
                phoneList.push([item.name, item.phone]); 
            }
        } else {
            if (!allUnitMap[item.unitName]) allUnitMap[item.unitName] = 0;
            allUnitMap[item.unitName] += 1;
        }
    });
    dataList.forEach((subList, index) => {
        if (index <= 1) return;
        let carId = subList[2];
        if (allMap[carId]) console.log("个人会员匹配成功", carId);
    });
    console.log("====");

    let unitExcelData = getExcel(path.join(__dirname.substring(0,__dirname.indexOf("out")), "res", '机构删除名单.xlsx' ));
    let unitDataList = unitExcelData.sheetMap["Sheet2"];
    unitDataList.forEach((subList, index) => {
        let carId = subList[3];
        if (allUnitMap[carId]) console.log("个人会员匹配成功", carId)
    });
    console.log("end");
}

/**
 * 获取当个excel文件数据
 * @param filePath 
 * @returns 
 */
function getExcel(filePath) {
    const workSheetsFromFile = xlsx.parse(filePath);
    let sheetMap = {};
    let sheetList = [];

    for (let i = 0; i < workSheetsFromFile.length; i++) {
        let sheetInfo = workSheetsFromFile[i];
        sheetMap[sheetInfo.name] = sheetInfo.data;
        sheetList.push(sheetInfo);
    }

    return {sheetMap, sheetList}  
}



