/**
 * 学术研究
 */

import { IMGEDITFUNENUM } from "../../../config/enum";
import { ERRORENUM } from "../../../config/errorEnum";
import { addManyData } from "../../../data/add";
import { TABLEENUM } from "../../../data/models/model";
import { find, findOnce } from "../../../data/select";
import { updateOneData } from "../../../data/update";
import { generateSystemId, successResult } from "../../../tools/system";
import { BizError } from "../../../util/bizError";


/**
 * 列表
 * @param secureArgs 
 * @returns 
 */
export async function list(secureArgs:any) {
    let {userId} = secureArgs;
    let dbList = await find(TABLEENUM.图片编辑, {type:IMGEDITFUNENUM.学术研究});
    if (!dbList.length) {
        /**不存在数据时需要给两个默认的数据 */
        dbList = [
            { id:generateSystemId(TABLEENUM.图片编辑, userId), type:IMGEDITFUNENUM.学术研究, index:1, imgUrl:'', desc:'' }, 
            { id:generateSystemId(TABLEENUM.图片编辑, userId), type:IMGEDITFUNENUM.学术研究, index:2, imgUrl:'', desc:'' },
        ];
        await addManyData(TABLEENUM.图片编辑, dbList);
    }
    let dataList = [];
    dbList.forEach(info => {
        let {id, index, imgUrl, desc} = info;
        dataList.push({id, imgUrl, desc, name:`图${index}`, index});
    });

    return {dataList};
}


/**
 * 修改
 * @param userId 
 * @param id 
 * @param updateParam 
 * @returns 
 */
export async function update(secureArgs:any) {
    let {userId, id, imgUrl, desc} = secureArgs;
    let oldInfo = await findOnce(TABLEENUM.图片编辑, {id});
    if (!oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);

    await updateOneData(TABLEENUM.图片编辑, {id}, {desc, imgUrl});
    return successResult();
}


/**
 * 逻辑删除
 * @param secureArgs 
 * @returns 
 */
export async function del(secureArgs:any) {
    let {userId, id} = secureArgs;
    let oldInfo = await findOnce(TABLEENUM.图片编辑, {id});
    if (!oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);

    await updateOneData(TABLEENUM.图片编辑, {id}, {desc:"", imgUrl:""});
    return successResult();
}

/**
 * 详情
 * @param secureArgs 
 * @returns 
 */
export async function info(secureArgs:any) {
    let {userId, id} = secureArgs;
    let oldInfo = await findOnce(TABLEENUM.图片编辑, {id});
    if (!oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);
    let {imgUrl, desc} = oldInfo;

    return {dataInfo:{imgUrl, desc}};
}

/**
 * 预览
 */
export async function preview({userId}) {
    let dbList = await find(TABLEENUM.图片编辑, {type:IMGEDITFUNENUM.学术研究});
    dbList.sort((a, b) => {return a.index - b.index});
    let imgList = [];
    dbList.forEach(info => {
        let {id, index, imgUrl, desc} = info;
        imgList.push({id, imgUrl, index, desc});
    });
    let contentList = [
        {
            year:2021,
            month:12,
            day:31,
            title:'学术研究标题',
            author:'张三'
        },
        {
            year:2021,
            month:12,
            day:31,
            title:'学术研究标题',
            author:'张三'
        },
        {
            year:2021,
            month:12,
            day:31,
            title:'学术研究标题',
            author:'张三'
        },
        {
            year:2021,
            month:12,
            day:31,
            title:'学术研究标题',
            author:'张三'
        },
        {
            year:2021,
            month:12,
            day:31,
            title:'学术研究标题',
            author:'张三'
        }
    ];
    return {imgList, contentList};
}
