/**
 * 权限管理
 */

import { ADMINLV, ADMINTYPE, MEMBERSTATE, STATE } from "../../config/enum";
import { ERRORENUM } from "../../config/errorEnum";
import { TABLEENUM } from "../../data/models/model";
import { findOnce, findToPage } from "../../data/select";
import { BizError } from "../../util/bizError";
import { changeEnumValue, eccEnumValue } from "../../util/verificationEnum";
import * as sysTools from "../../tools/system";
import { addOneData } from "../../data/add";

/**
 * 管理员列表
 * @param param0 
 * @returns 
 */
export async function adminList({pageNumber}) {
    let fileList = ["userId", "memberState", "loginId", "adminLv", "adminType"];
    let dbList = await findToPage(TABLEENUM.用户表, {isAdmin:STATE.是}, fileList, pageNumber);

    let dataList = [];
    dbList.forEach(info => {
        let {userId, memberState, loginId, adminLv, adminType} = info;
        dataList.push({
            userId,
            memberState:changeEnumValue(MEMBERSTATE, memberState),
            loginId,
            adminType,
            adminLv
        });
    });

    return {dataList};
}

/**
 * 添加管理员 success
 */
export async function addAdmin({userId, form}) {
    let {loginId, pwd, confirmation, adminType, adminLv} = form;

    /**校验参数 */
    eccEnumValue("添加管理员", "管理员类别", ADMINTYPE, adminType);
    eccEnumValue("添加管理员", "管理员等级", ADMINLV, adminLv);
    /**校验密码 */
    if (pwd.search(/^[A-Za-z0-9]{6,18}$/) < 0) throw new BizError(ERRORENUM.密码只能由6至18位字符和数字组成);
    if (pwd != confirmation)  throw new BizError(ERRORENUM.两次密码不一致);

    let addInfo = {
        userId:sysTools.generateUserId(),//系统生成唯一id
        loginId,
        pwd,
        adminType,
        adminLv,
        isAdmin:STATE.是
    };

    await addOneData(TABLEENUM.用户表, addInfo);

    return sysTools.successResult();
}


export async function changeAdminPwd({userId, form}) {
    let {pwd, confirmation} = form;

    let userInfo = await findOnce(TABLEENUM.用户表, {userId:form.userId});

    /**校验密码 */
    if (pwd.search(/^[A-Za-z0-9]{6,18}$/) < 0) throw new BizError(ERRORENUM.密码只能由6至18位字符和数字组成);
    if (pwd != confirmation)  throw new BizError(ERRORENUM.两次密码不一致);

    





}