/**
 * 会费管理逻辑
 */

import { MEMBERSTATE, MEMBERTYPE, PAYMENTSTATUS } from "../../config/enum";
import { TABLEENUM } from "../../data/models/model";
import { findCount, findToPage } from "../../data/select";
import { extractData } from "../../util/piecemeal";
import { changeEnumValue } from "../../util/verificationEnum";



/**
 * 已缴费列表
 */
export async function getPaid({unitName, joinTime, memberType, pageNumber}) {
    let now = new Date().valueOf();
    /**到期时间距离今天大于90天 */
    let selectParam:any = {"$expr":{
        "$gt":[{
            "$subtract":["$lifespanEndTime", now]
        }, 90]
    }};

    if (unitName) selectParam.unitName = unitName;
    if (joinTime) selectParam.joinTime = joinTime;
    if (memberType) selectParam.memberType = memberType;

    let selectConf = ["userId", "memberState", "unitName", "loginId", "phone", "joinTime", "memberType"];
    let dbList = await findToPage(TABLEENUM.用户表, selectParam, [], pageNumber, 10);
    let dataCount = await findCount(TABLEENUM.用户表, selectParam);

    let dataList = [];
    dbList.forEach(info => {
        let item:any = extractData(info, selectConf);
        item.lifespanTime = item.lifespanStartTime + "至" + item.lifespanEndTime;
        item.nextLifespanTime = "";
        
        if (item.lifespanEndTime - now > 90) item.nextLifespanTime = "大于90天";

        item.memberState = changeEnumValue(MEMBERSTATE, item.memberState);
        item.memberType = changeEnumValue(MEMBERTYPE, item.memberType);
        dataList.push(item);
    });

    return {dataList, dataCount};
}


/**
 * 续费期
 */
export async function getRenewalPeriod() {
    let now = new Date().valueOf();
    /**到期时间距离今天等于90天至1天 */
    let selectParam:any = {"$expr":{
        "$and":[
            {"$lte":[{ "$subtract":["$lifespanEndTime", now] }, 90]},
            {"$gt":[{ "$subtract":["$lifespanEndTime", now] }, 1]},
        ]}
    };



}

/**
 * 欠费
 */
export async function getArrearsFees() {
    
}


/**
 * 宽限期
 */
export async function getGracePeriod() {
    
}