import { ARTICLEPOSITION, DONGTAIZIXUNSUBTYPE, PARTYBUILDSUBTYPEENUM, PARTYBUILDTYPEENUM } from "../config/enum";
import { TABLEENUM } from "../data/models/model";
import { find } from "../data/select";

 
export function setEnumInterface({defaultParam}) {
    let dataList = [];
    for (let key in defaultParam) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            let value = defaultParam[key];
            if(/_dou/.test(keyStr)) keyStr = keyStr.replace(/_dou/, "，");
            if(/_zyh/.test(keyStr)) keyStr = keyStr.replace(/_zyh/, "“");
            if(/_yyh/.test(keyStr)) keyStr = keyStr.replace(/_yyh/, "”");
            if(/_dun/.test(keyStr)) keyStr = keyStr.replace(/_dun/, "、");
            if(/_ju/.test(keyStr)) keyStr = keyStr.replace(/_ju/, "。");
            if(/_hgh/.test(keyStr)) keyStr = keyStr.replace(/_hgh/, "-");
            if(/_kbh/.test(keyStr)) keyStr = keyStr.replace(/_kbh/, "");
            dataList.push({key:keyStr, value});
        }
    }
    return {dataList};
}


export function zhengCeZiXunLeiXing() {
    let conf = {};
    conf[DONGTAIZIXUNSUBTYPE.政策动向] = "Policy Tendence";
    conf[DONGTAIZIXUNSUBTYPE.学会动态] = "Assoclation dynamics";
    conf[DONGTAIZIXUNSUBTYPE.行业风采] = "Industry style";
    let dataList = [];
    for (let key in DONGTAIZIXUNSUBTYPE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            let value = DONGTAIZIXUNSUBTYPE[key];
            dataList.push({key:keyStr, value, keyEng:conf[value]});
        }
    }
    return {dataList}
}


export async function filePosition() {
    let dataList = [];
    for (let key in ARTICLEPOSITION) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            let value = ARTICLEPOSITION[key];
            dataList.push({key:keyStr, value});
        }
    }
    let wenZiDBList = await find(TABLEENUM.党建, {type:PARTYBUILDTYPEENUM.学习园地, subType:PARTYBUILDSUBTYPEENUM.文字资料});
    wenZiDBList.forEach(info => {
        let {id, name} = info;
        dataList.push({key:name, value:id});
    });

    return { dataList};
}