/**
 * 会员管理 【权限管理】
 */

import { INDIVIDUALMEMBERTYPE, MEMBERLEVEL, MEMBERSTATE, MEMBERTYPE, MEMBERTYPEECCENUM, UNITMEMBERTYPE } from "../../config/enum";
import { ERRORENUM } from "../../config/errorEnum";
import { TABLEENUM } from "../../data/models/model";
import { findCount, findOnce, findToPage } from "../../data/select";
import { updateOneData } from "../../data/update";
import { successResult } from "../../tools/system";
import { BizError } from "../../util/bizError";
import { extractData } from "../../util/piecemeal";
import { changeEnumValue, eccEnumValue } from "../../util/verificationEnum";



/**
 * 会员权限列表 success
 * @param unitName 单位名称
 * @param memberLevel 会员等级、职务 MEMBERLEVEL
 * @param memberCategory 会员类别、会员级别  UNITMEMBERTYPE、INDIVIDUALMEMBERTYPE
 * @param pageNumber 当前页
 */
 export async function getAuthority({unitName, memberLevel, memberCategory, pageNumber}) {    
    /**查询条件 */
    let selectParam:any = {};
    if (unitName) selectParam.unitName = unitName;
    if (memberLevel) selectParam.memberLevel = memberLevel;
    if (memberCategory) {
        if ( memberCategory >= 9) selectParam.unitMemberType = memberCategory;
        else selectParam.individualMemberType = memberCategory;
    }

    const SelectFiles = ["userId", "memberState", "unitName", "name", "memberLevel", "memberType", "individualMemberType", "unitMemberType"];
    let dbList = await findToPage(TABLEENUM.用户表, selectParam, SelectFiles, pageNumber);
    let dataCount = await findCount(TABLEENUM.用户表, selectParam);

    const ResultFiles = ["userId", "memberState", "memberLevel", "memberType"];
    let dataList = [];
    dbList.forEach(info => {
        let item:any = extractData(info, ResultFiles);
        if (info.memberType == MEMBERTYPE.个人会员) {
            item.unitName = info.name;
            item.memberCategory = changeEnumValue(INDIVIDUALMEMBERTYPE, item.individualMemberType);//会员类别/级别
        }
        else{
            item.unitName = info.unitName;
            item.memberCategory = changeEnumValue(UNITMEMBERTYPE, item.unitMemberType);//会员类别/级别
        }
        item.memberState = changeEnumValue(MEMBERSTATE, item.memberState);
        item.memberLevel = changeEnumValue(MEMBERLEVEL, item.memberLevel);//会员等级、职务

        dataList.push(item);
    });

    return {dataList, dataCount};
}


/**
 * 变更权限  success
 * @param param0 
 */
export async function updateAuthority({form, userId}) {
    let {memberLevel, memberCategory} = form;
    let userInfo = await findOnce(TABLEENUM.用户表, {userId});
    if (!userInfo || !userInfo.userId) throw new BizError(ERRORENUM.目标数据不存在);

    let updateInfo:any = {};
    eccEnumValue("变更权限", "职务、级别", MEMBERLEVEL, memberLevel);
    updateInfo.memberLevel = memberLevel;
    if (userInfo.memberType == MEMBERTYPE.个人会员) {
        eccEnumValue("变更权限", "单位、个人会员类别、级别", INDIVIDUALMEMBERTYPE, memberCategory);
        updateInfo.individualMemberType = memberCategory;
    } else {
        eccEnumValue("变更权限", "单位、个人会员类别、级别", UNITMEMBERTYPE, memberCategory);
        updateInfo.unitMemberType = memberCategory;
    }

    await updateOneData(TABLEENUM.用户表, {userId}, updateInfo);

    return successResult();
}


/**
 * 冻结 success
 * @param param0 
 */
export async function freeze({userId}) {
    let userInfo = await findOnce(TABLEENUM.用户表, {userId});
    if (!userInfo || !userInfo.userId) throw new BizError(ERRORENUM.目标数据不存在);
    await updateOneData(TABLEENUM.用户表, {userId}, {memberState:MEMBERSTATE.冻结});

    return successResult();
}










