/**
 * 学会架构
 */


import { ERRORENUM } from "../../../config/errorEnum";
import { addManyData, addOneData } from "../../../data/add";
import { deleteOneData } from "../../../data/delete";
import { TABLEENUM } from "../../../data/models/model";
import { find, findOnce } from "../../../data/select";
import { updateOneData } from "../../../data/update";
import { generateSystemId, successResult } from "../../../tools/system";
import { BizError } from "../../../util/bizError";
import { extractData } from "../../../util/piecemeal";



/**
 * 修改
 * @param userId 
 * @param id 
 * @param updateParam 
 * @returns 
 */
export async function update( {userId, id, form}) {
    let oldInfo = await findOnce(TABLEENUM.学会架构, {id});
    if (!oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);
   
    await updateOneData(TABLEENUM.学会架构, {id}, form);
    return successResult();
}


/**
 * 修改显示状态
 * @param param0 
 * @returns 
 */
export async function updateDisplay({userId, id}) {
    let oldInfo = await findOnce(TABLEENUM.学会架构, {id});
    if (!oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);

    let changeDisplay = oldInfo.display ? 0 : 1;
    await updateOneData(TABLEENUM.学会架构, {id}, {display:changeDisplay});
    return successResult();
}


/**
 * 删除
 * @param param0 
 * @returns 
 */
export async function del( {userId, id}) {
    let dataInfo = await findOnce(TABLEENUM.学会架构, {id});
    if (!dataInfo.id) throw new BizError(ERRORENUM.目标数据不存在);
    await deleteOneData(TABLEENUM.学会架构, {id});
    return successResult();
}


/**
 * 列表
 * @returns 
 */
export async function list() {
    let dbList = await find(TABLEENUM.学会架构, {});
    let ct = new Date().valueOf();
    if (!dbList || !dbList.length) {
        dbList = [];
        for (let i = 1; i <= 6; i++) {
            dbList.push({
                id:`${i}`,
                departmentName:'',
                desc:'',
                display:1,
                ct
            });
        };
        await addManyData(TABLEENUM.学会架构, dbList);
    }
    let dataList = [];
    dbList.forEach(info => {
        let item:any = extractData(info, ["id", "departmentName", "desc", "display"]);
        item.display = item.display == 1;
        dataList.push(item);
    });

    return {dataList};
}


/**
 * 回显
 * @param id 
 */
export async function info({id}) {
    let oldInfo = await findOnce(TABLEENUM.学会架构, {id});
    let dataInfo = extractData(oldInfo, [ "departmentName", "desc"]);

    return { dataInfo };
}
