/**
 * 文字资料 1.5改成【图片视频】，可以上传图片和视频
 */

import { ARTICLEPOSITION, VIDEOANDIMGTYPEENUM } from "../../../config/enum";
import { ERRORENUM } from "../../../config/errorEnum";
import { addManyData } from "../../../data/add";
import { TABLEENUM } from "../../../data/models/model";
import { find, findOnce } from "../../../data/select";
import { updateOneData } from "../../../data/update";
import { generateSystemId, successResult } from "../../../tools/system";
import { BizError } from "../../../util/bizError";
import { extractData } from "../../../util/piecemeal";
import { changeEnumValue, eccEnumValue } from "../../../util/verificationEnum";
import { eccReqParamater } from "../../../util/verificationParam";


/**
 * 列表
 * @param param0 
 * @returns 
 */
export async function list({userId, type}) {
    if (type) eccEnumValue("图片视频列表", "类型", VIDEOANDIMGTYPEENUM, type);
    let dbList = await find(TABLEENUM.文字资料, {});

    let dataList = [];
    if ( !dbList || !dbList.length) {
        let addList = [];
        for (let i = 1; i <= 8; i++) {
            let id = generateSystemId(TABLEENUM.文字资料, userId);
            addList.push({id, rank:i, title:'', type:1, imgUrl:"", coverUrl:"" });
            dataList.push({id, rank:i, title:'', type:1, imgUrl:"", coverUrl:"" });
        }
        await addManyData(TABLEENUM.文字资料, addList);
    }
    dataList.sort((a:any, b:any) => {return a.rank - b.rank });
    for (let i =0; i < dbList.length; i++) {
        let info= dbList[i];
        
        let item:any = extractData(info, [ "id", "title", "rank", "type", "imgUrl", "coverUrl" ]);
        if (type && item.type == type) dataList.push(item);
    }

    return {dataList};
}


/**
 * 预览
 */
export async function preview({userId}) {
    let dbList = await find(TABLEENUM.文字资料, {});

    let dataList = [];
    if (!dbList || !dbList.length) {
        let addList = [];
        for (let i = 1; i <= 8; i++) {
            let id = generateSystemId(TABLEENUM.文字资料, userId);
            addList.push({id, rank:i, title:'', type:1, imgUrl:"", coverUrl:"" });
            dataList.push({id, rank:i, title:'', type:1, imgUrl:"", coverUrl:"" });
        }
        await addManyData(TABLEENUM.文字资料, addList);
    }
    dataList.sort((a:any, b:any) => {return a.rank - b.rank });
    dbList.forEach(info => {
        let item = extractData(info, ["id", "title", "rank", "type", "imgUrl", "coverUrl"]);
        dataList.push(item);
    });

    return {dataList};
}


/**
 * 修改
 * @param userId 
 * @param id 
 * @param updateParam 
 * @returns 
 */
export async function update({userId, id, title, imgUrl,type, updateTime, coverUrl}) {
    eccEnumValue("图片视频修改", "类型", VIDEOANDIMGTYPEENUM, type);
    if (type == VIDEOANDIMGTYPEENUM.图片) {
        coverUrl = "";
    } else {
        if (!coverUrl) throw new BizError(ERRORENUM.参数错误, "修改图片视频时 缺少视频封面");
        eccReqParamater("修改图片视频", {"coverUrl":"String"}, {coverUrl} );
    }
    let oldInfo = await findOnce(TABLEENUM.文字资料, {id});
    if (!oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);
    
    await updateOneData(TABLEENUM.文字资料, {id}, {title, imgUrl, type, coverUrl, updateTime});
    return successResult();
}


export async function del({userId, id}) {
    let dataInfo = await findOnce(TABLEENUM.文字资料, {id});
    if (!dataInfo || !dataInfo.id) throw new BizError(ERRORENUM.目标数据不存在);

    await updateOneData(TABLEENUM.文字资料, {id}, {title:"", imgUrl:"", type:1, coverUrl:"", updateTime:new Date().valueOf()});
    return successResult();
}


/**
 * 回显
 * @param id 
 */
export async function info({id}) {
    let oldInfo = await findOnce(TABLEENUM.文字资料, {id});
    if (!oldInfo || !oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);
    let dataInfo = extractData(oldInfo, ["id", "title", "rank", "type", "imgUrl", "coverUrl"]);
    return { dataInfo };
}