import * as userBiz from "../../biz/member/user";
import * as memberBiz from "../../biz/member/member";
import * as examineBiz from "../../biz/member/examine";
import * as memberFeesBiz from "../../biz/member/memberFees";
import * as authorityBiz from "../../biz/member/authority";
import * as registerBiz from "../../biz/register";
import * as homePageBiz from "../../biz/member/homePage";
import * as rightsMgmtBiz from "../../biz/member/rightsMgmt";
import * as mailBiz from "../../biz/mail";
import * as ossBiz from "../../biz/oss";
import { ADMINLV } from "../../config/enum";

export const FirstName = '会员管理路由';
export const FirstRouter = '/manage/member';
export const Config = {
    "用户注册":[
        {
            apiName:"是否开放注册",
            notMiddleware:true,
            subUrl:'/memberdb/memberregister/isopen',
            param:[],
            bindBiz:registerBiz.findRegisterStart
        },
        {
            apiName:"个人入会流程1",
            notMiddleware:true,
            subUrl:'/memberdb/memberregister1',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        loginId:{type:'String', desc:'用户名'},
                        mail:{type:'String', desc:'邮箱'},
                        pwd:{type:'String', desc:'密码'},
                        confirmation:{type:'String', desc:'确认密码'},
                        phone:{type:'String', desc:'联系人手机号'},
                        codeNum:{type:'String', desc:'验证码'},
                    }
                }
            ],
            bindBiz:registerBiz.memberRegister1
        },
        {
            apiName:"个人入会流程2",
            notMiddleware:false,
            subUrl:'/memberdb/memberregister2',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        name:{type:'String', desc:'真实姓名'},
                        sex:{type:'Number', desc:'性别'},
                        documentType:{type:'Number', desc:'证件类型'},
                        documentId:{type:'String', desc:'证件号码'},
                        birth:{type:'Number', desc:'出生年月'},
                        nation:{type:'Number', desc:'民族'},
                        sheng:{type:'String', desc:'省'},
                        shi:{type:'String', desc:'市'},
                        qu:{type:'String', desc:'区'},
                        addres:{type:'String', desc:'通信地址'},
                        education:{type:'Number', desc:'学历'},
                        photoUrl:{type:'String', desc:'蓝底证件照'},
                        unitName:{type:'String', desc:'工作单位'},
                        duties:{type:'String', desc:'职务'},
                        workTitle:{type:'String', desc:'职称'},
                        profCategory:{type:'[Number]', desc:'专业类别'},
                        studyResume:{type:'String', desc:'学习简历'},
                        workResume:{type:'String', desc:'工作简历'},
                        profAchievement:{type:'String', desc:'专业成果'},
                        otherEMP:{type:'String', desc:'在其他社会组织任职情况'},
                        otherPROF:{type:'String', desc:'其他与本学会专业有关的情况'},
                        cardUrlJust:{type:'String', desc:'个人身份证扫描件正面'},
                        cardUrlBack:{type:'String', desc:'个人身份证扫描件反面'},
                        academicCERTUrl:{type:'String', desc:'个人学历证明扫描件'},
                        professionalCERTUrl:{type:'String', desc:'个人工作证明扫描件'},
                        auxiliaryMaterial:{type:'[String]', desc:'论文发表等证明工作成果或成绩的材料'},
                    }
                },
                {
                    key:"id", type:"String", desc:"会员id"
                }
            ],
            bindBiz:registerBiz.memberRegister2
        },
        {
            apiName:"单位入会流程1",
            notMiddleware:true,
            subUrl:'/memberdb/unitmemberregister1',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        loginId:{type:'String', desc:'用户名', notMustHave:false},
                        mail:{type:'String', desc:'单位邮箱', notMustHave:false},//2024.4.22日的需求 由邮箱改成单位邮箱
                        pwd:{type:'String', desc:'密码', notMustHave:false},
                        confirmation:{type:'String', desc:'确认密码', notMustHave:false},
                        phone:{type:'String', desc:'联系人手机号', notMustHave:false},
                        codeNum:{type:'String', desc:'验证码', notMustHave:false},
                    }
                }
            ],
            bindBiz:registerBiz.unitMemberRegister1
        },
        {
            apiName:"单位入会流程2",
            notMiddleware:false,
            subUrl:'/memberdb/unitmemberregister2',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        unitName:{type:'String', desc:'单位名称', notMustHave:false},
                        sheng:{type:'String', desc:'省', notMustHave:false},
                        shi:{type:'String', desc:'市', notMustHave:false},
                        qu:{type:'String', desc:'区', notMustHave:false},
                        addres:{type:'String', desc:'通信地址', notMustHave:false},
                        uscc:{type:'String', desc:'单位信用代码', notMustHave:false},
                        legalPerson:{type:'String', desc:'法人代表', notMustHave:false},
                        legalPersonPhone:{type:'String', desc:'法人联系电话', notMustHave:false},
                        legalPersonMail:{type:'String', desc:'法人邮箱', notMustHave:false},
                        // unitMail:{type:'String', desc:'单位电子邮箱', notMustHave:false},  2024.4.22日的需求 去掉
                        contactPerson:{type:'String', desc:'日常联系人', notMustHave:false},
                        contactPersonDuties:{type:'String', desc:'日常联系人职务', notMustHave:false},
                        contactPersonPhone:{type:'String', desc:'日常联系人手机', notMustHave:false},
                        uusinessLicenseUrl:{type:'String', desc:'营业执照复印件', notMustHave:false},
                        /**单位信息 */
                        unitMemberType:{type:'Number', desc:'单位信息类型，枚举', notMustHave:false},
                        yuanXiaoBanXueLeiXing:{type:'Number', desc:'院校办学类型，枚举', notMustHave:false},
                        yuanXiaoZhuGuanBuMen:{type:'String', desc:'院校主管部门', notMustHave:false},
                        yuanXiaoFuZeRen:{type:'String', desc:'院校主要负责人', notMustHave:false},
                        yuanXiaoFuZeRenZhiWu:{type:'String', desc:'院校主要负责人职务', notMustHave:false},
                        yuanXiaoFuZeRenDianHua:{type:'String', desc:'院校主要负责人电话', notMustHave:false},
                        yuanXiaoBanGongFuZeRen:{type:'String', desc:'院校办公负责人', notMustHave:false},
                        yuanXiaoBanGongFuZeRenDianHua:{type:'String', desc:'院校办公负责人电话', notMustHave:false},
                        ZhuYaoFuZeRenYouXiang:{type:'String', desc:'主要负责人邮箱', notMustHave:false},
                        yuanXiaoKeYanFuZeRen:{type:'String', desc:'院校科研负责人', notMustHave:false},
                        yuanXiaoKeYanFuZeRenDianHua:{type:'String', desc:'院校科研负责人电话', notMustHave:false},
                        jiaoXueFuZeRenXinMing:{type:'String', desc:'教学负责人姓名', notMustHave:false},
                        yuanXiaoXueShengZongRenShu:{type:'Number', desc:'院校学生总人数', notMustHave:true},
                        yuanXiaoJiaoZhiGongZongRenShu:{type:'Number', desc:'院校教职工总人数', notMustHave:true},
                        jiaoXueFuZeRenDianHua:{type:'String', desc:'教学负责人电话', notMustHave:false},
                        kaishezhuanYe:{type:'String', desc:'开设专业', notMustHave:true},
                        danWeiJianJie:{type:'String', desc:'单位简介', notMustHave:true},
                    }
                },
                {
                    key:"keyanForm", type:"[Object]", desc:"单位所获得科研成果表单"
                },
                {
                    key:"id", type:"String", desc:"会员id"
                }
            ],
            bindBiz:registerBiz.unitMemberRegister2
        },
        {
            apiName:"单位入会流程3",
            notMiddleware:false,
            subUrl:'/memberdb/unitmemberregister3',
            param:[
                {
                    key:"application", type:"String", desc:"入会申请表"
                },
                {
                    key:"id", type:"String", desc:"会员id"
                }
            ],
            bindBiz:registerBiz.unitMemberRegister3
        },
        {
            apiName:"发送短信验证码",
            notMiddleware:true,
            subUrl:'/memberdb/registersendcode',
            param:[
                {key:"phone", type:"String", desc:"联系人手机号"}
            ],
            bindBiz:registerBiz.memberRegisterSendCode
        },
        {
            apiName:"获取当前会员注册流程",
            notMiddleware:true,
            subUrl:'/memberdb/registerflowtype',
            param:[
                {
                    key:"id", type:"String", desc:"用户id", isNull:true
                }
            ],
            bindBiz:registerBiz.registerFlowType
        },
        {
            apiName:"单位会员【流程二】回显",
            notMiddleware:true,
            subUrl:'/memberdb/unitmemberecho2',
            param:[
                {
                    key:"id", type:"String", desc:"用户id"
                }
            ],
            bindBiz:registerBiz.unitMemberEcho2
        },
        {
            apiName:"单位会员【流程三】回显",
            notMiddleware:true,
            subUrl:'/memberdb/unitmemberecho3',
            param:[
                {
                    key:"id", type:"String", desc:"用户id"
                }
            ],
            bindBiz:registerBiz.unitMemberEcho3
        },
        {
            apiName:"个人会员【流程二】回显",
            notMiddleware:true,
            subUrl:'/memberdb/individualmemberdetails',
            param:[
                {
                    key:"id", type:"String", desc:"用户id"
                }
            ],
            bindBiz:registerBiz.individualMemberDetails
        },
        {
            apiName:"单位入会流程2保存未提交",
            notMiddleware:false,
            subUrl:'/memberdb/unitmembernotsaved',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        unitName:{type:'String', desc:'单位名称', notMustHave:true},
                        sheng:{type:'String', desc:'省', notMustHave:true},
                        shi:{type:'String', desc:'市', notMustHave:true},
                        qu:{type:'String', desc:'区', notMustHave:true},
                        addres:{type:'String', desc:'通信地址', notMustHave:true},
                        uscc:{type:'String', desc:'单位信用代码', notMustHave:true},
                        legalPerson:{type:'String', desc:'法人代表', notMustHave:true},
                        legalPersonPhone:{type:'String', desc:'法人联系电话', notMustHave:true},
                        legalPersonMail:{type:'String', desc:'法人邮箱', notMustHave:true},
                        contactPerson:{type:'String', desc:'日常联系人', notMustHave:true},
                        contactPersonDuties:{type:'String', desc:'日常联系人职务', notMustHave:true},
                        contactPersonPhone:{type:'String', desc:'日常联系人手机', notMustHave:true},
                        uusinessLicenseUrl:{type:'String', desc:'营业执照复印件', notMustHave:true},
                        /**单位信息 */
                        unitMemberType:{type:'Number', desc:'单位信息类型，枚举', notMustHave:true},
                        yuanXiaoBanXueLeiXing:{type:'Number', desc:'院校办学类型，枚举', notMustHave:true},
                        yuanXiaoZhuGuanBuMen:{type:'String', desc:'院校主管部门', notMustHave:true},
                        yuanXiaoFuZeRen:{type:'String', desc:'院校主要负责人', notMustHave:true},
                        yuanXiaoFuZeRenZhiWu:{type:'String', desc:'院校主要负责人职务', notMustHave:true},
                        yuanXiaoFuZeRenDianHua:{type:'String', desc:'院校主要负责人电话', notMustHave:true},
                        yuanXiaoBanGongFuZeRen:{type:'String', desc:'院校办公负责人', notMustHave:true},
                        yuanXiaoBanGongFuZeRenDianHua:{type:'String', desc:'院校办公负责人电话', notMustHave:true},
                        ZhuYaoFuZeRenYouXiang:{type:'String', desc:'主要负责人邮箱', notMustHave:true},
                        yuanXiaoKeYanFuZeRen:{type:'String', desc:'院校科研负责人', notMustHave:true},
                        yuanXiaoKeYanFuZeRenDianHua:{type:'String', desc:'院校科研负责人电话', notMustHave:true},
                        jiaoXueFuZeRenXinMing:{type:'String', desc:'教学负责人姓名', notMustHave:true},
                        yuanXiaoXueShengZongRenShu:{type:'Number', desc:'院校学生总人数', notMustHave:true},
                        yuanXiaoJiaoZhiGongZongRenShu:{type:'Number', desc:'院校教职工总人数', notMustHave:true},
                        jiaoXueFuZeRenDianHua:{type:'String', desc:'教学负责人电话', notMustHave:true},
                        kaishezhuanYe:{type:'String', desc:'开设专业', notMustHave:true},
                        danWeiJianJie:{type:'String', desc:'单位简介', notMustHave:true},
                    }
                },
                // {
                //     key:"keyanForm", type:"[Object]", desc:"单位所获得科研成果表单", isNull:true
                // },
                {
                    key:"keyanForm", type:"[Object]", sub:
                    {
                        startTime:{type:'Number', desc:'开始时间', notMustHave:true},
                        endTime:{type:'Number', desc:'结束时间', notMustHave:true},
                        describe:{type:'String', desc:'科研描述', notMustHave:true},
                    },
                    desc:"单位所获得科研成果表单"
                },
                {
                    key:"id", type:"String", desc:"会员id"
                }
            ],
            bindBiz:registerBiz.unitMemberNotSaved
        },
        {
            apiName:"个人入会流程2保存未提交",
            notMiddleware:false,
            subUrl:'/memberdb/membernotsaved',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        name:{type:'String', desc:'真实姓名', notMustHave:true},
                        sex:{type:'Number', desc:'性别', notMustHave:true},
                        documentType:{type:'Number', desc:'证件类型', notMustHave:true},
                        documentId:{type:'String', desc:'证件号码', notMustHave:true},
                        birth:{type:'Number', desc:'出生年月', notMustHave:true},
                        nation:{type:'Number', desc:'民族', notMustHave:true},
                        sheng:{type:'String', desc:'省', notMustHave:true},
                        shi:{type:'String', desc:'市', notMustHave:true},
                        qu:{type:'String', desc:'区', notMustHave:true},
                        addres:{type:'String', desc:'通信地址', notMustHave:true},
                        education:{type:'Number', desc:'学历', notMustHave:true},
                        photoUrl:{type:'String', desc:'蓝底证件照', notMustHave:true},
                        unitName:{type:'String', desc:'工作单位', notMustHave:true},
                        duties:{type:'String', desc:'职务', notMustHave:true},
                        workTitle:{type:'String', desc:'职称', notMustHave:true},
                        profCategory:{type:'[Number]', desc:'专业类别', notMustHave:true},
                        studyResume:{type:'String', desc:'学习简历', notMustHave:true},
                        workResume:{type:'String', desc:'工作简历', notMustHave:true},
                        profAchievement:{type:'String', desc:'专业成果', notMustHave:true},
                        otherEMP:{type:'String', desc:'在其他社会组织任职情况', notMustHave:true},
                        otherPROF:{type:'String', desc:'其他与本学会专业有关的情况', notMustHave:true},
                        cardUrlJust:{type:'String', desc:'个人身份证扫描件正面', notMustHave:true},
                        cardUrlBack:{type:'String', desc:'个人身份证扫描件反面', notMustHave:true},
                        academicCERTUrl:{type:'String', desc:'个人学历证明扫描件', notMustHave:true},
                        professionalCERTUrl:{type:'String', desc:'个人工作证明扫描件', notMustHave:true},
                        auxiliaryMaterial:{type:'[String]', desc:'论文发表等证明工作成果或成绩的材料', notMustHave:true},
                    }
                },
                {
                    key:"id", type:"String", desc:"会员id"
                }
            ],
            bindBiz:registerBiz.memberNotSaved
        },
    ],
    "登陆相关":[
        {
            apiName:"登陆",
            subUrl:'/login',
            notMiddleware:true,
            param:[
                {key:"loginId", type:"String", desc:"账号"},
                {key:"pwd", type:"String", desc:"密码"}
            ],
            bindBiz:userBiz.login
        },
        {
            apiName:"注销登陆",
            subUrl:'/logout',
            param:[
            ],
            bindBiz:userBiz.logout
        },
        {
            apiName:"修改密码",
            subUrl:'/changepwd',
            notMiddleware:true,
            param:[
                {key:"userId", type:"String", desc:"userId", isNull:true},
                {key:"phone", type:"String", desc:"绑定手机号"},
                {key:"pwd", type:"String", desc:"密码"},
                {key:"confirmation", type:"String", desc:"二次确认密码"},
                {key:"code", type:"String", desc:"验证码"}
            ],
            bindBiz:userBiz.changePwd
        },{
            apiName:"修改密码用短信验证码",
            subUrl:'/getchangepwdcode',
            notMiddleware:true,
            param:[
                {key:"userId", type:"String", desc:"userId", isNull:true},
                {key:"phone", type:"String", desc:"绑定手机号"}
            ],
            bindBiz:userBiz.memberChangePwdSendCode
        }
    ],
    "会员库":[
        {
            apiName:"单位会员列表",
            subUrl:'/memberdb/unitmemberlist',
            param:[
                {key:"unitName", type:"String", desc:"单位名称", isNull:true},
                {key:"mail", type:"String", desc:"单位邮箱", isNull:true},
                {key:"phone", type:"String", desc:"登录手机号", isNull:true},
                {key:"joinStartTime", type:"Number", desc:"入会开始时间", isNull:true},
                {key:"joinEndTime", type:"Number", desc:"入会结束时间", isNull:true},
                {key:"unitMemberType", type:"[Number]", desc:"单位会员类型", isNull:true},
                {key:"memberLevel", type:"[Number]", desc:"会员等级职务", isNull:true},
                {key:"session", type:"Number", desc:"届次", isNull:true},
                {key:"memberState", type:"Number", desc:"状态", isNull:true},
                {key:"lableId", type:"[String]", desc:"标签Id", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:memberBiz.unitMemberList
        },
        {
            apiName:"个人会员列表",
            subUrl:'/memberdb/individualmemberlist',
            param:[ 
                {key:"name", type:"String", desc:"姓名", isNull:true},
                {key:"documentId", type:"String", desc:"身份证", isNull:true},
                {key:"phone", type:"String", desc:"手机号", isNull:true},
                {key:"mail", type:"String", desc:"个人邮箱", isNull:true},
                {key:"joinStartTime", type:"Number", desc:"入会开始时间", isNull:true},
                {key:"joinEndTime", type:"Number", desc:"入会结束时间", isNull:true},
                {key:"individualMemberType", type:"[Number]", desc:"会员级别", isNull:true},
                {key:"memberLevel", type:"[Number]", desc:"会员职务", isNull:true},
                {key:"session", type:"Number", desc:"届次", isNull:true},
                {key:"profCategory", type:"Number", desc:"专业类别", isNull:true},
                {key:"memberState", type:"Number", desc:"状态", isNull:true},
                {key:"lableId", type:"[String]", desc:"标签Id", isNull:true},
                {key:"unitName", type:"String", desc:"所属单位", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:memberBiz.individualMemberList
        },
        {
            apiName:"单位会员详情",
            subUrl:'/memberdb/unit/memberdetails',
            param:[
                {key:"id", type:"String", desc:"用户id"}
            ],
            bindBiz:memberBiz.unitMemberDetails
        },
        {
            apiName:"个人会员详情",
            subUrl:'/memberdb/individual/memberdetails',
            param:[
                {key:"id", type:"String", desc:"用户id"}
            ],
            bindBiz:memberBiz.individualMemberDetails
        },
        {
            apiName:"删除单位所获得科研成果",
            subUrl:'/memberdb/delresearch',
            param:[
                {key:"id", type:"String", desc:"单位会员列表下发的标识"}
            ],
            bindBiz:memberBiz.delResearch
        },
        {
            apiName:"单位会员修改",
            subUrl:'/memberdb/unitmemberupdate',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        /**基本信息 */
                        unitName:{type:'String', desc:'单位名称'},
                        addres:{type:'String', desc:'通信地址'},
                        legalPerson:{type:'String', desc:'法人代表'},
                        legalPersonPhone:{type:'String', desc:'法人联系电话'},
                        legalPersonMail:{type:'String', desc:'法人邮箱'},
                        unitMail:{type:'String', desc:'单位电子邮箱'},
                        contactPerson:{type:'String', desc:'日常联系人'},
                        contactPersonDuties:{type:'String', desc:'日常联系人职务'},
                        contactPersonPhone:{type:'String', desc:'日常联系人电话'},
                        sheng:{type:'String', desc:'省'},
                        shi:{type:'String', desc:'市'},
                        qu:{type:'String', desc:'区'},
                        uusinessLicenseUrl:{type:'String', desc:'营业执照'},
                        /**单位信息 */
                        unitMemberType:{type:'Number', desc:'单位类型'},
                        yuanXiaoBanXueLeiXing:{type:'Number', desc:'办学类型'},
                        yuanXiaoZhuGuanBuMen:{type:'String', desc:'主管部门'},
                        yuanXiaoFuZeRen:{type:'String', desc:'主要负责人姓名'},
                        yuanXiaoFuZeRenZhiWu:{type:'String', desc:'主要负责人职位'},
                        yuanXiaoFuZeRenDianHua:{type:'String', desc:'主要负责人电话'},
                        ZhuYaoFuZeRenYouXiang:{type:'String', desc:'主要负责人邮箱'},
                        yuanXiaoBanGongFuZeRen:{type:'String', desc:'办公负责人姓名'},
                        yuanXiaoBanGongFuZeRenDianHua:{type:'String', desc:'办公负责人电话'},
                        yuanXiaoKeYanFuZeRen:{type:'String', desc:'科研负责人姓名'},
                        yuanXiaoKeYanFuZeRenDianHua:{type:'String', desc:'科研负责人电话'},
                        jiaoXueFuZeRenXinMing:{type:'String', desc:'教学负责人姓名'},
                        jiaoXueFuZeRenDianHua:{type:'String', desc:'教学负责人电话'},
                        kaishezhuanYe:{type:'String', desc:'开设专业', notMustHave:true},
                        danWeiJianJie:{type:'String', desc:'单位简介', notMustHave:true}
                    },
                    desc:"表单"
                },
                {
                    key:"keyanForm", type:"[Object]", sub:
                    {
                        startTime:{type:'Number', desc:'开始时间'},
                        endTime:{type:'Number', desc:'结束时间'},
                        describe:{type:'String', desc:'科研描述'},
                    },
                    desc:"单位所获得科研成果表单"
                },
                {
                    key:"id", type:"String", desc:"用户id"
                }
            ],
            bindBiz:memberBiz.unitMemberUpdate
        },
        {
            apiName:"个人会员修改",
            subUrl:'/memberdb/memberupdate',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        /**基本信息 */
                        name:{type:'String', desc:'真实姓名'},
                        sex:{type:'Number', desc:'性别'},
                        nation:{type:'Number', desc:'民族'},
                        birth:{type:'Number', desc:'出身年月'},
                        documentType:{type:'Number', desc:'证件类型'},
                        documentId:{type:'String', desc:'证件号码'},
                        sheng:{type:'String', desc:'省'},
                        shi:{type:'String', desc:'市'},
                        qu:{type:'String', desc:'区'},
                        phone:{type:'String', desc:'手机号码'},
                        mail:{type:'String', desc:'电子邮箱'},
                        addres:{type:'String', desc:'通信地址'},
                        photoUrl:{type:'String', desc:'蓝底证件照'},
                        education:{type:'Number', desc:'学历'},
                        /**专业信息 */
                        unitName:{type:'String', desc:'工作单位'},
                        duties:{type:'String', desc:'职务'},
                        workTitle:{type:'String', desc:'职称'},
                        profCategory:{type:'[Number]', desc:'专业类别'},
                        studyResume:{type:'String', desc:'学习简历'},
                        workResume:{type:'String', desc:'工作简历'},
                        profAchievement:{type:'String', desc:'教研成果'},
                        otherEMP:{type:'String', desc:'其他组织任职情况'},
                        otherPROF:{type:'String', desc:'其他情况'},
                        /**其他附件 */
                        cardUrlJust:{type:'String', desc:'个人身份证扫描件正面'},
                        cardUrlBack:{type:'String', desc:'个人身份证扫描件反面'},
                        academicCERTUrl:{type:'String', desc:'个人学历证明扫描件'},
                        professionalCERTUrl:{type:'String', desc:'个人工作证明扫描件'},
                        auxiliaryMaterial:{type:'[String]', desc:'论文发表或成绩材料'},
                    }
                },
                {
                    key:"id", type:"String", desc:"用户id"
                }
            ],
            bindBiz:memberBiz.individualMemberUpdate
        },
        {
            apiName:"获取个人基础信息",
            subUrl:'/memberdb/systembase',
            param:[],
            bindBiz:memberBiz.systemBase
        }
    ],
    "审批管理":[
        {
            apiName:"开放或关闭注册",
            subUrl:'/examine/user/register/changestart', 
            param:[
                {key:"start", type:"Boolean", desc:"是否开放注册"},
            ],
            bindBiz:registerBiz.updateRegisterStart
        },
        {
            apiName:"提交资料列表",
            subUrl:'/examine/submitdocument',
            param:[
                {key:"loginId", type:"String", desc:"用户名", isNull:true},
                {key:"phone", type:"String", desc:"登录手机号", isNull:true},
                {key:"mail", type:"String", desc:"邮箱", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"},
                {key:"pageSize", type:"Number", desc:"一页显示多少数据"},
            ],
            bindBiz:examineBiz.submitDocument
        },
        // {
        //     apiName:"提交资料-驳回",
        //     subUrl:'/examine/rejectjoin', 
        //     param:[
        //         {key:"id", type:"String", desc:"提交资料列表返回的用户id"}
        //     ],
        //     bindBiz:examineBiz.rejectJoin
        // },
        {
            apiName:"提交资料-删除",
            subUrl:'/examine/delrejectjoin', 
            param:[
                {key:"id", type:"String", desc:"提交资料列表返回的用户id"}
            ],
            bindBiz:examineBiz.delRejectJoin
        },
        {
            apiName:"待审核列表",
            subUrl:'/examine/pendingreview', 
            param:[
                {key:"name", type:"String", desc:"名称", isNull:true},
                {key:"memberType", type:"[Number]", desc:"会员类别", isNull:true},
                {key:"documentId", type:"String", desc:"身份证", isNull:true},
                {key:"phone", type:"String", desc:"登录手机号", isNull:true},
                {key:"mail", type:"String", desc:"邮箱", isNull:true},
                {key:"sheng", type:"String", desc:"省", isNull:true},
                {key:"shi", type:"String", desc:"市", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"},
                {key:"pageSize", type:"Number", desc:"一页显示多少数据"},
                {key:"examineState", type:"Number", desc:"审核状态", isNull:true},
            ],
            bindBiz:examineBiz.pendingReviewList
        },
        {
            apiName:"通过审批",
            subUrl:'/examine/adopt', 
            param:[
                {key:"id", type:"String", desc:"待审核列表返回的用户id"},
                {key:"session", type:"Number", desc:"审批届次"},
            ],
            bindBiz:examineBiz.adopt
        },
        {
            apiName:"批量通过审批",
            subUrl:'/examine/batchadopt', 
            param:[
                {key:"idList", type:"[String]", desc:"批量审核的用户列表"},
                {key:"session", type:"Number", desc:"审批届次"},
            ],
            bindBiz:examineBiz.batchAdopt
        },
        {
            apiName:"驳回审批",
            subUrl:'/examine/reject', 
            param:[
                {key:"id", type:"String", desc:"待审核列表返回的用户id"},
                {key:"remarks", type:"String", desc:"驳回理由"}
            ],
            bindBiz:examineBiz.reject
        },
        {
            apiName:"审批历史",
            subUrl:'/examine/approvalhistorylist', 
            param:[
                {key:"userId", type:"String", desc:"待审核列表返回的用户id"},
            ],
            bindBiz:examineBiz.approvalHistoryList
        },
        {
            apiName:"驳回列表",
            subUrl:'/examine/rejectlist', 
            param:[
                {key:"loginId", type:"String", desc:"用户名", isNull:true},
                {key:"phone", type:"String", desc:"登录手机号", isNull:true},
                {key:"mail", type:"String", desc:"邮箱", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"},
                {key:"pageSize", type:"Number", desc:"一页显示多少数据"},
            ],
            bindBiz:examineBiz.rejectList
        },
        {
            apiName:"删除驳回列表会员",
            subUrl:'/examine/delreject', 
            param:[
                {key:"id", type:"String", desc:"驳回列表返回的用户id"},
            ],
            bindBiz:examineBiz.delReject
        },

        // {
        //     apiName:"下拉框选择届次",
        //     subUrl:'/examine/getsession',
        //     param:[],
        //     bindBiz:examineBiz.getSession
        // }
    ],
    "会费管理":[
        {
            apiName:"会费管理导出",
            subUrl:'/memberfees/outputdata',
            param:[
                {key:"type", type:"Number", desc:"导出类型"},
                {key:"exportColumns", type:"[]", desc:"导出数据列"}
            ],
            bindBiz:memberFeesBiz.outPutDataForExcel
        },
        {
            apiName:"已缴费名单列表",
            subUrl:'/memberfees/paid',
            param:[
                {key:"name", type:"String", desc:"名称", isNull:true},
                {key:"memberType", type:"[Number]", desc:"会员类别", isNull:true},
                {key:"documentId", type:"String", desc:"身份证", isNull:true},
                {key:"phone", type:"String", desc:"手机号", isNull:true},
                {key:"mail", type:"String", desc:"邮箱", isNull:true},
                {key:"joinStartTime", type:"Number", desc:"入会开始时间", isNull:true},
                {key:"joinEndTime", type:"Number", desc:"入会结束时间", isNull:true},
                {key:"memberLevel", type:"[Number]", desc:"个人级别职务", isNull:true},
                {key:"session", type:"Number", desc:"届次", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:memberFeesBiz.getPaid
        },
        {
            apiName:"已缴费列表的订单日志",
            subUrl:'/memberfees/paidorderlist', 
            param:[
                {key:"id", type:"String", desc:"用户id"},
            ],
            bindBiz:memberFeesBiz.paidOrderList
        },
        {
            apiName:"待缴费列表",
            subUrl:'/memberfees/unpaidlist', 
            param:[
                {key:"name", type:"String", desc:"名称", isNull:true},
                {key:"memberType", type:"[Number]", desc:"会员类别", isNull:true},
                {key:"documentId", type:"String", desc:"身份证", isNull:true},
                {key:"phone", type:"String", desc:"手机号", isNull:true},
                {key:"mail", type:"String", desc:"邮箱", isNull:true},
                {key:"joinStartTime", type:"Number", desc:"入会开始时间", isNull:true},
                {key:"joinEndTime", type:"Number", desc:"入会结束时间", isNull:true},
                {key:"memberLevel", type:"[Number]", desc:"个人级别职务", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:memberFeesBiz.unpaidList
        },
        {
            apiName:"欠费名单列表",
            subUrl:'/memberfees/getrenewalperiod', 
            param:[
                {key:"name", type:"String", desc:"名称", isNull:true},
                {key:"memberType", type:"[Number]", desc:"会员类别", isNull:true},
                {key:"documentId", type:"String", desc:"身份证", isNull:true},
                {key:"phone", type:"String", desc:"手机号", isNull:true},
                {key:"mail", type:"String", desc:"邮箱", isNull:true},
                {key:"joinStartTime", type:"Number", desc:"入会开始时间", isNull:true},
                {key:"joinEndTime", type:"Number", desc:"入会结束时间", isNull:true},
                {key:"memberLevel", type:"[Number]", desc:"个人级别职务", isNull:true},
                {key:"session", type:"Number", desc:"届次", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:memberFeesBiz.getRenewalPeriod
        },
        {
            apiName:"欠费名单列表-欠费周期列表",
            subUrl:'/memberfees/getrenewalperiod/memberarrearsrenewalperiodlist', 
            param:[
                {key:"id", type:"String", desc:"选中用户的userid"}
            ],
            bindBiz:memberFeesBiz.memberArrearsList
        },
        {
            apiName:"线下付款",
            subUrl:'/memberfees/offlinepayment', 
            param:[
                {key:"orderId", type:"String", desc:"订单id", isNull:true},
                {key:"paymentNum", type:"String", desc:"支付单号", isNull:true},
                {key:"offlinePaymentUrl", type:"String", desc:"转账截图"}
            ],
            bindBiz:memberFeesBiz.offlinePayment
        },
        {
            apiName:"多比订单时选择线下付款页面的选择缴费周期页",
            subUrl:'/memberfees/selectmanyorder', 
            param:[
                {key:"id", type:"String", desc:"会员id", isNull:true},
            ],
            bindBiz:memberFeesBiz.selectManyOrderForUser
        },
        {
            apiName:"设置宽限期",
            subUrl:'/memberfees/setgraceperiod', 
            param:[
                {key:"id", type:"String", desc:"列表返回id", isNull:true},
                {key:"gracePeriodEndTime", type:"Number", desc:"宽限期到期时间", isNull:true},
            ],
            bindBiz:memberFeesBiz.setGracePeriod
        },
        {
            apiName:"宽限期名单列表",
            subUrl:'/memberfees/getgraceperiod', 
            param:[
                {key:"name", type:"String", desc:"名称", isNull:true},
                {key:"memberType", type:"[Number]", desc:"会员类别", isNull:true},
                {key:"documentId", type:"String", desc:"身份证", isNull:true},
                {key:"phone", type:"String", desc:"手机号", isNull:true},
                {key:"mail", type:"String", desc:"邮箱", isNull:true},
                {key:"joinStartTime", type:"Number", desc:"入会开始时间", isNull:true},
                {key:"joinEndTime", type:"Number", desc:"入会结束时间", isNull:true},
                {key:"memberLevel", type:"[Number]", desc:"个人级别职务", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:memberFeesBiz.getGracePeriod
        },
        {
            apiName:"移除宽限期",
            subUrl:'/memberfees/delgraceperiod', 
            param:[
                {key:"id", type:"String", desc:"列表返回id", isNull:true},
            ],
            bindBiz:memberFeesBiz.delGracePeriod
        },

    ],
    "会员管理":[
        {
            apiName:"会员权限列表",
            subUrl:'/authority/list',
            param:[
                {key:"unitName", type:"String", desc:"单位名称", isNull:true},
                {key:"memberLevel", type:"Number", desc:"会员等级", isNull:true},
                {key:"memberCategory", type:"Number", desc:"单位、个人会员类别", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:authorityBiz.getAuthority
        },
        {
            apiName:"变更权限",
            subUrl:'/authority/update',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        memberLevel:{type:'Number', desc:'等级、职务'},
                        memberCategory:{type:'Number', desc:'单位、个人会员类别、级别'},
                    }
                },
                {
                    key:"id", type:"String", desc:"用户id"
                }
            ],
            bindBiz:authorityBiz.updateAuthority
        },
        {
            apiName:"冻结",
            subUrl:'/authority/freeze',
            param:[
                {
                    key:"id", type:"String", desc:"用户id"
                }
            ],
            bindBiz:authorityBiz.freeze
        },
        {
            apiName:"变更权限回显",
            subUrl:'/authority/authorityecho',
            param:[
                {
                    key:"id", type:"String", desc:"用户id"
                }
            ],
            bindBiz:authorityBiz.authorityEcho
        }
    ],
    "权限管理":[
        {
            apiName:"管理员列表",
            subUrl:'/rightsmgmt/adminlist',
            param:[
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:rightsMgmtBiz.adminList
        },
        {
            apiName:"添加管理员",
            subUrl:'/rightsmgmt/addadmin',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        loginId:{type:'String', desc:'用户名'},
                        pwd:{type:'String', desc:'密码'},
                        confirmation:{type:'String', desc:'确认密码'},
                        adminType:{type:'Number', desc:'管理员类别'},
                        adminLv:{type:'[Number]', desc:'管理员等级'},
                    }
                }
            ],
            bindBiz:rightsMgmtBiz.addAdmin
        },
        {
            apiName:"修改密码",
            subUrl:'/rightsmgmt/changeadminpwd',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        id:{type:'String', desc:'列表返回的用户id'},
                        pwd:{type:'String', desc:'密码'},
                        confirmation:{type:'String', desc:'确认密码'},
                    }
                }
            ],
            bindBiz:rightsMgmtBiz.changeAdminPwd
        },
        {
            apiName:"修改权限",
            subUrl:'/rightsmgmt/updatemgmt',
            param:[
                {key:"id", type:"String", desc:"登录用户id"},
                {key:"adminLv", type:"[Number]", desc:"管理员等级"},
            ],
            bindBiz:rightsMgmtBiz.updateMGMT
        },
        {
            apiName:"回显",
            subUrl:'/rightsmgmt/info',
            param:[
                {key:"id", type:"String", desc:"用户id"},
            ],
            bindBiz:rightsMgmtBiz.info
        },
        {
            apiName:"冻结解冻",
            subUrl:'/rightsmgmt/freeze',
            param:[
                {
                    key:"id", type:"String", desc:"列表返回的用户id"
                }
            ],
            bindBiz:rightsMgmtBiz.freeze
        },
        {
            apiName:"删除管理员",
            subUrl:'/rightsmgmt/deleteadmin',
            param:[
                {key:"id", type:"String", desc:"列表返回的用户id"}
            ],
            bindBiz:rightsMgmtBiz.deleteAdmin
        },
        {
            apiName:"权限下拉列表",
            subUrl:'/rightsmgmt/mgmtselectlist',
            param:[
            ],
            bindBiz:rightsMgmtBiz.mgmtSelectList
        },
    ],
    "个人首页展示":[
        {
            apiName:"会员信息展示",
            subUrl:'/homepage/list',
            param:[],
            bindBiz:homePageBiz.getMemberData
        },
        {
            apiName:"单位会员修改",
            subUrl:'/homePage/unitmemberupdate',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        /**基本信息 */
                        unitName:{type:'String', desc:'单位名称'},
                        addres:{type:'String', desc:'通信地址'},
                        legalPerson:{type:'String', desc:'法人代表'},
                        legalPersonPhone:{type:'String', desc:'法人联系电话'},
                        legalPersonMail:{type:'String', desc:'法人邮箱'},
                        unitMail:{type:'String', desc:'单位电子邮箱'},
                        contactPerson:{type:'String', desc:'日常联系人'},
                        contactPersonDuties:{type:'String', desc:'日常联系人职务'},
                        contactPersonPhone:{type:'String', desc:'日常联系人电话'},
                        sheng:{type:'String', desc:'省'},
                        shi:{type:'String', desc:'市'},
                        qu:{type:'String', desc:'区'},
                        uusinessLicenseUrl:{type:'String', desc:'营业执照'},
                        /**单位信息 */
                        unitMemberType:{type:'Number', desc:'单位类型'},
                        yuanXiaoBanXueLeiXing:{type:'Number', desc:'办学类型'},
                        yuanXiaoZhuGuanBuMen:{type:'String', desc:'主管部门'},
                        yuanXiaoFuZeRen:{type:'String', desc:'主要负责人姓名'},
                        yuanXiaoFuZeRenZhiWu:{type:'String', desc:'主要负责人职位'},
                        yuanXiaoFuZeRenDianHua:{type:'String', desc:'主要负责人电话'},
                        ZhuYaoFuZeRenYouXiang:{type:'String', desc:'主要负责人邮箱'},
                        yuanXiaoBanGongFuZeRen:{type:'String', desc:'办公负责人姓名'},
                        yuanXiaoBanGongFuZeRenDianHua:{type:'String', desc:'办公负责人电话'},
                        yuanXiaoKeYanFuZeRen:{type:'String', desc:'科研负责人姓名'},
                        yuanXiaoKeYanFuZeRenDianHua:{type:'String', desc:'科研负责人电话'},
                        jiaoXueFuZeRenXinMing:{type:'String', desc:'教学负责人姓名'},
                        jiaoXueFuZeRenDianHua:{type:'String', desc:'教学负责人电话'},
                        kaishezhuanYe:{type:'String', desc:'开设专业', notMustHave:true},
                        danWeiJianJie:{type:'String', desc:'单位简介', notMustHave:true}
                    },
                    desc:"表单"
                },
                {
                    key:"keyanForm", type:"[Object]", sub:
                    {
                        startTime:{type:'Number', desc:'开始时间'},
                        endTime:{type:'Number', desc:'结束时间'},
                        describe:{type:'String', desc:'科研描述'},
                    },
                    desc:"单位所获得科研成果表单"
                }
            ],
            bindBiz:homePageBiz.unitMemberUpdate
        },
        {
            apiName:"个人会员修改",
            subUrl:'/homePage/memberupdate',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        /**基本信息 */
                        name:{type:'String', desc:'真实姓名'},
                        sex:{type:'Number', desc:'性别'},
                        nation:{type:'Number', desc:'民族'},
                        birth:{type:'Number', desc:'出身年月'},
                        documentType:{type:'Number', desc:'证件类型'},
                        documentId:{type:'String', desc:'证件号码'},
                        sheng:{type:'String', desc:'省'},
                        shi:{type:'String', desc:'市'},
                        qu:{type:'String', desc:'区'},
                        phone:{type:'String', desc:'手机号码'},
                        mail:{type:'String', desc:'电子邮箱'},
                        addres:{type:'String', desc:'通信地址'},
                        photoUrl:{type:'String', desc:'蓝底证件照'},
                        education:{type:'Number', desc:'学历'},
                        /**专业信息 */
                        unitName:{type:'String', desc:'工作单位'},
                        duties:{type:'String', desc:'职务'},
                        workTitle:{type:'String', desc:'职称'},
                        profCategory:{type:'[Number]', desc:'专业类别'},
                        studyResume:{type:'String', desc:'学习简历'},
                        workResume:{type:'String', desc:'工作简历'},
                        profAchievement:{type:'String', desc:'教研成果'},
                        otherEMP:{type:'String', desc:'其他组织任职情况'},
                        otherPROF:{type:'String', desc:'其他情况'},
                        /**其他附件 */
                        cardUrlJust:{type:'String', desc:'个人身份证扫描件正面'},
                        cardUrlBack:{type:'String', desc:'个人身份证扫描件反面'},
                        academicCERTUrl:{type:'String', desc:'个人学历证明扫描件'},
                        professionalCERTUrl:{type:'String', desc:'个人工作证明扫描件'},
                        auxiliaryMaterial:{type:'[String]', desc:'论文发表或成绩材料'},
                    }
                }
            ],
            bindBiz:homePageBiz.individualMemberUpdate
        },
        {
            apiName:"消息中心列表",
            subUrl:'/homepage/xiaoxizhongxin',
            param:[],
            bindBiz:homePageBiz.getXiaoXiZhongXin
        },
        {
            apiName:"地图信息",
            subUrl:'/homepage/mapsheng',
            param:[],
            bindBiz:homePageBiz.getSheng
        },
        {
            apiName:"活动列表",
            subUrl:'/homepage/huodongtongzhi',
            param:[
            ],
            bindBiz:homePageBiz.getHuoDongTongZhi
        },
        {
            apiName:"获取可下载证书模板",
            subUrl:'/homepage/getcertificate',
            param:[
            ],
            bindBiz:homePageBiz.getCertificate
        },
        {
            apiName:"获取可下载理事、常务理事证明函",
            subUrl:'/homepage/getcertificatetype',
            param:[
            ],
            bindBiz:homePageBiz.getCertificateType
        },
        {
            apiName:"能否申请变更理事",
            subUrl:'/homepage/getapply',
            param:[
            ],
            bindBiz:homePageBiz.getApply
        },
        {
            apiName:"变更职位",
            subUrl:'/homepage/memberlevelupdate',
            param:[
                {key:"memberLevel", type:"Number", desc:"变更职位"}
            ],
            bindBiz:homePageBiz.memberlevelUpdate
        },
        {
            apiName:"资料变更",
            subUrl:'/homepage/infomationchange/update',
            param:[
                {key:"unitName", type:"String", desc:"单位会员名称"},
                {key:"uscc", type:"String", desc:"统一信用代码"},
                {key:"legalPerson", type:"String", desc:"法人代表"},
                {key:"unitMemberType", type:"Number", desc:"单位会员类型"},
                {key:"yuanXiaoBanXueLeiXing", type:"Number", desc:"帮学类型"},
                {key:"uusinessLicenseUrl", type:"String", desc:"营业执照"},
                {key:"applicationForm", type:"String", desc:"盖章申请表"},
                {key:"desc", type:"String", desc:"描述位"},
                {key:"legalPersonMail", type:"String", desc:"法人邮件"},
                {key:"legalPersonPhone", type:"String", desc:"法人电话"},
            ],
            bindBiz:homePageBiz.infomationChangeUpdate
        },
        {
            apiName:"资料变更回显",
            subUrl:'/homepage/infomationchange/info',
            param:[],
            bindBiz:homePageBiz.infomationChangeInfo
        },
        {
            apiName:"是否需要补充用户信息",
            subUrl:'/homepage/isneedsupplement',
            param:[
            ],
            bindBiz:homePageBiz.isNeedSupplement
        },
        {
            apiName:"个人会员用户注册信息补充",
            subUrl:'/homepage/infosupplement',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        /**基本信息 */
                        name:{type:'String', desc:'真实姓名'},
                        sex:{type:'Number', desc:'性别'},
                        documentType:{type:'Number', desc:'证件类型'},
                        documentId:{type:'String', desc:'证件号码'},
                        birth:{type:'Number', desc:'出生年月'},
                        nation:{type:'Number', desc:'民族'},
                        sheng:{type:'String', desc:'省'},
                        shi:{type:'String', desc:'市'},
                        qu:{type:'String', desc:'区'},
                        addres:{type:'String', desc:'通信地址'},
                        /**专业信息 */
                        education:{type:'Number', desc:'学历'},
                        photoUrl:{type:'String', desc:'蓝底证件照'},
                        unitName:{type:'String', desc:'工作单位'},
                        duties:{type:'String', desc:'职务'},
                        workTitle:{type:'String', desc:'职称'},
                        profCategory:{type:'[Number]', desc:'专业类别'},
                        studyResume:{type:'String', desc:'学习简历'},
                        workResume:{type:'String', desc:'工作简历'},
                        profAchievement:{type:'String', desc:'专业成果'},
                        otherEMP:{type:'String', desc:'在其他社会组织任职情况'},
                        otherPROF:{type:'String', desc:'其他与本学会专业有关的情况'},
                        /**其他附件 */
                        cardUrlJust:{type:'String', desc:'个人身份证扫描件正面'},
                        cardUrlBack:{type:'String', desc:'个人身份证扫描件反面'},
                        academicCERTUrl:{type:'String', desc:'个人学历证明扫描件'},
                        professionalCERTUrl:{type:'String', desc:'个人工作证明扫描件', notMustHave:true},
                        auxiliaryMaterial:{type:'[String]', desc:'论文发表等证明工作成果或成绩的材料', notMustHave:true},
                    }
                }
            ],
            bindBiz:homePageBiz.infoSupplement
        },
        {
            apiName:"单位会员用户注册信息补充",
            subUrl:'/homepage/unitinfosupplement',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        unitName:{type:'String', desc:'单位名称', notMustHave:false},
                        sheng:{type:'String', desc:'省', notMustHave:false},
                        shi:{type:'String', desc:'市', notMustHave:false},
                        qu:{type:'String', desc:'区', notMustHave:false},
                        addres:{type:'String', desc:'通信地址', notMustHave:false},
                        uscc:{type:'String', desc:'单位信用代码', notMustHave:false},
                        legalPerson:{type:'String', desc:'法人代表', notMustHave:false},
                        legalPersonPhone:{type:'String', desc:'法人联系电话', notMustHave:false},
                        legalPersonMail:{type:'String', desc:'法人邮箱', notMustHave:false},
                        // unitMail:{type:'String', desc:'单位电子邮箱', notMustHave:false},  2024.4.22日的需求 去掉
                        contactPerson:{type:'String', desc:'日常联系人', notMustHave:false},
                        contactPersonDuties:{type:'String', desc:'日常联系人职务', notMustHave:false},
                        contactPersonPhone:{type:'String', desc:'日常联系人手机', notMustHave:false},
                        uusinessLicenseUrl:{type:'String', desc:'营业执照复印件', notMustHave:false},
                        /**单位信息 */
                        unitMemberType:{type:'Number', desc:'单位信息类型，枚举', notMustHave:false},
                        yuanXiaoBanXueLeiXing:{type:'Number', desc:'院校办学类型，枚举', notMustHave:false},
                        yuanXiaoZhuGuanBuMen:{type:'String', desc:'院校主管部门', notMustHave:false},
                        yuanXiaoFuZeRen:{type:'String', desc:'院校主要负责人', notMustHave:false},
                        yuanXiaoFuZeRenZhiWu:{type:'String', desc:'院校主要负责人职务', notMustHave:false},
                        yuanXiaoFuZeRenDianHua:{type:'String', desc:'院校主要负责人电话', notMustHave:false},
                        yuanXiaoBanGongFuZeRen:{type:'String', desc:'院校办公负责人', notMustHave:false},
                        yuanXiaoBanGongFuZeRenDianHua:{type:'String', desc:'院校办公负责人电话', notMustHave:false},
                        ZhuYaoFuZeRenYouXiang:{type:'String', desc:'主要负责人邮箱', notMustHave:false},
                        yuanXiaoKeYanFuZeRen:{type:'String', desc:'院校科研负责人', notMustHave:false},
                        yuanXiaoKeYanFuZeRenDianHua:{type:'String', desc:'院校科研负责人电话', notMustHave:false},
                        jiaoXueFuZeRenXinMing:{type:'String', desc:'教学负责人姓名', notMustHave:false},
                        yuanXiaoXueShengZongRenShu:{type:'Number', desc:'院校学生总人数', notMustHave:true},
                        yuanXiaoJiaoZhiGongZongRenShu:{type:'Number', desc:'院校教职工总人数', notMustHave:true},
                        jiaoXueFuZeRenDianHua:{type:'String', desc:'教学负责人电话', notMustHave:false},
                        kaishezhuanYe:{type:'String', desc:'开设专业', notMustHave:true},
                        danWeiJianJie:{type:'String', desc:'单位简介', notMustHave:true},
                    },
                    desc:"表单"
                },
                {
                    key:"keyanForm", type:"[Object]", sub:
                    {
                        startTime:{type:'Number', desc:'开始时间'},
                        endTime:{type:'Number', desc:'结束时间'},
                        describe:{type:'String', desc:'科研描述'},
                    },
                    desc:"单位所获得科研成果表单"
                }
            ],
            bindBiz:homePageBiz.unitInfoSupplement
        },
        {
            apiName:"变更申请理由",
            subUrl:'/homepage/applyreason',
            param:[
                {key:"applyStr", type:"String", desc:"变更申请理由"}
            ],
            bindBiz:homePageBiz.applyReason
        },
    ],
    "oss授权":[
        {
            apiName:"获取oss授权必要参数",
            subUrl:'/oss/info',
            param:[
                {key:"type", type:"Number", desc:"文件上传类型"}
            ],
            bindBiz:ossBiz.getOss
        },
        
    ],
    "发送邮件":[
        {
            apiName:"发送邮件",
            subUrl:'/mail/send',
            param:[
                {key:"type", type:"Number", desc:"发送邮件类型"},
                {key:"id", type:"String", desc:"用户标识"}
            ],
            bindBiz:mailBiz.sendMail
        },
    ]
}

