

/**
 * 待审核导出列-单位会员
 */
export enum UNITAUDITINGCOLUMNS {
    入会时间 = "joinTime",
    单位名称 = "unitName",
    法人邮箱 = "legalPersonMail",
    主要负责人 = "yuanXiaoFuZeRen",
    科研负责人电话 = "yuanXiaoKeYanFuZeRenDianHua",

    省市区 = "shengshiqu",
    日常联系人 = "contactPerson",
    主要负责人职务 = "yuanXiaoFuZeRenZhiWu",
    教学负责人姓名 = "jiaoXueFuZeRenXinMing",

    通信地址 = "addres",
    日常联系人职务 = "contactPersonDuties",
    主要负责人电话 = "yuanXiaoFuZeRenDianHua",
    教学负责人电话 = "jiaoXueFuZeRenDianHua",

    单位邮箱 = "unitMail",
    日常联系人手机 = "contactPersonPhone",
    主要负责人邮箱 = "ZhuYaoFuZeRenYouXiang",
    学生总人数 = "yuanXiaoXueShengZongRenShu",

    单位信用代码 = "uscc",
    单位信息类型 = "unitMemberType",
    办公负责人 = "yuanXiaoBanGongFuZeRen",
    教职工总人数 = "yuanXiaoJiaoZhiGongZongRenShu",

    法人代表 = "legalPerson",
    办学类型 = "yuanXiaoBanXueLeiXing",
    办公负责人电话 = "yuanXiaoBanGongFuZeRenDianHua",
    开设专业 = "kaishezhuanYe",

    法人联系电话 = "legalPersonPhone",
    主管部门 = "yuanXiaoZhuGuanBuMen",
    科研负责人 = "yuanXiaoKeYanFuZeRen",
    单位简介 = "danWeiJianJie",
    
    标签 = "lableId",
    状态 = "memberState",
    届次 = "session",
    职务 = "memberLevel",
    会员职务 = "memberLevel"
}


/**
 * 待审核导出列-个人会员
 */
export enum AUDITINGCOLUMNS {
    入会时间 = "joinTime",
    姓名 = "name",
    手机号码 = "phone",
    专业类别 = "profCategory",
    性别 = "sex",
    个人邮箱 = "mail",
    民族 = "nation",
    省市区 = "shengshiqu",
    出生年月 = "birth",
    通信地址 = "addres",
    证件类型 = "documentType",
    工作单位 = "unitName",
    证件号码 = "documentId",
    职务 = "duties",
    学历 = "education",
    职称 = "workTitle",
    标签 = "lableId",
    状态 = "memberState",
    届次 = "session",
    会员职务 = "memberLevel",
    会员级别 = "individualMemberType"
}


/**
 * 费用核对导出列-发票管理
 */
export enum CONFIRMRECEIPTCOLUMNS {
    状态 = "confirmReceipt",
    "单位/个人名称" = "name",
    会员类别 = "memberCategory",
    所缴周期 = "orderCycle",
    缴费金额 = "money",
    支付单号 = "paymentNum",
    支付方式 = "paymentMethod",
    "单位代码/个人身份证" = "card",
    备注 = "desc",
    发票邮箱 = "invoiceMail",
    "单位/个人邮箱" = "mail",
    提交时间 = "operationTime", //上传转账凭证的时间
    会员职务 = "memberLevel",  
    注册手机号="phone",
    届次 = "session",
    支付时间 = "payTime", //微信支付的时间
}


/**
 * 待开发票导出列-发票管理
 */
export enum BILLSTATECOLUMNS {
    "单位/个人名称" = "name",
    会员类别 = "memberCategory",
    所缴周期 = "orderCycle",
    缴费金额 = "money",
    支付单号 = "paymentNum",
    支付方式 = "paymentMethod",
    "单位代码/个人身份证" = "card",
    备注 = "desc",
    发票邮箱 = "invoiceMail",
    "单位/个人邮箱" = "mail",
    审核时间 = "confirmReceiptMs", //什么时候从费用核对通过审核时间
    提交时间 = "operationTime", //上传转账凭证的时间
    支付时间 = "payTime", //微信支付的时间
    会员职务 = "memberLevel",  
    注册手机号="phone"
}


/**
 * 已开发票导出列-发票管理
 */
export enum INVOICEDCOLUMNS {
    "单位/个人名称" = "name",
    会员类别 = "memberCategory",
    所缴周期 = "orderCycle",
    缴费金额 = "money",
    支付单号 = "paymentNum",
    支付方式 = "paymentMethod",
    "单位代码/个人身份证" = "card",
    备注 = "desc",
    发票邮箱 = "invoiceMail",
    "单位/个人邮箱" = "mail",
    审核时间 = "confirmReceiptMs", //什么时候从费用核对通过审核时间
    提交时间 = "operationTime", //上传转账凭证的时间
    支付时间 = "payTime", //微信支付的时间
    会员职务 = "memberLevel",  
    注册手机号="phone"
}


/**
 * 退款列表导出列-发票管理
 * Refund
 */
export enum REFUNDCOLUMNS {
    "退款状态" = "state",
    会员类别 = "memberCategory",
    "单位/个人名称" = "name",
    所缴周期 = "orderCycle",
    退款金额 = "money",
    退款账号 = "refundBankCarId",
    开户行 = "refundBankName",
    会员职务 = "memberLevel",  
    注册手机号="phone"
}


//会费管理-未缴费
export enum MEMBERFEESDCOLUMNS {
    状态 = "memberState",
    会员类别 = "memberType",
    注册手机号 ="phone",
    "单位代码/身份证"="code",
    "单位/个人名称" = "name" ,
    会员职务 = "memberLevel",
    入会时间 = "joinTime",
    缴费金额 = "Money",
    "欠费具体年份" = "duration",
    "届次" = "session"
}


//会费管理-已缴费、缴费期
export enum MEMBERPAYMENTCOLUMNS {
    状态 = "memberState",
    会员类别 = "memberType",
    注册手机号 ="phone",
    "单位代码/身份证"="code",
    "单位/个人名称" = "name" ,
    会员职务 = "memberLevel",
    入会时间 = "joinTime",
    缴费金额 = "Money",
    缴费年限 = "paymentYear",
    欠费具体年份 = "duration",
    欠费年限 = "durationYear",
     "届次" = "session",
    缴费具体年份 = "jiaofeijutinianfen"
}



/**
 * 邮件类型
 */
export enum MAILTYPE {
    会员会费到期缴费通知 = 6,
    会员催缴通知提前开发票 = 7,
    会员活动or会议通知 = 12
}

