/**
 * 校验枚举工具
 * 
 */

import { ERRORENUM } from "../config/errorEnum";
import { BizError } from "./bizError";


/**
 * 校验value是否符合传入的枚举
 * @param name 被调用名称 用于输出异常日志
 * @param key 目标字段  用于输出异常日志
 * @param enumConf 目标枚举
 * @param value 目标值
 * 无返回 有异常直接报错
 */
export function eccEnumValue(name:string, key:string, enumConf, value:any) {
    let eccSuccess = true;
    if ( typeof value == 'number' ) {
        if (!enumConf[value] ) eccSuccess = false;
    } else if (Array.isArray(value)) {
        value.forEach(item => {
            if ( !enumConf[item] ) eccSuccess = false;
        });
    }
    
    if (!eccSuccess) throw new BizError(ERRORENUM.请完善信息, `${name} 下的 ${key} 字段值为 ${value} 不满足枚举范围`);
}


/**
 * 将枚举值转换成对应的枚举名(key)
 * @param enumConf 目标枚举
 * @param value 目标值
 * @returns string  返回字符串 如果传入多个枚举值，就拼接字符串
 */
export function changeEnumValue(enumConf, value:any) {
    if (!value) return '';
    if ( typeof value == 'number' ) {
        let str = enumConf[value];
        /** 特化处理 中文引号在枚举中不适用*/
        return str
    }
    let str = "";
    value.forEach((item, index) => {
        let subStr = enumConf[item];
        /** 特化处理 中文引号在枚举中不适用*/
        str += subStr;
        if (index == value.length-1) str+="";
        else str += ","
    });

    return str;
}