/**
 * 学会概括
 */

import { addOneData } from "../../../data/add";
import { deleteOneData } from "../../../data/delete";
import { TABLEENUM } from "../../../data/models/model";
import { findOnce } from "../../../data/select";
import { updateOneData } from "../../../data/update";
import { generateSystemId, successResult } from "../../../tools/system";
import { extractData } from "../../../util/piecemeal";

export async function info(userId:string) {
    let dbInfo = await findOnce(TABLEENUM.学会概括, {});
    if (!dbInfo || !dbInfo.id) {
        dbInfo = JSON.parse(JSON.stringify({
            id:generateSystemId(TABLEENUM.学会概括, userId),
            title:'',
            desc:'',
            imgList:[],
            ut:new Date().valueOf()
        }));
        await addOneData(TABLEENUM.学会概括, dbInfo);
    }
    let dataInfo = extractData(dbInfo, ["title", "desc", "imgList"]);
    return {dataInfo};
}

/**
 * 修改
 * @param secureArgs 
 * @returns 
 */
export async function update(userId:string, desc:string, title:string, imgList) {
    await updateOneData(TABLEENUM.学会概括, {}, {desc, title, imgList});
    return successResult();
}

