import * as enumConfig from '../../config/enum';

function setEnumInterface(enumConfig) {
    let dataList = [];
    for (let key in enumConfig) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            let value = enumConfig[key];
            if(/_dou/.test(keyStr)) keyStr = keyStr.replace(/_dou/, "，");
            if(/_zyh/.test(keyStr)) keyStr = keyStr.replace(/_zyh/, "“");
            if(/_yyh/.test(keyStr)) keyStr = keyStr.replace(/_yyh/, "”");
            if(/_dun/.test(keyStr)) keyStr = keyStr.replace(/_dun/, "、");
            if(/_ju/.test(keyStr)) keyStr = keyStr.replace(/_ju/, "。");
            if(/_hgh/.test(keyStr)) keyStr = keyStr.replace(/_hgh/, "-");
            if(/_kbh/.test(keyStr)) keyStr = keyStr.replace(/_kbh/, "");
            dataList.push({key:keyStr, value});
        }
    }
    return {dataList};
}

export const FirstName = '公共接口';
export const FirstRouter = '/public';
export const Config = {
    "下拉框数据":[
        {
            apiName:"性别",
            subUrl:'/sex', 
            param:[],
            bindBiz:setEnumInterface(enumConfig.SEX)
        },
        {
            apiName:"会员类型",
            subUrl:'/membertype', 
            param:[],
            bindBiz:setEnumInterface(enumConfig.MEMBERTYPE)
        },
        {
            apiName:"专业类别",
            subUrl:'/profcategory', 
            param:[],
            bindBiz:setEnumInterface(enumConfig.PROFCATEGORY)
        },
        {
            apiName:"内容管理banner位置",
            subUrl:'/position', 
            param:[],
            bindBiz:setEnumInterface(enumConfig.BANNERPOSITION)
        },
        {
            apiName:"内容管理文章位置",
            subUrl:'/articleposition', 
            param:[],
            bindBiz:setEnumInterface(enumConfig.ARTICLEPOSITION)//
        },
        {
            apiName:"内容管理视频位置",
            subUrl:'/videoposition', 
            param:[],
            bindBiz:setEnumInterface(enumConfig.VIDEOPOSITION)
        },
        {
            apiName:"年筛选",
            subUrl:'/years',
            param:[],
            bindBiz:setEnumInterface(enumConfig.YEARENUM)
        },
        {
            apiName:"作品类型",
            subUrl:'/typeofworks', 
            param:[],
            bindBiz:setEnumInterface(enumConfig.TYPEOFWORKS)
        },
        {
            apiName:"参会人员",
            subUrl:'/codparticipant', 
            param:[],
            bindBiz:setEnumInterface(enumConfig.CODPARTICIPANT)
        },
        {
            apiName:"分委会职务",
            subUrl:'/branchposition', 
            param:[],
            bindBiz:setEnumInterface(enumConfig.BRANCHPOSITION)
        },
        {
            apiName:"下载专区分类",
            subUrl:'/dwtype', 
            param:[],
            bindBiz:setEnumInterface(enumConfig.DWTYPE)
        },
        {
            apiName:"民族",
            subUrl:'/nation', 
            param:[],
            bindBiz:setEnumInterface(enumConfig.NATION)
        },
        {
            apiName:"证件类型",
            subUrl:'/documenttype', 
            param:[],
            bindBiz:setEnumInterface(enumConfig.DOCUMENTTYPE)
        },
        {
            apiName:"单位信息类型",
            subUrl:'/unitinfotype', 
            param:[],
            bindBiz:setEnumInterface(enumConfig.UNITINFOTYPE)
        },
        {
            apiName:"动态资讯类型列表",
            subUrl:'/dongtaizixuntype', 
            param:[],
            bindBiz:zhengCeZiXunLeiXing()
        },
        {
            apiName:"通知公告类型",
            subUrl:'/tongzhigonggaotype', 
            param:[],
            bindBiz:setEnumInterface(enumConfig.TONGZHIGONGGAO)
        },
        {
            apiName:"验证码类型",
            subUrl:'/codetype', 
            param:[],
            bindBiz:setEnumInterface(enumConfig.CODETYPE)
        },
    ],
}

function zhengCeZiXunLeiXing() {
    let conf = {};
    conf[enumConfig.DONGTAIZIXUNSUBTYPE.政策动向] = "Policy Tendence";
    conf[enumConfig.DONGTAIZIXUNSUBTYPE.学会动态] = "Assoclation dynamics";
    conf[enumConfig.DONGTAIZIXUNSUBTYPE.行业风采] = "Industry style";
    let dataList = [];
    for (let key in enumConfig.DONGTAIZIXUNSUBTYPE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            let value = enumConfig.DONGTAIZIXUNSUBTYPE[key];
            dataList.push({key:keyStr, value, keyEng:conf[value]});
        }
    }
    return {dataList}
}

async function 文件位置() {
    let dataList = [];
    for (let key in enumConfig.ARTICLEPOSITION) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            let value = enumConfig.ARTICLEPOSITION[key];
            // dataList.push({key:keyStr, value, keyEng:conf[value]});
        }
    }

}