import * as userBiz from "../../biz/member/user";
import * as memberBiz from "../../biz/member/member";

export const FirstName = '会员管理路由';
export const FirstRouter = '/manage/member';
export const Config = {
    "用户注册":[
        {
            apiName:"个人会员注册",
            subUrl:'/signin/entity', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        loginId:{ type:'String', desc:"用户名"},
                        pwd:{ type:'String', desc:"密码"},
                        confirmation:{type:'String', desc:"确认密码"},
                        phone:{type:'String', desc:"电话"},
                        mail:{type:'String', desc:"邮件"},
                        name:{type:'String', desc:"真实姓名"},
                        sex:{type:'Number', desc:"性别"},
                        documentType:{type:'Number', desc:"证件类型"},
                        documentId:{type:'String', desc:"证件id"},
                        birth:{type:'Number', desc:"出生年月 时间戳"},
                        nation:{type:'Number', desc:"民族"},
                        sheng:{type:'String', desc:"省"},
                        shi:{type:'String', desc:"市"},
                        qu:{type:'String', desc:"区"},
                        addres:{type:'String', desc:"通信地址"},
                        photoUrl:{type:'String', desc:"证件照图片地址"},
                        workUnit:{type:'String', desc:"工作单位"},
                        workDuties:{type:'String', desc:"职务"},
                        workTitle:{type:'String', desc:"职称"},
                        profCategory:{type:'Number', desc:"专业类别"},
                        studyResume:{type:'String', desc:"学习简历"},
                        workResume:{type:'String', desc:"工作简历"},
                        profAchievement:{type:'String', desc:"专业成果"},
                        otherEMP:{type:'String', desc:"其他任职情况"},
                        otherPROF:{type:'String', desc:"其他专业情况"},
                        cardUrl:{type:'[String]', desc:"身份证正反面图片地址"},
                        academicCERTUrl:{type:'String', desc:"学历证明地址"},
                        professionalCERTUrl:{type:'String', desc:"工作证明"},
                        auxiliaryMaterial:{type:'[String]', desc:"其他辅助材料上传地址"},
                    },
                    desc:"表单"
                }
            ],
            bindBiz:userBiz.signInOfEntity
        },
        {
            apiName:"单位会员注册",
            subUrl:'/signin/unit', 
            param:[
                {key:"form", type:"Object", sub:
                    {
                        loginId:{ type:'String', desc:"用户名"},
                        pwd:{ type:'String', desc:"密码"},
                        confirmation:{type:'String', desc:"确认密码"},
                        phone:{type:'String', desc:"电话"},
                        mail:{type:'String', desc:"邮件"},
                        unitName:{type:'String', desc:"单位名称"},
                        officialWebsite:{type:'String', desc:"官网"},
                        uscc:{type:'String', desc:"统一信用代码"},
                        legalPerson:{type:'String', desc:"法人"},
                        legalPersonPhone:{type:'String', desc:"法人代表联系电话"},
                        gongZhongHao:{type:'String', desc:"单位公众号"},
                        unitPhone:{type:'Number', desc:"单位电话"},
                        contactPerson:{type:'String', desc:"日常联系人"},
                        contactPersonDuties:{type:'String', desc:"日常联系人职务"},
                        uusinessLicenseUrl:{type:'String', desc:"营业执照"},
                        personInChargeDesc:{type:'String', desc:"单位主要负责人或负责人集体描述"},
                        unitInfoType:{type:'Number', desc:"单位信息类型 公用接口中获取"},
                        yuanXiaoBanXueLeiXing:{type:'String', desc:"院校办学类型"},
                        yuanXiaoZhuGuanBuMen:{type:'String', desc:"院校主管部门"},
                        yuanXiaoFuZeRen:{type:'String', desc:"院校主要负责人"},
                        yuanXiaoFuZeRenZhiWu:{type:'String', desc:"院校主要负责人职务"},
                        yuanXiaoFuZeRenDianHua:{type:'String', desc:"院校主要负责人电话"},
                        yuanXiaoBanGongFuZeRen:{type:'String', desc:"院校办公负责人"},
                        yuanXiaoBanGongFuZeRenZhiWu:{type:'String', desc:"院校办公负责人职务"},
                        yuanXiaoBanGongFuZeRenDianHua:{type:'String', desc:"院校办公负责人电话"},
                        yuanXiaoKeYanFuZeRen:{type:'String', desc:"院校办公负责人"},
                        yuanXiaoKeYanFuZeRenZhiWu:{type:'String', desc:"院校办公负责人职务"},
                        yuanXiaoKeYanFuZeRenDianHua:{type:'String', desc:"院校办公负责人电话"},
                        yuanXiaoXueShengZongRenShu:{type:'String', desc:"学生总人数"},
                        yuanXiaoJiaoZhiGongZongRenShu:{type:'String', desc:"教职工总人数"},
                        yuanXiaoJianZhuMianJi:{type:'String', desc:"院校建筑面积"},
                        yuanXiaoGaoJiZhiCheng:{type:'String', desc:"院校职称"},
                        yuanXiaoKaiSheZhuanYe:{type:'String', desc:"院校开设专业数"}
                    },
                    desc:"表单"
                }
            ],
            bindBiz:userBiz.singInOfUnit
        }
    ],
    "登陆相关":[
        {
            apiName:"登陆",
            subUrl:'/login', 
            param:[
                {key:"lolginId", type:"String", desc:"账号"},
                {key:"pwd", type:"String", desc:"密码"}
            ],
            bindBiz:userBiz.login
        },
        {
            apiName:"注销登陆",
            subUrl:'/logout',
            param:[
            ],
            bindBiz:userBiz.logout
        },
    ],
    "会员库":[
        {
            apiName:"单位会员列表",
            subUrl:'/memberdb/unitmemberlist',//路径全小写 
            param:[
                {key:"unitName", type:"String", desc:"单位名称", isNull:true},
                {key:"joinTime", type:"Number", desc:"入会时间", isNull:true},
                {key:"unitMemberType", type:"Number", desc:"单位会员类型", isNull:true},
                {key:"workDuties", type:"String", desc:"职务", isNull:true},
                {key:"session", type:"String", desc:"届次", isNull:true}, //todo
                {key:"sheng", type:"String", desc:"省", isNull:true},
                {key:"shi", type:"String", desc:"市", isNull:true},
                {key:"qu", type:"String", desc:"区", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:memberBiz.unitMemberList
        },
        {
            apiName:"个人会员列表",
            subUrl:'/memberdb/individualmemberlist',
            param:[
                {key:"name", type:"String", desc:"姓名", isNull:true},
                {key:"documentId", type:"String", desc:"身份证", isNull:true},
                {key:"phone", type:"String", desc:"手机号", isNull:true},
                {key:"memberLevel", type:"Number", desc:"会员等级", isNull:true},
                {key:"workDuties", type:"String", desc:"职务", isNull:true},
                {key:"session", type:"String", desc:"届次", isNull:true},
                {key:"joinTime", type:"Number", desc:"入会时间", isNull:true},
                {key:"auditTime", type:"Number", desc:"审核时间", isNull:true},
                {key:"memberState", type:"Number", desc:"状态", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:memberBiz.individualMemberList
        },
        {
            apiName:"单位会员详情",
            subUrl:'/memberdb/unitmemberdetails',
            param:[
                {key:"userId", type:"String", desc:"用户id"}
            ],
            bindBiz:memberBiz.unitMemberDetails
        },
        {
            apiName:"个人会员详情",
            subUrl:'/memberdb/individualmemberdetails',
            param:[
                {key:"userId", type:"String", desc:"用户id"}
            ],
            bindBiz:memberBiz.individualMemberDetails
        },
        {
            apiName:"删除单位所获得科研成果",
            subUrl:'/memberdb/delresearch',
            param:[
                {key:"id", type:"String", desc:"单位会员列表下发的标识"}
            ],
            bindBiz:memberBiz.delResearch
        },
        {
            apiName:"单位会员修改",
            subUrl:'/memberdb/unitmemberupdate',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        /**基本信息 */
                        unitName:{type:'String', desc:'单位名称'},
                        addres:{type:'String', desc:'通信地址'},
                        officialWebsite:{type:'String', desc:'单位网站'},
                        uscc:{type:'String', desc:'单位信用代码'},
                        legalPerson:{type:'String', desc:'法人代表'},
                        legalPersonPhone:{type:'String', desc:'法人联系电话'},
                        gongZhongHao:{type:'String', desc:'单位公众号'},
                        unitPhone:{type:'Number', desc:'单位电话'},
                        contactPerson:{type:'String', desc:'日常联系人'},
                        contactPersonDuties:{type:'String', desc:'日常联系人职务'},
                        sheng:{type:'String', desc:'省'},
                        shi:{type:'String', desc:'市'},
                        qu:{type:'String', desc:'区'},
                        uusinessLicenseUrl:{type:'String', desc:'营业执照'},
                        personInChargeDesc:{type:'String', desc:'单位主要负责人或集体简介'},
                        /**单位信息 */
                        unitInfoType:{type:'Number', desc:'单位信息类型'},
                        yuanXiaoBanXueLeiXing:{type:'String', desc:'院校办学类型'},
                        yuanXiaoZhuGuanBuMen:{type:'String', desc:'院校主管部门'},
                        yuanXiaoFuZeRen:{type:'String', desc:'院校主要负责人'},
                        yuanXiaoFuZeRenZhiWu:{type:'String', desc:'院校主要负责人职位'},
                        yuanXiaoFuZeRenDianHua:{type:'String', desc:'院校主要负责人电话'},
                        yuanXiaoBanGongFuZeRen:{type:'String', desc:'院校办公负责人'},
                        yuanXiaoBanGongFuZeRenZhiWu:{type:'String', desc:'院校办公负责人职位'},
                        yuanXiaoBanGongFuZeRenDianHua:{type:'String', desc:'院校办公负责人电话'},
                        yuanXiaoKeYanFuZeRen:{type:'String', desc:'院校科研负责人'},
                        yuanXiaoKeYanFuZeRenZhiWu:{type:'String', desc:'院校科研负责人职位'},
                        yuanXiaoKeYanFuZeRenDianHua:{type:'String', desc:'院校科研负责人电话'},
                        yuanXiaoXueShengZongRenShu:{type:'String', desc:'院校学生总数'},
                        yuanXiaoJiaoZhiGongZongRenShu:{type:'String', desc:'院校教职工总人数'},
                        yuanXiaoJianZhuMianJi:{type:'String', desc:'院校建筑总面积'},
                        yuanXiaoGaoJiZhiCheng:{type:'String', desc:'院校高级职称人数'},
                        yuanXiaoKaiSheZhuanYe:{type:'String', desc:'院校专业总数'},
                    },
                    desc:"表单"
                },
                {
                    key:"keyanForm", type:"Object", sub:
                    {
                        startTime:{type:'Number', desc:'开始时间'},
                        endTime:{type:'Number', desc:'结束时间'},
                        describe:{type:'String', desc:'科研描述'},
                    },
                    desc:"单位所获得科研成果表单"
                },
                {
                    key:"userId", type:"String", desc:"用户id"
                }
            ],
            bindBiz:memberBiz.unitMemberUpdate
        },
        {
            apiName:"个人会员修改",
            subUrl:'',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        /**基本信息 */
                        name:{type:'String', desc:'真实姓名'},
                        sex:{type:'Number', desc:'性别'},
                        nation:{type:'Number', desc:'民族'},
                        birth:{type:'Number', desc:'出身年月'},
                        documentType:{type:'Number', desc:'证件类型'},
                        documentId:{type:'String', desc:'证件号码'},
                        sheng:{type:'String', desc:'省'},
                        shi:{type:'String', desc:'市'},
                        qu:{type:'String', desc:'区'},
                        addres:{type:'String', desc:'通信地址'},
                        photoUrl:{type:'String', desc:'蓝底证件照'},
                        /**专业信息 */
                        workUnit:{type:'String', desc:'工作单位'},
                        workDuties:{type:'String', desc:'职务'},
                        workTitle:{type:'String', desc:'职称'},
                        profCategory:{type:'Number', desc:'专业类别'},
                        studyResume:{type:'String', desc:'学习简历'},
                        workResume:{type:'String', desc:'工作简历'},
                        profAchievement:{type:'String', desc:'教研成果'},
                        otherEMP:{type:'String', desc:'其他组织任职情况'},
                        otherPROF:{type:'String', desc:'其他情况'},
                        /**其他附件 */
                        cardUrl:{type:'[String]', desc:'个人身份扫描件'},
                        academicCERTUrl:{type:'String', desc:'个人学历证明扫描件'},
                        professionalCERTUrl:{type:'String', desc:'个人工作证明扫描件'},
                        auxiliaryMaterial:{type:'[String]', desc:'论文发表或成绩材料'},
                    }
                },
                {
                    key:"userId", type:"String", desc:"用户id"
                }
            ],
            bindBiz:memberBiz.individualMemberUpdate
        },
        {
            apiName:"发送短信验证码",
            subUrl:'/memberdb/registersendcode',
            param:[
                {key:"loginId", type:"String", desc:"用户名"},
                {key:"phone", type:"String", desc:"联系人手机号"},
                {key:"codeType", type:"Number", desc:"验证码类型枚举"}
            ],
            bindBiz:memberBiz.memberRegisterSendCode
        },
        {
            apiName:"个人入会流程1",
            subUrl:'/memberdb/memberregister1',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        loginId:{type:'String', desc:'用户名'},
                        mail:{type:'String', desc:'邮箱'},
                        pwd:{type:'String', desc:'密码'},
                        confirmation:{type:'String', desc:'确认密码'},
                        phone:{type:'String', desc:'联系人手机号'},
                        codeNum:{type:'String', desc:'验证码'},
                    }
                },
                {key:"codeId", type:"String", desc:"验证码Id"}
            ],
            bindBiz:memberBiz.memberRegister1
        },
        {
            apiName:"个人入会流程2",
            subUrl:'/memberdb/memberregister2',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        name:{type:'String', desc:'真实姓名'},
                        sex:{type:'Number', desc:'性别'},
                        documentType:{type:'Number', desc:'证件类型'},
                        documentId:{type:'String', desc:'证件号码'},
                        birth:{type:'Number', desc:'出生年月'},
                        nation:{type:'Number', desc:'民族'},
                        sheng:{type:'String', desc:'省'},
                        shi:{type:'String', desc:'市'},
                        qu:{type:'String', desc:'区'},
                        addres:{type:'String', desc:'通信地址'},
                        photoUrl:{type:'String', desc:'蓝底证件照'},
                        workUnit:{type:'String', desc:'工作单位'},
                        workDuties:{type:'String', desc:'职务'},
                        workTitle:{type:'String', desc:'职称'},
                        profCategory:{type:'Number', desc:'专业类别'},
                        studyResume:{type:'String', desc:'学习简历'},
                        workResume:{type:'String', desc:'工作简历'},
                        profAchievement:{type:'String', desc:'专业成果'},
                        otherEMP:{type:'String', desc:'在其他社会组织任职情况'},
                        otherPROF:{type:'String', desc:'其他与本学会专业有关的情况'},
                        cardUrl:{type:'[String]', desc:'个人身份证扫描件'},
                        academicCERTUrl:{type:'String', desc:'个人学历证明扫描件'},
                        professionalCERTUrl:{type:'String', desc:'个人工作证明扫描件'},
                        auxiliaryMaterial:{type:'[String]', desc:'论文发表等证明工作成果或成绩的材料'},
                    }
                },
                {
                    key:"userId", type:"String", desc:"用户id"
                }
            ],
            bindBiz:memberBiz.memberRegister2
        },
        {
            apiName:"单位入会流程1",
            subUrl:'/memberdb/unitmemberregister1',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        loginId:{type:'String', desc:'用户名'},
                        mail:{type:'String', desc:'邮箱'},
                        pwd:{type:'String', desc:'密码'},
                        confirmation:{type:'String', desc:'确认密码'},
                        phone:{type:'String', desc:'联系人手机号'},
                        codeNum:{type:'String', desc:'验证码'},
                    }
                },
                {key:"codeId", type:"String", desc:"验证码Id"}
            ],
            bindBiz:memberBiz.unitMemberRegister1
        },
        {
            apiName:"单位入会流程2",
            subUrl:'/memberdb/unitmemberregister2',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        unitName:{type:'String', desc:'单位名称'},
                        addres:{type:'String', desc:'通信地址'},
                        officialWebsite:{type:'String', desc:'单位网站'},
                        uscc:{type:'String', desc:'单位信用代码'},
                        legalPerson:{type:'String', desc:'法人代表'},
                        legalPersonPhone:{type:'String', desc:'法人联系电话'},
                        sheng:{type:'String', desc:'省'},
                        shi:{type:'String', desc:'市'},
                        qu:{type:'String', desc:'区'},
                        gongZhongHao:{type:'String', desc:'单位公众号'},
                        unitPhone:{type:'String', desc:'单位电话'},
                        contactPerson:{type:'String', desc:'日常联系人'},
                        contactPersonDuties:{type:'String', desc:'日常联系人职务'},
                        uusinessLicenseUrl:{type:'String', desc:'营业执照复印件'},
                        personInChargeDesc:{type:'String', desc:'单位主要负责人简介'},
                        /**单位信息 */
                        unitInfoType:{type:'Number', desc:'单位信息类型'},
                        yuanXiaoBanXueLeiXing:{type:'String', desc:'院校办学类型'},
                        yuanXiaoZhuGuanBuMen:{type:'String', desc:'院校主管部门'},
                        yuanXiaoFuZeRen:{type:'String', desc:'院校主要负责人'},
                        yuanXiaoFuZeRenZhiWu:{type:'String', desc:'院校主要负责人职务'},
                        yuanXiaoFuZeRenDianHua:{type:'String', desc:'院校主要负责人电话'},
                        yuanXiaoBanGongFuZeRen:{type:'String', desc:'院校办公负责人'},
                        yuanXiaoBanGongFuZeRenZhiWu:{type:'String', desc:'院校办公负责人职务'},
                        yuanXiaoBanGongFuZeRenDianHua:{type:'String', desc:'院校办公负责人电话'},
                        yuanXiaoKeYanFuZeRen:{type:'String', desc:'院校科研负责人'},
                        yuanXiaoKeYanFuZeRenZhiWu:{type:'String', desc:'院校科研负责人职务'},
                        yuanXiaoKeYanFuZeRenDianHua:{type:'String', desc:'院校科研负责人电话'},
                        yuanXiaoXueShengZongRenShu:{type:'String', desc:'院校学生总人数'},
                        yuanXiaoJiaoZhiGongZongRenShu:{type:'String', desc:'院校教职工总人数'},
                        yuanXiaoJianZhuMianJi:{type:'String', desc:'院校建筑总面积'},
                        yuanXiaoGaoJiZhiCheng:{type:'String', desc:'院校高级职称人数'},
                        yuanXiaoKaiSheZhuanYe:{type:'String', desc:'院校开设专业'},
                    }
                },
                {
                    key:"keyanForm", type:"Object", sub:
                    {
                        startTime:{type:'Number', desc:'开始时间'},
                        endTime:{type:'Number', desc:'结束时间'},
                        describe:{type:'String', desc:'科研描述'},
                    },
                    desc:"单位所获得科研成果表单"
                },
                {
                    key:"userId", type:"String", desc:"用户id"
                }
            ],
            bindBiz:memberBiz.unitMemberRegister2
        }
    ]
}

