import { dataModels } from "./models/modelInit";



export async function findToPage(tableEnumValue:string, param:object, files:object, pageNumber:number, pageSize?) {
    pageSize = pageSize || 10;//默认每页10个
    
    let data = await dataModels[tableEnumValue].find(param, files).skip((pageNumber - 1) *pageSize).limit(pageSize);
    
    return data;
}

export async function findCount(tableEnumValue:string, param:object) {
    let data = await dataModels[tableEnumValue].findCount(param);
    return data;
}

export async function findOnce(tableEnumValue:string, param:object, files?) {
    let data = await dataModels[tableEnumValue].findOne(param, files);
    return data;
}

export async function find(tableEnumValue:string, param, files?) {
    files = files || [];
    let data = await dataModels[tableEnumValue].find(param, files);
    return data;
}