/**
 * 学会领导
 * 排序，后一个排序会与修改前的排序互换
 */

import { ERRORENUM } from "../../../config/errorEnum";
import { addOneData } from "../../../data/add";
import { deleteOneData } from "../../../data/delete";
import { TABLEENUM } from "../../../data/models/model";
import { find, findCount, findOnce, findToPage } from "../../../data/select";
import { updateOneData } from "../../../data/update";
import { generateSystemId, successResult } from "../../../tools/system";
import { BizError } from "../../../util/bizError";
import { extractData } from "../../../util/piecemeal";


/**
 * 创建学会领导
 * @param userId 
 * @param param 
 * @returns 
 */
export async function create(secureArgs) {
    let {userId, form} = secureArgs;
    let oldRankInfo = await findOnce(TABLEENUM.学会领导, {rank:form.rank});
    if(oldRankInfo && oldRankInfo.id) {
        /**存在原来的排名，将上一个去掉 */
        await deleteOneData(TABLEENUM.学会领导, {id:oldRankInfo.id});
    }
    form.id = generateSystemId(TABLEENUM.学会领导, userId);
    await addOneData(TABLEENUM.学会领导, form);

    return successResult();
}


/**
 * 修改
 * @param userId 
 * @param id 
 * @param updateParam 
 * @returns 
 */
export async function update(secureArgs:any) {
    let {userId, id, form} = secureArgs;
    let oldInfo = await findOnce(TABLEENUM.学会领导, {id});
    if (!oldInfo || !oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);
    if (oldInfo.rank != form.rank) {
        //排名发生变化
        let oldRankInfo = await findOnce(TABLEENUM.学会领导, {rank:form.rank});
        if (oldRankInfo) {
            await updateOneData(TABLEENUM.学会领导, {id:oldRankInfo.id}, {rank:oldInfo.rank});
        }
        
    }
    await updateOneData(TABLEENUM.学会领导, {id}, form);
    return successResult();
}


export async function del(secureArgs:any) {
    let {userId, id} = secureArgs;
    let dataInfo = await findOnce(TABLEENUM.学会领导, {id});
    if (!dataInfo.id) throw new BizError(ERRORENUM.目标数据不存在);
    await deleteOneData(TABLEENUM.学会领导, {id});
    return successResult();
}


export async function list({pageNumber}) {
    let dbList = await findToPage(TABLEENUM.学会领导, {}, ["id", "rank", "name", "position", "desc"], pageNumber);
    let dataCount = await findCount(TABLEENUM.活动通知, {});
    let dataList = [];
    dbList.forEach(info => {
        let item = extractData(info, ["id", "rank", "name", "position", "desc"]);
        dataList.push(item);
    });

    dataList.sort((a, b) => {return a.rank - b.rank});

    return {dataList, dataCount};
}


/**
 * 预览
 * @param id 
 */
export async function preview(secureArgs:any) {
    /**获取上下3位的排名列表 */
    let dbList = await find(TABLEENUM.学会领导, {});

    let dataList = [];
    dbList.forEach(info => {
        let item = extractData(info, ["id", "rank", "name", "position", "imgUrl", "miniImgUrl", "desc"]);
        dataList.push(item);
    });

    dataList.sort((a, b) => {return a.rank - b.rank});

    return {dataList};
}


/**
 * 回显
 * @param id 
 */
export async function info(secureArgs:any) {
    let {id} = secureArgs;
    let oldInfo = await findOnce(TABLEENUM.学会领导, {id});
    let dataInfo = extractData(oldInfo, ["id", "rank", "name", "position", "imgUrl", "miniImgUrl", "desc"]);

    return { dataInfo };
}
