/**
 * 专题系列
 */

import { ARTICLEPOSITION } from "../../../config/enum";
import { ERRORENUM } from "../../../config/errorEnum";
import { addManyData } from "../../../data/add";
import { TABLEENUM } from "../../../data/models/model";
import { find, findOnce } from "../../../data/select";
import { updateOneData } from "../../../data/update";
import { generateSystemId, successResult } from "../../../tools/system";
import { BizError } from "../../../util/bizError";
import { extractData } from "../../../util/piecemeal";
import { changeEnumValue } from "../../../util/verificationEnum";

/**
 * 列表
 * @param param0 
 * @returns 
 */
export async function list({userId}) {
    let dbList = await find(TABLEENUM.专题系列, {});

    let dataList = [];
    if ( !dbList || !dbList.length) {
        let addList = [];
        for (let i = 1; i <= 5; i++) {
            let id = generateSystemId(TABLEENUM.专题系列, userId);
            addList.push({id, rank:i, title:'', articleUrl:'', position:0, articleTitle:'', ct:new Date().valueOf(), imgUrl:"" });
            dataList.push({id, rank:i, title:'', articleUrl:'', position:0, articleTitle:'', imgUrl:""});
        }
        await addManyData(TABLEENUM.专题系列, addList);
    }
    dataList.sort((a:any, b:any) => {return a.rank - b.rank });
    dbList.forEach(info => {
        let item:any = extractData(info, ["id", "title", "articleUrl", "position", "articleTitle", "imgUrl"]);
        if (!item.position) item.position = "未选择";
        else changeEnumValue(ARTICLEPOSITION, item.position);
        dataList.push(item);
    });

    return {dataList};
}


/**
 * 预览
 */
export async function preview({userId}) {
    let dbList = await find(TABLEENUM.专题系列, {});

    let dataList = [];
    if ( !dbList || !dbList.length) {
        let addList = [];
        for (let i = 1; i <= 5; i++) {
            let id = generateSystemId(TABLEENUM.专题系列, userId);
            addList.push({id, rank:i, title:'', articleUrl:'', position:0, articleTitle:'', ct:new Date().valueOf(), imgUrl:"" });
            dataList.push({id, rank:i, title:'', articleUrl:'', position:0, articleTitle:'', imgUrl:""});
        }
        await addManyData(TABLEENUM.专题系列, addList);
    }
    dataList.sort((a:any, b:any) => {return a.rank - b.rank });
    dbList.forEach(info => {
        let item = extractData(info, ["id", "title", "imgUrl"]);
        dataList.push(item);
    });

    return {dataList};
}


/**
 * 修改
 * @param userId 
 * @param id 
 * @param updateParam 
 * @returns 
 */
export async function update({userId, id, title, imgUrl, position, articleTitle, articleUrl}) {
    let oldInfo = await findOnce(TABLEENUM.专题系列, {id});
    if (!oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);
    
    await updateOneData(TABLEENUM.专题系列, {id}, {title, imgUrl, articleUrl, position, articleTitle});
    return successResult();
}


export async function del({userId, id}) {
    let dataInfo = await findOnce(TABLEENUM.专题系列, {id});
    if (!dataInfo.id) throw new BizError(ERRORENUM.目标数据不存在);

    await updateOneData(TABLEENUM.专题系列, {id}, {title:'', imgUrl:'', articleUrl:''});
    return successResult();
}

/**
 * 回显
 * @param id 
 */
export async function info({id}) {
    let oldInfo = await findOnce(TABLEENUM.专题系列, {id});
    let dataInfo = extractData(oldInfo, ["id", "title", "imgUrl","position", "articleTitle"]);

    return { dataInfo };
}
