/**
 * 订单相关
 */
import moment = require("moment");
import { COSTTYPE, INVOICESTATUS, ISPAYENUM, MEMBERLEVEL, MEMBERTYPE, ORDERSTATE, PAYMENTTYPE } from "../../config/enum";
import { generateOrderId } from "../../tools/system";
import { changeEnumValue, eccEnumValue } from "../../util/verificationEnum";
import { addOneData } from "../../data/add";
import { TABLEENUM } from "../../data/models/model";
import { findCount, findToPage } from "../../data/select";
import { extractData } from "../../util/piecemeal";


/**
 * 对内使用  创建一条订单
 * @param userId 会员id
 * @param unitName 单位名称
 * @param orderStartMs 订单开始时间
 * @param memberLv 会员等级 MEMBERLEVEL
 * @param memberType 会员类型 MEMBERTYPE
 * @param isFirst 是否首次缴费
 * @returns 
 */
export async function createOrder(userId:string, unitName:string, orderStartMs:number, memberLv:number, memberType:number, isFirst:boolean) {
    /**计算订单周期 */
    const EndMs = moment(orderStartMs).add(1, 'years').valueOf();
    /**订单id */
    const OrderId = generateOrderId(userId);
    /**计算会费 */
    let money = 0;
    if (memberLv == MEMBERLEVEL.专家会员) {

    } else {

    }
    let addInfo = {
        id:OrderId,
        orderCycleStart:orderStartMs,
        orderCycleEnd:EndMs,
        unitName,
        money,
        paymentMethod:0,
        memberId:userId,
        memberCategory:memberType,
        paymentNum:0,
        invoiceAdd:'',
        state:ORDERSTATE.未支付,
        isFirst
    };

    // await addOneData(TABLEENUM.订单表, addInfo);
    return true;
}


/**
 * 初始订单
 */
export async function firstOrderList({unitName, joinTime, memberType, orderState, pageNumber}) {
    let findParam:any = { isFirst:true };
    if (unitName) findParam.unitName = {"$regex":unitName};
    if (memberType) findParam.memberCategory = memberType;
    if (orderState) findParam.state = orderState;

    let selectFile = ["unitName", "loginId", "phone", "orderCycleStart", "orderCycleEnd", "memberCategory", "state"];
    let dbList = await findToPage(TABLEENUM.订单表, findParam, selectFile, pageNumber);
    let dataCount = await findCount(TABLEENUM.订单表, findParam);
    let dataList = [];
    let itemFile = ["unitName", "loginId", "phone"];
    dbList.forEach(info =>  {
        let itemData:any = extractData(info, itemFile);
        itemData.joinTime = moment(info.orderCycleStart).format("YYYY-MM-DD");
        itemData.memberType = changeEnumValue(MEMBERTYPE, itemData.memberCategory);
        itemData.paymentMethod = changeEnumValue(MEMBERTYPE, itemData.paymentMethod);
        itemData.cycle = `${moment(info.orderCycleStart).format("YYYY-MM-DD")}至${moment(info.orderCycleEnd).format("YYYY-MM-DD")}`
        dataList.push(itemData);
    });

    return {dataList, dataCount}
}


/**
 * 财务核对列表
 */
export async function paidList({unitName, paymentType, costType, pageNumber }) {
    eccEnumValue("财务核对列表", "支付类型", PAYMENTTYPE, paymentType);
    eccEnumValue("财务核对列表", "会费类别", COSTTYPE, costType );

    let findParam:any = { isFirst:true };
    if (unitName) findParam.unitName = {"$regex":unitName};
    if (paymentType) findParam.paymentMethod = paymentType;
    if (costType) findParam.isFirst = costType == COSTTYPE.首次;

    let selectFile = ["id", "unitName", "orderCycleStart", "orderCycleEnd", "money", "paymentMethod", "memberCategory", "isFirst", "paymentNum" ];
    let dbList = await findToPage(TABLEENUM.订单表, findParam, selectFile, pageNumber);
    let dataCount = await findCount(TABLEENUM.订单表, findParam);

    let dataList = [];

    let itemFile = ["unitName", "money", "paymentNum"];
    dbList.forEach(info =>  {
        let itemData:any = extractData(info, itemFile);
        itemData.joinTime = moment(info.orderCycleStart).format("YYYY-MM-DD");
        itemData.memberType = changeEnumValue(MEMBERTYPE, itemData.memberCategory);
        itemData.paymentMethod = changeEnumValue(MEMBERTYPE, itemData.paymentMethod);
        itemData.costType = info.isFirst == COSTTYPE.首次 ? "首次" : "续费";
        itemData.cycle = `${moment(info.orderCycleStart).format("YYYY-MM-DD")}至${moment(info.orderCycleEnd).format("YYYY-MM-DD")}`
        dataList.push(itemData);
    });

    return {dataList, dataCount};
}


/**
 * 待开发票和已开发票
 */
export async function nonBillable({unitName, paymentType, isPay, pageNumber, invoiceStatus}) {
    eccEnumValue("发票列表", "支付类型", PAYMENTTYPE, paymentType);
    eccEnumValue("发票列表", "是否支付", ISPAYENUM, isPay );
    eccEnumValue("发票列表", "发票类型", INVOICESTATUS, invoiceStatus )

    let findParam:any = { isFirst:true };
    if (unitName) findParam.unitName = {"$regex":unitName};
    if (paymentType) findParam.paymentMethod = paymentType;
    if (isPay) findParam.state = isPay

    let selectFile = ["id", "unitName", "orderCycleStart", "orderCycleEnd", "money", "paymentMethod", "memberCategory", "state", "paymentNum" ];
    let dbList = await findToPage(TABLEENUM.订单表, findParam, selectFile, pageNumber);
    let dataCount = await findCount(TABLEENUM.订单表, findParam);

    let dataList = [];

    let itemFile = ["unitName", "money", "paymentNum"];
    dbList.forEach(info =>  {
        let itemData:any = extractData(info, itemFile);
        itemData.joinTime = moment(info.orderCycleStart).format("YYYY-MM-DD");
        itemData.memberType = changeEnumValue(MEMBERTYPE, itemData.memberCategory);
        itemData.paymentMethod = changeEnumValue(MEMBERTYPE, itemData.paymentMethod);
        itemData.cycle = `${moment(info.orderCycleStart).format("YYYY-MM-DD")}至${moment(info.orderCycleEnd).format("YYYY-MM-DD")}`
        dataList.push(itemData);
    });

    return {dataList, dataCount};
}


/**
 * 个人页待付款列表
 * @param param0 
 */
export async function 待付款列表({userId, type}) {
    let findParam:any = {};
    // if (type == )
    // let dbList = await findToPage(TABLEENUM.订单表, findParam, selectFile, pageNumber);
}