// This file is auto-generated, don't edit it

import { ERRORENUM } from "../config/errorEnum";
import { BizError } from "../util/bizError";
import { logError } from "../util/log";

// 依赖的模块可通过下载工程中的模块依赖文件或右上角的获取 SDK 依赖信息查看
const Dypnsapi20170525 = require('@alicloud/dypnsapi20170525');
const OpenApi = require('@alicloud/openapi-client');
const Util = require('@alicloud/tea-util');
const Tea = require('@alicloud/tea-typescript');


let smsClient;

export async function initSMS() {
    // 工程代码泄露可能会导致 AccessKey 泄露，并威胁账号下所有资源的安全性。以下代码示例仅供参考。
    // 建议使用更安全的 STS 方式，更多鉴权访问方式请参见：https://help.aliyun.com/document_detail/378664.html。
    let config = new OpenApi.Config({
        // 必填，请确保代码运行环境设置了环境变量 ALIBABA_CLOUD_ACCESS_KEY_ID。
        accessKeyId: 'LTAI5tD7Finu3fxFMCi3415S',
        // 必填，请确保代码运行环境设置了环境变量 ALIBABA_CLOUD_ACCESS_KEY_SECRET。
        accessKeySecret: 'sbPR0AdDPfjm7v2NSffk5apPm6UClV',
    });
    // Endpoint 请参考 https://api.aliyun.com/product/Dypnsapi
    config.endpoint = `dypnsapi.aliyuncs.com`;
    smsClient =  new Dypnsapi20170525.default(config);
}


export async function sendALSMS(code:string, phone:string ) {
    try {
        /**先生成request */
        let requstParam = new Dypnsapi20170525.SendSmsVerifyCodeRequest({
            phoneNumber: phone,
            signName: '中国艺术职业教育学会',
            templateCode: 'SMS_296230597',
            templateParam: `{"code":"${code}"}`,
            // templateParam:code
        });
        //发起调用
        let runtime = new Util.RuntimeOptions({});
        const resp = await smsClient.sendSmsVerifyCodeWithOptions(requstParam, runtime);

    } catch(err) {
        throw new BizError(ERRORENUM.短信验证码发送失败, err);
    }
}


export async function sendPassNotice(phone:string, name:string) {
    try {
        /**先生成request */
        let requstParam = new Dypnsapi20170525.SendSmsVerifyCodeRequest({
            phoneNumber: phone,
            signName: '中国艺术职业教育学会',
            templateCode: 'SMS_467160001',
            templateParam: `{"name":"${name}"}`,
            // templateParam:code
        });
        //发起调用
        let runtime = new Util.RuntimeOptions({});
        const resp = await smsClient.sendSmsVerifyCodeWithOptions(requstParam, runtime);

    } catch(err) {
        logError("发送通知短信失败", err);
        console.log("发送通知短信失败", err);
    }

}