/**
 * 视频管理
 */

import { VIDEOPOSITION } from "../../../config/enum";
import { ERRORENUM } from "../../../config/errorEnum";
import { addOneData } from "../../../data/add";
import { deleteOneData } from "../../../data/delete";
import { TABLEENUM } from "../../../data/models/model";
import { find, findCount, findOnce, findToPage } from "../../../data/select";
import { updateOneData } from "../../../data/update";
import { generateSystemId, successResult } from "../../../tools/system";
import { BizError } from "../../../util/bizError";
import { extractData } from "../../../util/piecemeal";
import { changeEnumValue } from "../../../util/verificationEnum";


/**
 * 创建文章
 * @param userId 
 * @param param 
 * @returns 
 */
export async function create(secureArgs) {
    let {userId, form} = secureArgs;
    form.ct = new Date().valueOf();
    form.id = generateSystemId(TABLEENUM.视频管理, userId);
    await addOneData(TABLEENUM.视频管理, form);

    return successResult();
}


/**
 * 修改
 * @param userId 
 * @param id 
 * @param updateParam 
 * @returns 
 */
export async function update(secureArgs:any) {
    let {userId, id, form} = secureArgs;
    let oldInfo = await findOnce(TABLEENUM.视频管理, {id});
    if (!oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);
   
    await updateOneData(TABLEENUM.视频管理, {id}, form);
    return successResult();
}


export async function del(secureArgs:any) {
    let {userId, id} = secureArgs;
    let dataInfo = await findOnce(TABLEENUM.视频管理, {id});
    if (!dataInfo.id) throw new BizError(ERRORENUM.目标数据不存在);
    await deleteOneData(TABLEENUM.视频管理, {id});
    return successResult();
}


export async function list(secureArgs:any) {
    let {userId, videoType, title, videoTime, pageNumber} = secureArgs;
    
    let selectParam:any = {};
    if (videoType) selectParam.videoType = videoType;
    if (title) selectParam.title = title;
    if (videoTime) {
        selectParam["$and"] = [
            {videoTime:{"$gt":videoTime}},
            {videoTime:{"$lt":videoTime+(24*3600*1000)}}
        ];
    }

    let dbList = await findToPage(TABLEENUM.视频管理, selectParam, ["id", "title", "videoType", "videoTime", "desc", "display"], pageNumber);
    let dataCount = await findCount(TABLEENUM.视频管理, selectParam);

    let dataList = [];
    dbList.forEach(info => {

        let item:any = extractData(info, ["id", "title", "videoType", "videoTime", "desc", "display"]);
        item.videoType = changeEnumValue(VIDEOPOSITION, item.videoType);
        dataList.push(item);
    });

    return {dataList, dataCount};
}

/**
 * 回显
 * @param id 
 */
export async function info(secureArgs:any) {
    let {id} = secureArgs;
    let oldInfo = await findOnce(TABLEENUM.视频管理, {id});
    let dataInfo = extractData(oldInfo, ["id", "title", "videoType", "videoUrl", "videoTime", "desc", "coverUrl"]);

    return { dataInfo };
}


export async function changePush({id}) {
    let oldInfo = await findOnce(TABLEENUM.视频管理, {id});
    if (!oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);

    let newPush = oldInfo.display == 1 ? 0 : 1;
    await updateOneData(TABLEENUM.视频管理, {id}, {display:newPush});

    return successResult();
}