/**
 * 主题教育
 */
import { PARTYBUILDTYPEENUM, STATE } from "../../../config/enum";
import { ERRORENUM } from "../../../config/errorEnum";
import { addManyData } from "../../../data/add";
import { TABLEENUM } from "../../../data/models/model";
import { find, findOnce } from "../../../data/select";
import { updateOneData } from "../../../data/update";
import { successResult } from "../../../tools/system";
import { BizError } from "../../../util/bizError";
import { wenZhangQueue } from "../../task";


export async function list() {
    let dbList = await find(TABLEENUM.党建, {type:PARTYBUILDTYPEENUM.主题教育});
    if (!dbList || !dbList.length) {
        let dbList = [
            {id:1000, type:PARTYBUILDTYPEENUM.主题教育, display:true, name:"类型1"},
            {id:1001, type:PARTYBUILDTYPEENUM.主题教育, display:true, name:"类型2"},
            {id:1002, type:PARTYBUILDTYPEENUM.主题教育, display:true, name:"类型3"},
            {id:1003, type:PARTYBUILDTYPEENUM.主题教育, display:true, name:"类型4"}
        ];
        await addManyData(TABLEENUM.党建, dbList);
    }
    let dataList = [];
    dbList.forEach(info => {
        let {id, name, display} = info;
        dataList.push({
            id,name,count:88, display:display == STATE.是
        });
    });

    return {dataList};
}



export async function update({userId, id, typeName}) {

    let oldInfo = await findOnce(TABLEENUM.党建, {id});
    if (!oldInfo || !oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);

    await updateOneData(TABLEENUM.党建, {id}, {name:typeName});

    /**更新缓存名字 */
    wenZhangQueue[id] = typeName;

    return successResult();
}


export async function changeState({userId, id}) {
    let oldInfo = await findOnce(TABLEENUM.党建, {id});
    if (!oldInfo || !oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);

    let newPush = oldInfo.display == 1 ? 0 : 1;
    await updateOneData(TABLEENUM.党建, {id}, {display:newPush});

    return successResult();
}