/**
 * 控制台-工作台
 */

import { COSTTYPE, INDIVIDUALMEMBERTYPE, MEMBERLEVEL, MEMBERSTATE, MEMBERTYPE, MEMBERTYPEECCENUM, ORDERSTATE, STATE, UNITMEMBERTYPE } from "../../config/enum";
import { TABLEENUM } from "../../data/models/model";
import { find, findCount } from "../../data/select";
import { extractData } from "../../util/piecemeal";


/**
 * 控制台【会员统计】
 */
export async function getDanweiCount({year}) {
    let danweiCount = await getMemberCount(year, MEMBERTYPE.单位会员);
    let geRenCount = await getMemberCount(year, MEMBERTYPE.个人会员);

    return {danweiCount, geRenCount};
}


/**
 * 通知公告
 * @returns 
 */
export async function getHuoDongTongZhiList() {

}



/**
 * 会员统计【对内使用】
 * @param year 返回入会时间小于选择年份的所有会员数据 
 * @param memberType 会员类型
 * @returns 
 */
 async function getMemberCount(year, memberType) {
    let yearMs = new Date(year + "-12-31").valueOf();
    /**会员统计数值 */
    let memberNum = await findCount(TABLEENUM.用户表, {memberType, joinTime:{"$lt":yearMs}});
    let paid = await findCount(TABLEENUM.订单表, {state:ORDERSTATE.已支付, memberCategory:memberType, joinTime:{"$lt":yearMs}});
    let renewal = await findCount(TABLEENUM.订单表, {isFirst:false, memberCategory:memberType});
    let arrearsfees = await findCount(TABLEENUM.订单表, {state:ORDERSTATE.未支付, memberCategory:memberType});
    let gracePeriod = await findCount(TABLEENUM.用户表, {memberType, isGracePeriod:STATE.是, joinTime:{"$lt":yearMs}});
    let freeze = await findCount(TABLEENUM.用户表, {memberType, memberState:MEMBERSTATE.冻结, joinTime:{"$lt":yearMs}});

    let dbList = await find(TABLEENUM.用户表, {memberType, joinTime:{"$lt":yearMs}});
    /**会员等级 */
    let memberLevelData = {};
    dbList.forEach(info => {
        for (let key in MEMBERLEVEL) {
            let anyKey:any = key;
            if (isNaN(anyKey)) {//字符
                let keyStr = key;
                let value = MEMBERLEVEL[key];
                if (info.memberLevel == value) {
                    if (!memberLevelData[keyStr]) memberLevelData[keyStr] = 0;
                    memberLevelData[keyStr] += 1;
                }
            }
        }
    })

    /**会员类型 */
    let memberTypeData = {};
    dbList.forEach(info => {
        /**判断会员类型选择对应枚举统计个数 */
        if(memberType == MEMBERTYPE.个人会员) {
            for (let key in INDIVIDUALMEMBERTYPE) {
                let anyKey:any = key;
                if (isNaN(anyKey)) {//字符
                    let keyStr = key;
                    let value = INDIVIDUALMEMBERTYPE[key];
                    if (!memberTypeData[keyStr]) memberTypeData[keyStr] = 0;
                    if (info.individualMemberType == value) memberTypeData[keyStr] += 1;
                }
            }
        } else {
            for (let key in UNITMEMBERTYPE) {
                let anyKey:any = key;
                if (isNaN(anyKey)) {//字符
                    let keyStr = key;
                    let value = UNITMEMBERTYPE[key];
                    if (!memberTypeData[keyStr]) memberTypeData[keyStr] = 0;
                    if (info.unitMemberType == value) memberTypeData[keyStr] += 1;
                }
            }
        }
        
    })

    let dataInfo = {
        memberNum, //会员数量
        paid, //已缴费会员
        renewal, //续费期会员
        arrearsfees, //欠费会员
        gracePeriod, //宽限期会员
        freeze, //冻结会员
        memberLevelData, //会员等级
        memberTypeData //会员类型
    };

    return dataInfo;
}










