

import * as officialWebsiteBiz from "../../biz/officialWebsite";

export const FirstName = '官网路由';
export const FirstRouter = '/officialwebsite';
export const Config = {
    "首页":[
        {
            apiName:"banner图",
            subUrl:'/banner', 
            param:[],
            bindBiz:officialWebsiteBiz.banner
        },
        {
            apiName:"内容",
            subUrl:'/homepage', 
            param:[],
            bindBiz:officialWebsiteBiz.homePage
        },
    ],
    "学会概况":[
        {
            apiName:"学会概况",
            subUrl:'/xuehuigaikuang', 
            param:[],
            bindBiz:officialWebsiteBiz.xueHuiGaiKuang
        },
        {
            apiName:"学会概况banner",
            subUrl:'/xuehuigaikuang/banner', 
            param:[],
            bindBiz:officialWebsiteBiz.xueHuiGaiKuangBanner
            
        },
        {
            apiName:"学会概况详情",
            subUrl:'/xuehuigaikuangxiangqing', 
            param:[],
            bindBiz:officialWebsiteBiz.xueHuiGaiKuangXiangQing
        },
        {
            apiName:"学会规章列表（更多按钮触发）",
            subUrl:'/xuehuiguizhang', 
            param:[
                {key:"pageNumber", type:"Number", desc:"当前页"},
            ],
            bindBiz:officialWebsiteBiz.guiZhangLieBiaoFenYe
        },
        {
            apiName:"学会规则详情",
            subUrl:'/xuehuiguizhangxiangqing', 
            param:[
                {key:"id", type:"String", desc:"规章列表下发的标识"},
            ],
            bindBiz:officialWebsiteBiz.guiZhangZhiDuXiangQing
        },
    ],
    "动态资讯":[
        {
            apiName:"动态资讯列表",
            subUrl:'/dongtaizixun', 
            param:[
                {key:"type", type:"Number", desc:"政策动向学会动态行业风采，参考公用接口"},
                {key:"pageNumber", type:"Number", desc:"当前页"},
            ],
            bindBiz:officialWebsiteBiz.dongTaiZiXun
        },
        {
            apiName:"文章详情",
            subUrl:'/wenzhangxiangqing', 
            param:[
                {key:"id", type:"String", desc:"动态资讯列表中的标识"},
            ],
            bindBiz:officialWebsiteBiz.wenZhangXiangQing
        },
        {
            apiName:"热门排行",
            subUrl:'/remenpaihang', 
            param:[
                {key:"type", type:"Number", desc:"类型"}
            ],
            bindBiz:officialWebsiteBiz.reMenPaiHang
        }
    ],
    "品牌项目":[
        {
            apiName:"品牌项目banner",
            subUrl:'/pinpaixiangmubanner', 
            param:[],
            bindBiz:officialWebsiteBiz.pinPaiXiangMuBanner
        },
        {
            apiName:"品牌项目信息",
            subUrl:'/pinpaixiangmu', 
            param:[],
            bindBiz:officialWebsiteBiz.pinPaiXiangMu
        },
        {
            apiName:"学术研究列表",
            subUrl:'/xueshuyanjiu',
            param:[
                {key:"pageNumber", type:"Number", desc:"单前页"}
            ],
            bindBiz:officialWebsiteBiz.xueshuyanjiu
        },
        {
            apiName:"乡村振兴列表",
            subUrl:'/xiangcunzhenxing',
            param:[
                {key:"pageNumber", type:"Number", desc:"单前页"}
            ],
            bindBiz:officialWebsiteBiz.xiangCunZhenXing
        },
        {
            apiName:"芳华杯列表",
            subUrl:"/fanghuabei",
            param:[
                {key:"pageNumber", type:"Number", desc:"单前页"}
            ],
            bindBiz:officialWebsiteBiz.fangHuaBei
        }
    ],
    "党建工作":[
        {
            apiName:"主题教育",
            subUrl:'/zhutijiaoyu',
            param:[],
            bindBiz:officialWebsiteBiz.zhuTiJiaoYu
        },
        {
            apiName:"学习园地-视频图片",
            subUrl:'/xuexiyuandishipin',
            param:[],
            bindBiz:officialWebsiteBiz.xueXiYuanDiShiPin
        },
        {
            apiName:"学习园地-文字资料",
            subUrl:'/xuexiyuandiwenzi',
            param:[],
            bindBiz:officialWebsiteBiz.xueXiYuanDiWenZi
        },
        {
            apiName:"党建资源列表",
            subUrl:'/dangjianziyuan',
            param:[
                {key:"first", type:"Number", desc:"一级目录 参考公用接口"},
                {key:"secondary", type:"Number", desc:"二级目录 参考公用接口"},
                {key:"three", type:"Number", desc:"三级目录", isNull:true},
                {key:"pageNumber", type:"Number", desc:"单前页"}
            ],
            bindBiz:officialWebsiteBiz.dangJianZiYuan
        },
        {
            apiName:"党建资源目录列表",
            subUrl:'/dangjianziyuanmulu',
            param:[],
            bindBiz:officialWebsiteBiz.dangJianZiYuanMuLu
        },
        {
            apiName:"学习园地-文字资料类型",
            subUrl:'/xuexiyuandiwenzitype',
            param:[],
            bindBiz:officialWebsiteBiz.xueXiYuanDiWenZiType
        },
        {
            apiName:"学习园地-视频资料类型",
            subUrl:'/xuexiyuandishipintype',
            param:[],
            bindBiz:officialWebsiteBiz.xueXiYuanDiShiPinType
        }
    ],
    "通知公告":[
        {
            apiName:"主题教育",
            subUrl:'/tongzhigonggao',
            param:[
                {key:"type", type:"Number", desc:"类型 参考公用组件"},
                {key:"pageNumber", type:"Number", desc:"单前页"}
            ],
            bindBiz:officialWebsiteBiz.tongZhiGongGao
        },
        {
            apiName:"通知公告详情",
            subUrl:'/tongzhigonggaoinfo',
            param:[
                {key:"type", type:"Number", desc:"类型 参考公用组件"},
                {key:"id", type:"String", desc:"标识"}
            ],
            bindBiz:officialWebsiteBiz.tongZhiGongGaoInfo
        },
        
    ],
    "分支机构":[
        {
            apiName:"机构列表",
            subUrl:'/fenzhijigoulist',
            param:[],
            bindBiz:officialWebsiteBiz.fenZhiJiGou
        },
        {
            apiName:"分会动态",
            subUrl:'/fenhuidongtai',
            param:[
                {key:"pageNumber", type:"Number", desc:"当前页数"},
                {key:"agencyId", type:"String", desc:"分会id 不填就是全部", isNull:true}
            ],
            bindBiz:officialWebsiteBiz.fenHuiDongTai
        },
        {
            apiName:"分会详情",
            subUrl:'/fenhuixiangqing',
            param:[
                {key:"id", type:"String", desc:"分会id"}
            ],
            bindBiz:officialWebsiteBiz.fenHuiInfo   
        },
        {
            apiName:"分会动态详情页",
            subUrl:'/fenhuidongtaiinfo',
            param:[
                {key:"id", type:"String", desc:"动态id"}
            ],
            bindBiz:officialWebsiteBiz.fenHuiDongTaiInfo 
        },
        {
            apiName:"委员名单",
            subUrl:'/weiyuanmingdan',
            param:[
                {key:"name", type:"String", desc:"成员名称", isNull:true},
                {key:"agencyId", type:"String", desc:"分会id"},
                {key:"pageNumber", type:"Number", desc:"分页-页数"},
                {key:"pageSize", type:"Number", desc:"页面大小"}
            ],
            bindBiz:officialWebsiteBiz.weiYuanMingDanList
        }
        
    ],
    "会员服务":[
        {
            apiName:"证书查询",
            subUrl:'/zhengshuchaxun',
            param:[
                {key:"memberType", type:"Number", desc:"会员类型"},
                {key:"name", type:"String", desc:"个人会员姓名 or 单位会员名称"},
                {key:"carId", type:"String", desc:"个人会员身份证号码 or 单位会员统一信用代码"}
            ],
            bindBiz:officialWebsiteBiz.zhengShuChaXun
        },
        
    ]
}