/**
 * 消息活动通知
 */

import * as msgActivityBiz from "../../biz/member/msgActivity";
import { ACTIVITYTYPE } from "../../config/enum";

export const FirstName = '消息管理';
export const FirstRouter = '/manage/msgactivity';
export const Config = {
    "消息通知":[
        {
            apiName:"消息列表",
            subUrl:'/msgdb/msglist',
            param:[
                {key:"msgTitle", type:"String", desc:"消息标题", isNull:true},
                {key:"effectiveStartTime", type:"Number", desc:"有效开始时间", isNull:true},
                {key:"effectiveEndTime", type:"Number", desc:"有效结束时间", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:msgActivityBiz.getMessageList
        },
        {
            apiName:"新建消息",
            subUrl:'/msgdb/createmsg',
            param:[
                {key:"lableId", type:"[String]", desc:"标签Id（消息对象）"},
                {key:"msgTitle", type:"String", desc:"消息标题"},
                {key:"effectiveTime", type:"Number", desc:"有效时间"},
                {key:"msgContent", type:"String", desc:"消息内容"},
            ],
            bindBiz:msgActivityBiz.addMessage
        },
        {
            apiName:"修改消息",
            subUrl:'/msgdb/updatemsg',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        lableId:{type:'[String]', desc:'标签Id（消息对象）'},
                        msgTitle:{type:'String', desc:'消息标题'},
                        effectiveTime:{type:'Number', desc:'有效时间'},
                        msgContent:{type:'String', desc:'消息内容'},
                    }
                },
                {
                    key:"msgId", type:"String", desc:"消息Id"
                },
            ],
            bindBiz:msgActivityBiz.updateMessage
        },
        {
            apiName:"修改是否弹窗",
            subUrl:'/msgdb/updateispop',
            param:[
                {key:"msgId", type:"String", desc:"消息Id"},
                {key:"isPop", type:"Number", desc:"是否弹窗"},
            ],
            bindBiz:msgActivityBiz.updateIsPop
        },
        {
            apiName:"删除消息",
            subUrl:'/msgdb/delmsg',
            param:[
                {key:"msgId", type:"String", desc:"消息Id"},
            ],
            bindBiz:msgActivityBiz.delMessage
        },
        {
            apiName:"消息通知",
            subUrl:'/msgdb/noticemessage',
            param:[],
            bindBiz:msgActivityBiz.noticeMessage
        },
        {
            apiName:"全部已读",
            subUrl:'/msgdb/allmsgread',
            param:[
                {key:"msgId", type:"String", desc:"消息Id"},
            ],
            bindBiz:msgActivityBiz.allMsgRead
        },
        {
            apiName:"修改消息为已读",
            subUrl:'/msgdb/allmsgread',
            param:[
                {key:"readId", type:"String", desc:"消息已读Id"},
            ],
            bindBiz:msgActivityBiz.updateMsgRead
        },
    ],
    "活动通知":[
        {
            apiName:"活动列表",
            subUrl:'/activitydb/activitylist',
            param:[
                {key:"activityName", type:"String", desc:"活动名称", isNull:true},
                {key:"activityStartTime", type:"Number", desc:"活动开始时间", isNull:true},
                {key:"activityEndTime", type:"Number", desc:"活动结束时间", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:msgActivityBiz.getActivityList
        },
        {
            apiName:"新建线上活动",
            subUrl:'/activitydb/createactivity/upline',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        activityType:{type:'Number', desc:'活动类型'},
                        activityName:{type:'String', desc:'活动名称'},
                        enrollForm:{type:'String', desc:'报名表模板地址'},
                        activityAdd:{type:'String', desc:'活动地点'},
                        activityStartTime:{type:'Number', desc:'活动开始时间', notMustHave:true},
                        activityEndTime:{type:'Number', desc:'活动结束时间', notMustHave:true},
                        lableId:{type:'[String]', desc:'活动对象（标签Id）'},
                        enrollStartTime:{type:'Number', desc:'报名开始时间'},
                        enrollEndTime:{type:'Number', desc:'报名结束时间'},
                        activityContent:{type:'String', desc:'详细内容'},
                    }
                },
            ],
            bindBiz:msgActivityBiz.addActivity
        },
        {
            apiName:"新建线下活动",
            subUrl:'/activitydb/createactivity/downline',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        activityType:{type:'Number', desc:'活动类型'},
                        activityName:{type:'String', desc:'活动名称'},
                        enrollForm:{type:'String', desc:'报名表模板地址'},
                        activityAdd:{type:'String', desc:'活动地点'},
                        activityStartTime:{type:'Number', desc:'活动开始时间'},
                        activityEndTime:{type:'Number', desc:'活动结束时间'},
                        lableId:{type:'[String]', desc:'活动对象（标签Id）'},
                        enrollStartTime:{type:'Number', desc:'报名开始时间'},
                        enrollEndTime:{type:'Number', desc:'报名结束时间'},
                        activityContent:{type:'String', desc:'详细内容'},
                    }
                },
            ],
            bindBiz:msgActivityBiz.addActivity
        },
        {
            apiName:"获取活动详细-修改回显",
            subUrl:'/activitydb/activitydetailed',
            param:[
                {key:"activityId", type:"String", desc:"活动Id"},
            ],
            bindBiz:msgActivityBiz.getActivityDetailed
        },
        {
            apiName:"修改活动",
            subUrl:'/activitydb/updateactivity',
            param:[
                {
                    key:"form", type:"Object", sub:
                    {
                        activityName:{type:'String', desc:'活动名称'},
                        enrollForm:{type:'String', desc:'报名表模板地址'},
                        activityAdd:{type:'String', desc:'活动地点'},
                        activityStartTime:{type:'Number', desc:'活动开始时间', notMustHave:true},
                        activityEndTime:{type:'Number', desc:'活动结束时间', notMustHave:true},
                        lableId:{type:'[String]', desc:'活动对象（标签Id）'},
                        enrollStartTime:{type:'Number', desc:'报名开始时间'},
                        enrollEndTime:{type:'Number', desc:'报名结束时间'},
                        activityContent:{type:'String', desc:'详细内容'},
                    }
                },
                {
                    key:"activityId", type:"String", desc:"活动Id"
                },
            ],
            bindBiz:msgActivityBiz.updateActivity
        },
        {
            apiName:"删除活动",
            subUrl:'/activitydb/delactivity',
            param:[
                {key:"activityId", type:"String", desc:"活动Id"},
            ],
            bindBiz:msgActivityBiz.delActivity
        },
        {
            apiName:"修改是否置顶",
            subUrl:'/activitydb/updateistopup',
            param:[
                {key:"activityId", type:"String", desc:"活动Id"},
                {key:"isTopUp", type:"Number", desc:"是否置顶状态"},
            ],
            bindBiz:msgActivityBiz.updateIsTopUp
        },
        {
            apiName:"活动报名人员列表",
            subUrl:'/activitydb/enrolllist',
            param:[
                {key:"activityId", type:"String", desc:"活动Id"},
            ],
            bindBiz:msgActivityBiz.enrollList
        },
        {
            apiName:"根据选择的会员下载报名表",
            subUrl:'/activitydb/enrollurl',
            param:[
                {key:"id", type:"String", desc:"用户id"}
            ],
            bindBiz:msgActivityBiz.getEnrollUrl
        }
    ],
    "会员个人页活动通知":[
        {
            apiName:"下载报名表",
            subUrl:'/homepage/activityenrollform',
            param:[
                {key:"activityId", type:"String", desc:"活动Id"},
            ],
            bindBiz:msgActivityBiz.activityEnrollForm
        },
        {
            apiName:"申请报名表",
            subUrl:'/homepage/activityenroll',
            param:[
                {key:"activityId", type:"String", desc:"活动Id"},
                {key:"enrollUrl", type:"String", desc:"报名表地址"}
            ],
            bindBiz:msgActivityBiz.activityEnroll
        },
        {
            apiName:"查看活动",
            subUrl:'/homepage/seeactivity',
            param:[],
            bindBiz:msgActivityBiz.seeActivity
        },
        {
            apiName:"查看更多活动列表",
            subUrl:'/homepage/activitylist',
            param:[
                {key:"activityState", type:"Number", desc:"活动状态"},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:msgActivityBiz.homeActivityList
        },
        {
            apiName:"查看更多活动列表-详情",
            subUrl:'/homepage/activitydetailed',
            param:[
                {key:"activityId", type:"String", desc:"活动Id"},
            ],
            bindBiz:msgActivityBiz.homeActivityDetailed
        },

    ]
}













