/**
 * 标签
 */
import * as lableBiz from "../../biz/member/labelSystem";

export const FirstName = '标签相关';
export const FirstRouter = '/manage/lable';
export const Config = {
    "标签管理":[
        {
            apiName:"标签列表",
            subUrl:'/labledb/lablelist',
            param:[
                {key:"lableName", type:"String", desc:"标签名称", isNull:true},
                {key:"startCreateTime", type:"Number", desc:"创建开始时间", isNull:true},
                {key:"endCreateTime", type:"Number", desc:"创建结束时间", isNull:true},
                {key:"pageNumber", type:"Number", desc:"当前页"}
            ],
            bindBiz:lableBiz.lableList
        },
        {
            apiName:"新建标签",
            subUrl:'/labledb/createlable',
            param:[
                {key:"lableName", type:"String", desc:"标签名称"},
            ],
            bindBiz:lableBiz.createLable
        },
        {
            apiName:"重命名标签",
            subUrl:'/labledb/updatelable',
            param:[
                {key:"lableId", type:"String", desc:"标签Id"},
                {key:"lableName", type:"String", desc:"标签名称", isNull:true},
            ],
            bindBiz:lableBiz.updateLable
        },
        {
            apiName:"删除标签",
            subUrl:'/labledb/dellable',
            param:[
                {key:"lableId", type:"String", desc:"标签Id"},
            ],
            bindBiz:lableBiz.delLable
        },
        {
            apiName:"获取未选中的标签",
            subUrl:'/labledb/unchecked',
            param:[
                {key:"id", type:"String", desc:"用户id"},
            ],
            bindBiz:lableBiz.unCheckedLable
        },
        {
            apiName:"会员分配标签",
            subUrl:'/labledb/addmemberlable',
            param:[
                {key:"id", type:"String", desc:"用户id"},
                {key:"lableId", type:"[String]", desc:"选中新增的标签id"},
            ],
            bindBiz:lableBiz.addMemberLable
        },
        {
            apiName:"获取已选中的标签",
            subUrl:'/labledb/checked',
            param:[
                {key:"id", type:"String", desc:"用户id"},
            ],
            bindBiz:lableBiz.checkedLable
        },
        {
            apiName:"删除会员标签",
            subUrl:'/labledb/delmemberlable',
            param:[
                {key:"id", type:"String", desc:"用户id"},
                {key:"lableId", type:"[String]", desc:"需要删除的标签Id"},
            ],
            bindBiz:lableBiz.delMemberLable
        },
        // {
        //     apiName:"获取所有标签id",
        //     subUrl:'/labledb/getlable',
        //     param:[],
        //     bindBiz:lableBiz.getLable
        // }

    ]
}







