import moment = require("moment");
import { ARTICLEPOSITION, CLIENTACTIVITYLABLE, CLIENTMSGLABLE, DONGTAIZIXUNSUBTYPE, PARTYBUILDSUBTYPEENUM, PARTYBUILDTYPEENUM } from "../config/enum";
import { TABLEENUM } from "../data/models/model";
import { find } from "../data/select";
import { getEdition } from "../tools/system";

 
export function setEnumInterface({defaultParam}) {
    let dataList = [];
    for (let key in defaultParam) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            let value = defaultParam[key];
            if(/_dou/.test(keyStr)) keyStr = keyStr.replace(/_dou/, "，");
            if(/_zyh/.test(keyStr)) keyStr = keyStr.replace(/_zyh/, "“");
            if(/_yyh/.test(keyStr)) keyStr = keyStr.replace(/_yyh/, "”");
            if(/_dun/.test(keyStr)) keyStr = keyStr.replace(/_dun/, "、");
            if(/_ju/.test(keyStr)) keyStr = keyStr.replace(/_ju/, "。");
            if(/_hgh/.test(keyStr)) keyStr = keyStr.replace(/_hgh/, "-");
            if(/_kbh/.test(keyStr)) keyStr = keyStr.replace(/_kbh/, "");
            dataList.push({key:keyStr, value});
        }
    }
    return {dataList};
}


export function zhengCeZiXunLeiXing() {
    let conf = {};
    conf[DONGTAIZIXUNSUBTYPE.政策动向] = "Policy Tendence";
    conf[DONGTAIZIXUNSUBTYPE.学会动态] = "Assoclation dynamics";
    conf[DONGTAIZIXUNSUBTYPE.行业风采] = "Industry style";
    let dataList = [];
    for (let key in DONGTAIZIXUNSUBTYPE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            let value = DONGTAIZIXUNSUBTYPE[key];
            dataList.push({key:keyStr, value, keyEng:conf[value]});
        }
    }
    return {dataList}
}


export async function filePosition() {
    let dataList = [];
    for (let key in ARTICLEPOSITION) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            let keyStr = key;
            let value = ARTICLEPOSITION[key];
            if(/_dou/.test(keyStr)) keyStr = keyStr.replace(/_dou/, "，");
            if(/_zyh/.test(keyStr)) keyStr = keyStr.replace(/_zyh/, "“");
            if(/_yyh/.test(keyStr)) keyStr = keyStr.replace(/_yyh/, "”");
            if(/_dun/.test(keyStr)) keyStr = keyStr.replace(/_dun/, "、");
            if(/_ju/.test(keyStr)) keyStr = keyStr.replace(/_ju/, "。");
            if(/_hgh/.test(keyStr)) keyStr = keyStr.replace(/_hgh/, "-");
            if(/_kbh/.test(keyStr)) keyStr = keyStr.replace(/_kbh/, "");
            dataList.push({key:keyStr, value});
        }
    }
    // let wenZiDBList = await find(TABLEENUM.党建, {type:PARTYBUILDTYPEENUM.学习园地, subType:PARTYBUILDSUBTYPEENUM.文字资料});
    // wenZiDBList.forEach(info => {
    //     let {id, name} = info;
    //     dataList.push({key:`学习园地-${name}`, value:id});
    // });
    let zhuTiDBList = await find(TABLEENUM.党建, {type:PARTYBUILDTYPEENUM.主题教育});
    zhuTiDBList.forEach(info => {
        let {id, name} = info;
        dataList.push({key:`主题教育-${name}`, value:id});
    });

    return { dataList};
}


/**
 * 获取下拉框选择届次
 * @returns 
 */
export async function getSession() {
    const NowMs = new Date();
    let nowYear = parseInt(moment(NowMs).format("YYYY"));
    let nowMonth = parseInt(moment(NowMs).format("MM"));

    let session = [];
    for (let i = 2008; i <= nowYear; i++) {
        session.push({
            key:getEdition(i, 1),
            value:(i*100)+1
        });
        if (i==nowYear && nowMonth < 7) break
        session.push({
            key:getEdition(i, 7),
            value:(i*100)+7
        });
    }

    return {session}
}


/**
 * 获取所有标签
 */
 export async function getLable() {
    let lableInfo = await find(TABLEENUM.标签表, {}, ["lableId", "lableName"]);

    return lableInfo;
}


/**
 * 获取通知对象
 */
 export async function getMsgNoticeObject() {
    let lableData = setEnumInterface({defaultParam:CLIENTMSGLABLE});

    let lableInfo = await find(TABLEENUM.标签表, {}, ["lableId", "lableName"]);
    lableInfo.forEach( info => {
        let item = {key:info.lableName, value:info.lableId}
        lableData.dataList.push(item);
    })

    return {lableData};
}


/**
 * 获取通知对象
 */
 export async function getNoticeObject() {
    let lableData = setEnumInterface({defaultParam:CLIENTACTIVITYLABLE});

    let lableInfo = await find(TABLEENUM.标签表, {}, ["lableId", "lableName"]);
    lableInfo.forEach( info => {
        let item = {key:info.lableName, value:info.lableId}
        lableData.dataList.push(item);
    })

    return {lableData};
}




