/**
 * 学习园地   1.5版本已去除
 * 
 * 
 */

import { PARTYBUILDSUBTYPEENUM, PARTYBUILDTYPEENUM, STATE } from "../../../config/enum";
import { ERRORENUM } from "../../../config/errorEnum";
import { addManyData } from "../../../data/add";
import { TABLEENUM } from "../../../data/models/model";
import { find, findOnce } from "../../../data/select";
import { updateOneData } from "../../../data/update";
import { successResult } from "../../../tools/system";
import { BizError } from "../../../util/bizError";
import { wenZhangQueue } from "../../task";


export async function list() {
    let dbList = await find(TABLEENUM.党建, {type:PARTYBUILDTYPEENUM.学习园地});
    if (!dbList || !dbList.length) {
        let dbList = [
            {id:1100, type:PARTYBUILDTYPEENUM.学习园地, subType:PARTYBUILDSUBTYPEENUM.视频资料, display:true, name:"类型1"},
            {id:1101, type:PARTYBUILDTYPEENUM.学习园地, subType:PARTYBUILDSUBTYPEENUM.视频资料, display:true, name:"类型2"},
            {id:1102, type:PARTYBUILDTYPEENUM.学习园地, subType:PARTYBUILDSUBTYPEENUM.视频资料, display:true, name:"类型3"},
            {id:1200, type:PARTYBUILDTYPEENUM.学习园地, subType:PARTYBUILDSUBTYPEENUM.文字资料, display:true, name:"类型1"},
            {id:1201, type:PARTYBUILDTYPEENUM.学习园地, subType:PARTYBUILDSUBTYPEENUM.文字资料, display:true, name:"类型2"},
            {id:1202, type:PARTYBUILDTYPEENUM.学习园地, subType:PARTYBUILDSUBTYPEENUM.文字资料, display:true, name:"类型3"}
        ];
        await addManyData(TABLEENUM.党建, dbList);
    }
    let videoList = [];
    let fileList = [];
    dbList.forEach(info => {
        let {id, subType, name, display} = info;
        if (subType == PARTYBUILDSUBTYPEENUM.文字资料) {
            fileList.push({
                id,
                subType, 
                name, 
                display:display == STATE.是,
                count:"-"
            });
        } else {
            videoList.push({
                id,
                subType, 
                name, 
                display:display == STATE.是,
                count:"-"
            });
        }
    });

    return {fileList, videoList};
}


export async function update(secureArgs:any) {
    let {userId, id, typeName} = secureArgs;

    let oldInfo = await findOnce(TABLEENUM.党建, {id});
    if (!oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);

    await updateOneData(TABLEENUM.党建, {id}, {name:typeName});
    /**更新缓存名字 */
    wenZhangQueue[id] = typeName;

    return successResult();
}


export async function changeState({userId, id}) {
    let oldInfo = await findOnce(TABLEENUM.党建, {id});
    if (!oldInfo || !oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);

    let newPush = oldInfo.display == 1 ? 0 : 1;
    await updateOneData(TABLEENUM.党建, {id}, {display:newPush});

    return successResult();
}