/**
 * banner管理
 */


import { BANNERPOSITION } from "../../../config/enum";
import { ERRORENUM } from "../../../config/errorEnum";
import { addOneData } from "../../../data/add";
import { deleteOneData } from "../../../data/delete";
import { TABLEENUM } from "../../../data/models/model";
import { find, findCount, findOnce, findToPage } from "../../../data/select";
import { updateOneData } from "../../../data/update";
import { changeArticleName, generateSystemId, successResult } from "../../../tools/system";
import { BizError } from "../../../util/bizError";
import { extractData } from "../../../util/piecemeal";
import { changeEnumValue } from "../../../util/verificationEnum";


/**
 * 创建banner
 * @param userId 
 * @param param 
 * @returns 
 */
export async function create(secureArgs) {
    let {userId, form} = secureArgs;
    form.ct = new Date().valueOf();
    form.id = generateSystemId(TABLEENUM.banner管理, userId);
    await addOneData(TABLEENUM.banner管理, form);

    return successResult();
}


/**
 * 修改
 * @param userId 
 * @param id 
 * @param updateParam 
 * @returns 
 */
export async function update(secureArgs:any) {
    let {userId, id, form} = secureArgs;
    let oldInfo = await findOnce(TABLEENUM.banner管理, {id});
    if (!oldInfo || !oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);
   
    await updateOneData(TABLEENUM.banner管理, {id}, form);
    return successResult();
}


export async function del(secureArgs:any) {
    let {userId, id} = secureArgs;
    let dataInfo = await findOnce(TABLEENUM.banner管理, {id});
    if (!dataInfo || !dataInfo.id) throw new BizError(ERRORENUM.目标数据不存在);
    await deleteOneData(TABLEENUM.banner管理, {id});
    return successResult();
}


export async function list(secureArgs:any) {
    let {userId, title, pageNumber} = secureArgs;
    
    let selectParam:any = {};
    if (title) selectParam.title = title;

    let dbList = await findToPage(TABLEENUM.banner管理, selectParam, [ "id", "location","articleTitle", "position","articleUrl", "display", "desc"], pageNumber);
    let dataCount = await findCount(TABLEENUM.banner管理, selectParam);

    let dataList = [];
    for (let i = 0; i < dbList.length; i++) {
        let info = dbList[i];
        let item:any = extractData(info, [ "id", "location","articleTitle", "position","articleUrl", "display", "desc"]);
        let articleInfo = await findOnce(TABLEENUM.文章管理, {id:item.articleTitle}, ["id", "title"]);
        item.articleTitle = articleInfo.id ? articleInfo.title : '';
        item.location = changeEnumValue(BANNERPOSITION, item.location);
        item.position = changeArticleName([item.position]);
        dataList.push(item);
    }

    return {dataList, dataCount};
}

/**
 * 回显
 * @param id 
 */
export async function info(secureArgs:any) {
    let {id} = secureArgs;
    let oldInfo = await findOnce(TABLEENUM.banner管理, {id});
    let dataInfo = extractData(oldInfo, [ "id", "location", "articleTitle", "position", "imgUrl", "articleUrl", "desc"]);

    return { dataInfo };
}


export async function changePush({id}) {
    let oldInfo = await findOnce(TABLEENUM.banner管理, {id});
    if (!oldInfo || !oldInfo.id) throw new BizError(ERRORENUM.目标数据不存在);

    let newPush = oldInfo.display == 1 ? 0 : 1;
    await updateOneData(TABLEENUM.banner管理, {id}, {display:newPush});

    return successResult();
}